#version 330

layout(location = 0) in vec3 vertexPosition;
layout(location = 1) in vec2 textureCoordinate;

out vec2 texcoord;
out vec4 color;

uniform mat4 ModelViewMatrix;
uniform mat4 ProjectionMatrix;
uniform vec4 ColorMod = vec4 (1.0, 1.0, 1.0, 1.0);

void main() {
	gl_Position = ProjectionMatrix * ModelViewMatrix * vec4(vertexPosition, 1.0);
	texcoord = textureCoordinate;
	color = ColorMode;
}