/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileIO {
    public static void download(URL uRL, File file) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
            bufferedInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void print(char[] cArray) {
        for (int i = 0; i < cArray.length; i += 16) {
            Object object;
            int n;
            Object object2 = Integer.toHexString(i).toUpperCase();
            while (((String)object2).length() < 4) {
                object2 = "0" + (String)object2;
            }
            System.out.print((String)object2 + ":");
            for (n = i; n < i + 8; ++n) {
                if (n < cArray.length) {
                    object = Integer.toHexString(cArray[n]).toUpperCase();
                    while (((String)object).length() < 2) {
                        object = "0" + (String)object;
                    }
                    System.out.print(" " + (String)object);
                    continue;
                }
                System.out.print("   ");
            }
            System.out.print("|");
            for (n = i + 8; n < i + 16; ++n) {
                if (n < cArray.length) {
                    object = Integer.toHexString(cArray[n]).toUpperCase();
                    while (((String)object).length() < 2) {
                        object = "0" + (String)object;
                    }
                    System.out.print((String)object + " ");
                    continue;
                }
                System.out.print("   ");
            }
            System.out.print("  ");
            for (n = i; n < i + 16; ++n) {
                if (n >= cArray.length) continue;
                if (cArray[n] == '\n' || cArray[n] == '\u001c') {
                    System.out.print(".");
                    continue;
                }
                if (cArray[n] != '\u0000') {
                    System.out.print(cArray[n]);
                    continue;
                }
                System.out.print(".");
            }
            System.out.println();
        }
    }

    public static String read(BufferedReader bufferedReader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[1024];
        while (bufferedReader.read(cArray) != -1) {
            stringBuffer.append(cArray);
        }
        return stringBuffer.toString();
    }

    public static String read(File file) throws IOException {
        FileReader fileReader = new FileReader(file);
        CharBuffer charBuffer = CharBuffer.allocate((int)file.length());
        int n = fileReader.read(charBuffer);
        fileReader.close();
        if (n != 0) {
            charBuffer.flip();
        }
        return charBuffer.toString();
    }

    public static List<String> readLines(BufferedReader bufferedReader) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public static List<String> readLines(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        List<String> list = FileIO.readLines(bufferedReader);
        bufferedReader.close();
        return list;
    }

    public static void unzip(File file, File file2) {
        byte[] byArray = new byte[1024];
        try {
            if (!file2.exists()) {
                file2.mkdir();
            }
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                int n;
                String string = zipEntry.getName();
                File file3 = new File(String.valueOf(file2) + File.separator + string);
                System.out.println("file unzip : " + String.valueOf(file3.getAbsoluteFile()));
                new File(file3.getParent()).mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                while ((n = zipInputStream.read(byArray)) > 0) {
                    fileOutputStream.write(byArray, 0, n);
                }
                fileOutputStream.close();
                zipEntry = zipInputStream.getNextEntry();
            }
            zipInputStream.closeEntry();
            zipInputStream.close();
            System.out.println("Done");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void write(char[] cArray, File file) {
        try {
            byte[] byArray = new byte[cArray.length];
            for (int i = 0; i < cArray.length; ++i) {
                byArray[i] = (byte)cArray[i];
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void write(String string, File file) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(string);
            fileWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeAlt(char[] cArray, File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF-8").newEncoder());
            outputStreamWriter.write(cArray);
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

