/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.opengl.math;

import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class Math3D {
    public static float bilerp(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        double d = f7 * (f4 - f) * (f6 - f2);
        double d2 = f9 * (f - f3) * (f6 - f2);
        double d3 = f8 * (f4 - f) * (f2 - f5);
        double d4 = f10 * (f - f3) * (f2 - f5);
        double d5 = (f4 - f3) * (f6 - f5);
        double d6 = (d + d2 + d3 + d4) / d5;
        return (float)d6;
    }

    public static float clamp(float f, float f2, float f3) {
        assert (f2 < f3);
        if (f > f3) {
            return f3;
        }
        if (f < f2) {
            return f2;
        }
        return f;
    }

    public static Vector3f[] calcBezier(Vector3f[] vector3fArray, float f) {
        Vector3f vector3f = Math3D.lerp(vector3fArray[0], vector3fArray[1], f);
        Vector3f vector3f2 = Math3D.lerp(vector3fArray[1], vector3fArray[2], f);
        Vector3f vector3f3 = Math3D.lerp(vector3fArray[2], vector3fArray[3], f);
        Vector3f vector3f4 = Math3D.lerp(vector3f, vector3f2, f);
        Vector3f vector3f5 = Math3D.lerp(vector3f2, vector3f3, f);
        Vector3f vector3f6 = Math3D.lerp(vector3f4, vector3f5, f);
        Vector3f vector3f7 = new Vector3f();
        vector3f5.sub(vector3f4, vector3f7);
        vector3f7.normalize();
        Vector3f[] vector3fArray2 = new Vector3f[]{vector3f6, vector3f7};
        return vector3fArray2;
    }

    public static Vector3f calcTangent(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector2f vector2f, Vector2f vector2f2, Vector2f vector2f3) {
        Vector3f vector3f4 = new Vector3f();
        vector3f2.sub(vector3f, vector3f4);
        Vector3f vector3f5 = new Vector3f();
        vector3f3.sub(vector3f, vector3f5);
        Vector2f vector2f4 = new Vector2f();
        vector2f2.sub(vector2f, vector2f4);
        Vector2f vector2f5 = new Vector2f();
        vector2f3.sub(vector2f, vector2f5);
        float f = 1.0f / (vector2f4.x * vector2f5.y - vector2f4.y * vector2f5.x);
        Vector3f vector3f6 = new Vector3f();
        vector3f4.mul(vector2f5.y);
        vector3f5.mul(vector2f4.y);
        vector3f4.sub(vector3f5, vector3f6);
        vector3f6.mul(f);
        return vector3f6;
    }

    public static Matrix4f createDirRotMatrix(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4) {
        Matrix4f matrix4f = new Matrix4f();
        Math3D.setDirRotMatrix(vector3f, vector3f2, vector3f3, vector3f4, matrix4f);
        return matrix4f;
    }

    public static Matrix4f createLookAtMatrix(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        Matrix4f matrix4f = new Matrix4f();
        Math3D.setLookAtMatrix(f, f2, f3, f4, f5, f6, f7, f8, f9, matrix4f);
        return matrix4f;
    }

    public static Matrix4f createOrtho2DProjectionMatrix(float f, float f2, float f3, float f4) {
        Matrix4f matrix4f = new Matrix4f();
        Math3D.setOrtho2DProjectionMatrix(f, f2, f3, f4, matrix4f);
        return matrix4f;
    }

    public static Matrix4f createOrthoProjectionMatrix(float f, float f2, float f3, float f4, float f5, float f6) {
        Matrix4f matrix4f = new Matrix4f();
        Math3D.setOrthoProjectionMatrix(f, f2, f3, f4, f5, f6, matrix4f);
        return matrix4f;
    }

    public static Matrix4f createPerspectiveProjectionMatrix(float f, float f2, float f3, float f4) {
        Matrix4f matrix4f = new Matrix4f();
        Math3D.setPerspectiveProjectionMatrix(f, f2, f3, f4, matrix4f);
        return matrix4f;
    }

    public static float distance(Vector2f vector2f, Vector2f vector2f2) {
        float f = vector2f2.x - vector2f.x;
        float f2 = vector2f2.y - vector2f.y;
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    public static float distance(Vector3f vector3f, Vector3f vector3f2) {
        float f = vector3f2.x - vector3f.x;
        float f2 = vector3f2.y - vector3f.y;
        float f3 = vector3f2.z - vector3f.z;
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    public static Vector2f lerp(Vector2f vector2f, Vector2f vector2f2, float f) {
        Vector2f vector2f3 = new Vector2f(vector2f);
        Vector2f vector2f4 = new Vector2f(vector2f2);
        vector2f3.mul(1.0f - f);
        vector2f4.mul(f);
        vector2f3.add(vector2f4);
        return vector2f3;
    }

    public static Vector3f lerp(Vector3f vector3f, Vector3f vector3f2, float f) {
        Vector3f vector3f3 = new Vector3f(vector3f);
        Vector3f vector3f4 = new Vector3f(vector3f2);
        vector3f3.mul(1.0f - f);
        vector3f4.mul(f);
        vector3f3.add(vector3f4);
        return vector3f3;
    }

    public static boolean lineTriangleIntersection(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, Vector3f vector3f5, Vector3f[] vector3fArray) {
        Vector3f vector3f6 = vector3f;
        Vector3f vector3f7 = new Vector3f();
        vector3f2.sub(vector3f6, vector3f7);
        Vector3f vector3f8 = vector3f3;
        Vector3f vector3f9 = vector3f5;
        Vector3f vector3f10 = vector3f4;
        Vector3f vector3f11 = new Vector3f();
        vector3f9.sub(vector3f8, vector3f11);
        Vector3f vector3f12 = new Vector3f();
        vector3f10.sub(vector3f8, vector3f12);
        Vector3f vector3f13 = new Vector3f();
        vector3f7.cross(vector3f12, vector3f13);
        float f = vector3f11.dot(vector3f13);
        if (f < 0.0f) {
            return false;
        }
        float f2 = 0.0f;
        if (f > -f2 && f < f2) {
            return false;
        }
        float f3 = 1.0f / f;
        Vector3f vector3f14 = new Vector3f();
        vector3f6.sub(vector3f8, vector3f14);
        float f4 = f3 * vector3f14.dot(vector3f13);
        if (f4 < 0.0f) {
            return false;
        }
        Vector3f vector3f15 = new Vector3f();
        vector3f14.cross(vector3f11, vector3f15);
        float f5 = f3 * vector3f7.dot(vector3f15);
        if ((double)f5 < 0.0 | f4 + f5 > 1.0f) {
            return false;
        }
        if (vector3fArray != null && vector3fArray.length == 2) {
            float f6 = f3 * vector3f12.dot(vector3f15);
            Vector3f vector3f16 = new Vector3f(f6, f4, f5);
            vector3f8.mul(1.0f - f4 - f5);
            vector3f9.mul(f4);
            vector3f10.mul(f5);
            Vector3f vector3f17 = new Vector3f(0.0f, 0.0f, 0.0f);
            vector3f17.add(vector3f8);
            vector3f17.add(vector3f9);
            vector3f17.add(vector3f10);
            vector3fArray[0] = vector3f16;
            vector3fArray[1] = vector3f17;
        }
        return true;
    }

    public static Vector3f rotate(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        Vector4f vector4f = new Vector4f(f, f2, f3, 0.0f);
        vector4f.normalize();
        Vector3f vector3f = new Vector3f(f4, f5, f6);
        vector3f.normalize();
        new Matrix4f().identity().rotate(f7, vector3f).transform(vector4f).normalize();
        return new Vector3f(vector4f.x, vector4f.y, vector4f.z);
    }

    public static Vector3f rotateQuaternions(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        Vector3f vector3f = new Vector3f(f, f2, f3);
        vector3f.normalize();
        Vector3f vector3f2 = new Vector3f(f4, f5, f6);
        vector3f2.normalize();
        float f8 = (float)Math.cos(0.5 * (double)f7);
        float f9 = vector3f2.x * (float)Math.sin(0.5 * (double)f7);
        float f10 = vector3f2.y * (float)Math.sin(0.5 * (double)f7);
        float f11 = vector3f2.z * (float)Math.sin(0.5 * (double)f7);
        Matrix3f matrix3f = new Matrix3f();
        matrix3f.m00 = f8 * f8 + f9 * f9 - f10 * f10 - f11 * f11;
        matrix3f.m01 = 2.0f * f9 * f10 - 2.0f * f8 * f11;
        matrix3f.m02 = 2.0f * f9 * f11 + 2.0f * f8 * f10;
        matrix3f.m10 = 2.0f * f9 * f10 + 2.0f * f8 * f11;
        matrix3f.m11 = f8 * f8 - f9 * f9 + f10 * f10 - f11 * f11;
        matrix3f.m12 = 2.0f * f10 * f11 - 2.0f * f8 * f9;
        matrix3f.m20 = 2.0f * f9 * f11 - 2.0f * f8 * f10;
        matrix3f.m21 = 2.0f * f10 * f11 + 2.0f * f8 * f9;
        matrix3f.m22 = f8 * f8 - f9 * f9 - f10 * f10 + f11 * f11;
        matrix3f.transform(vector3f).normalize();
        return vector3f;
    }

    public static void setAlignToViewplaneMatrix(Vector3f vector3f, Vector3f vector3f2, Matrix4f matrix4f) {
        Vector3f vector3f3 = new Vector3f(vector3f);
        vector3f3.negate().normalize();
        Vector3f vector3f4 = new Vector3f();
        vector3f2.cross(vector3f3, vector3f4).normalize();
        Vector3f vector3f5 = new Vector3f();
        vector3f3.cross(vector3f4, vector3f5).normalize();
        Math3D.setColMatrix(vector3f4, vector3f5, vector3f3, matrix4f);
    }

    public static void setAlignToViewplaneMatrix(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Matrix4f matrix4f) {
        Vector3f vector3f4 = new Vector3f();
        vector3f.sub(vector3f2, vector3f4);
        vector3f4.normalize();
        Math3D.setAlignToViewplaneMatrix(vector3f4, vector3f3, matrix4f);
    }

    public static void setAlignToViewpointMatrix(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Matrix4f matrix4f) {
        Vector3f vector3f4 = new Vector3f();
        vector3f.sub(vector3f2, vector3f4).normalize();
        Vector3f vector3f5 = new Vector3f();
        vector3f3.cross(vector3f4, vector3f5).normalize();
        Vector3f vector3f6 = new Vector3f();
        vector3f4.cross(vector3f5, vector3f6).normalize();
        Math3D.setColMatrix(vector3f5, vector3f6, vector3f4, matrix4f);
    }

    public static void setColMatrix(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Matrix4f matrix4f) {
        matrix4f.m00(vector3f.x);
        matrix4f.m01(vector3f.y);
        matrix4f.m02(vector3f.z);
        matrix4f.m03(0.0f);
        matrix4f.m10(vector3f2.x);
        matrix4f.m11(vector3f2.y);
        matrix4f.m12(vector3f2.z);
        matrix4f.m13(0.0f);
        matrix4f.m20(vector3f3.x);
        matrix4f.m21(vector3f3.y);
        matrix4f.m22(vector3f3.z);
        matrix4f.m23(0.0f);
        matrix4f.m30(0.0f);
        matrix4f.m31(0.0f);
        matrix4f.m32(0.0f);
        matrix4f.m33(1.0f);
    }

    public static void setDirRotMatrix(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, Matrix4f matrix4f) {
        vector3f.normalize();
        Vector3f vector3f5 = new Vector3f();
        vector3f.cross(vector3f2, vector3f5);
        vector3f5.normalize();
        Vector3f vector3f6 = new Vector3f();
        vector3f.cross(vector3f5, vector3f6);
        vector3f6.normalize();
        Math3D.setColMatrix(vector3f5, vector3f6, vector3f, matrix4f);
    }

    public static void setLookAtMatrix(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, Matrix4f matrix4f) {
        Vector3f vector3f = new Vector3f(f4 - f, f5 - f2, f6 - f3);
        vector3f.normalize();
        Vector3f vector3f2 = new Vector3f(f7, f8, f9);
        vector3f2.normalize();
        Vector3f vector3f3 = new Vector3f();
        vector3f.cross(vector3f2, vector3f3);
        Vector3f vector3f4 = new Vector3f(vector3f3);
        vector3f4.normalize();
        vector3f4.cross(vector3f);
        matrix4f.identity();
        matrix4f.m00(vector3f3.x);
        matrix4f.m10(vector3f3.y);
        matrix4f.m20(vector3f3.z);
        matrix4f.m01(vector3f4.x);
        matrix4f.m11(vector3f4.y);
        matrix4f.m21(vector3f4.z);
        matrix4f.m02(-vector3f.x);
        matrix4f.m12(-vector3f.y);
        matrix4f.m22(-vector3f.z);
        matrix4f.m33(1.0f);
        matrix4f.translate(new Vector3f(-f, -f2, -f3));
    }

    public static void setLookAtMatrix_front(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, Matrix4f matrix4f) {
        Vector3f vector3f = new Vector3f(f4, f5, f6);
        vector3f.normalize();
        Vector3f vector3f2 = new Vector3f(f7, f8, f9);
        vector3f2.normalize();
        Vector3f vector3f3 = new Vector3f();
        vector3f.cross(vector3f2, vector3f3);
        Vector3f vector3f4 = new Vector3f(vector3f3);
        vector3f4.normalize();
        vector3f4.cross(vector3f);
        matrix4f.identity();
        matrix4f.m00(vector3f3.x);
        matrix4f.m10(vector3f3.y);
        matrix4f.m20(vector3f3.z);
        matrix4f.m01(vector3f4.x);
        matrix4f.m11(vector3f4.y);
        matrix4f.m21(vector3f4.z);
        matrix4f.m02(-vector3f.x);
        matrix4f.m12(-vector3f.y);
        matrix4f.m22(-vector3f.z);
        matrix4f.m33(1.0f);
        matrix4f.translate(new Vector3f(-f, -f2, -f3));
    }

    public static void setOrtho2DProjectionMatrix(float f, float f2, float f3, float f4, Matrix4f matrix4f) {
        matrix4f.identity();
        matrix4f.m00(2.0f / (f2 - f));
        matrix4f.m11(2.0f / (f4 - f3));
        matrix4f.m22(-1.0f);
        matrix4f.m30(-(f2 + f) / (f2 - f));
        matrix4f.m31(-(f4 + f3) / (f4 - f3));
        matrix4f.m32(0.0f);
        matrix4f.m33(1.0f);
    }

    public static void setOrthoProjectionMatrix(float f, float f2, float f3, float f4, float f5, float f6, Matrix4f matrix4f) {
        matrix4f.identity();
        matrix4f.m00(2.0f / (f2 - f));
        matrix4f.m11(2.0f / (f4 - f3));
        matrix4f.m22(-2.0f / (f6 - f5));
        matrix4f.m30(-(f2 + f) / (f2 - f));
        matrix4f.m31(-(f4 + f3) / (f4 - f3));
        matrix4f.m32(-(f6 + f5) / (f6 - f5));
        matrix4f.m33(1.0f);
    }

    public static void setPerspectiveProjectionMatrix(float f, float f2, float f3, float f4, Matrix4f matrix4f) {
        float f5 = (float)(1.0 / Math.tan(Math.toRadians(f / 2.0f)));
        float f6 = f5 / f2;
        matrix4f.identity();
        matrix4f.m00(f6);
        matrix4f.m11(f5);
        matrix4f.m22(-((f4 + f3) / (f4 - f3)));
        matrix4f.m23(-1.0f);
        matrix4f.m32(-(2.0f * f4 * f3 / (f4 - f3)));
        matrix4f.m33(0.0f);
    }

    public static Vector4f unproject(float f, float f2, float f3, Matrix4f matrix4f, Matrix4f matrix4f2, Vector4f vector4f) {
        float f4 = 2.0f * (f - vector4f.x) / vector4f.z - 1.0f;
        float f5 = 2.0f * (f2 - vector4f.y) / vector4f.w - 1.0f;
        float f6 = 2.0f * f3 - 1.0f;
        float f7 = 1.0f;
        Vector4f vector4f2 = new Vector4f(f4, f5, f6, f7);
        Matrix4f matrix4f3 = new Matrix4f();
        matrix4f2.mul(matrix4f, matrix4f3).invert();
        Vector4f vector4f3 = new Vector4f();
        matrix4f3.transform(vector4f2, vector4f3);
        return vector4f3;
    }
}

