/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.opengl;

import de.slashbinbash.opengl.Image;
import de.slashbinbash.opengl.ImageFactory;
import de.slashbinbash.opengl.Texture;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import org.lwjgl.opengl.GL11;

public class TextureBuilder {
    public int width = 0;
    public int height = 0;
    public int format = 0;
    public ByteBuffer bb = null;
    public int wrap_s = 33069;
    public int wrap_t = 33069;
    public int magFilter = 9728;
    public int minFilter = 9728;

    public static void deleteTexture(Texture texture) {
        GL11.glDeleteTextures((int)texture.id);
    }

    public static TextureBuilder from(BufferedImage bufferedImage) {
        return TextureBuilder.from(ImageFactory.createImage(bufferedImage));
    }

    public static TextureBuilder from(File file) throws IOException {
        return TextureBuilder.from(ImageIO.read(file));
    }

    public static TextureBuilder from(Image image) {
        return new TextureBuilder(image.width, image.height, image.format, image.getBuffer());
    }

    public static void updateTexture(Texture texture, Image image) {
        assert (image.getHeight() == texture.height);
        assert (image.getWidth() == texture.width);
        GL11.glBindTexture((int)3553, (int)texture.id);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)texture.width, (int)texture.height, (int)image.getFormat(), (int)5121, (ByteBuffer)image.getBuffer());
        GL11.glBindTexture((int)3553, (int)0);
    }

    public static void updateTexture(Texture texture, BufferedImage bufferedImage) {
        Image image = ImageFactory.createImage(bufferedImage);
        assert (image.getHeight() == texture.height);
        assert (image.getWidth() == texture.width);
        GL11.glBindTexture((int)3553, (int)texture.id);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)texture.width, (int)texture.height, (int)image.getFormat(), (int)5121, (ByteBuffer)image.getBuffer());
        GL11.glBindTexture((int)3553, (int)0);
    }

    public TextureBuilder(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public TextureBuilder(int n, int n2, int n3, ByteBuffer byteBuffer) {
        this.width = n;
        this.height = n2;
        this.format = n3;
        this.bb = byteBuffer;
    }

    public Texture build() {
        int n = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)n);
        GL11.glTexParameteri((int)3553, (int)10242, (int)this.wrap_s);
        GL11.glTexParameteri((int)3553, (int)10243, (int)this.wrap_t);
        GL11.glTexParameteri((int)3553, (int)10240, (int)this.magFilter);
        GL11.glTexParameteri((int)3553, (int)10241, (int)this.minFilter);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.width, (int)this.height, (int)0, (int)this.format, (int)5121, (ByteBuffer)this.bb);
        GL11.glBindTexture((int)3553, (int)0);
        return new Texture(n, this.width, this.height, this.format);
    }

    public TextureBuilder setImage(BufferedImage bufferedImage) {
        return this.setImage(ImageFactory.createImage(bufferedImage));
    }

    public TextureBuilder setImage(File file) throws IOException {
        return this.setImage(ImageIO.read(file));
    }

    public TextureBuilder setImage(Image image) {
        this.width = image.width;
        this.height = image.height;
        this.format = image.format;
        this.bb = image.getBuffer();
        return this;
    }

    public TextureBuilder setMagFilter(int n) {
        this.magFilter = n;
        return this;
    }

    public TextureBuilder setMinFilter(int n) {
        this.minFilter = n;
        return this;
    }

    public TextureBuilder setWrap(int n, int n2) {
        this.wrap_s = n;
        this.wrap_t = n2;
        return this;
    }
}

