/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.opengl;

import java.nio.FloatBuffer;
import java.util.Hashtable;
import org.joml.Matrix4f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;

public class Shader {
    public final int id;
    private final FloatBuffer fb = BufferUtils.createFloatBuffer(16);
    private Hashtable<String, Integer> locations = new Hashtable(10);
    private boolean enabled = false;

    public Shader(int n) {
        this.id = n;
    }

    public void disable() {
        assert (this.enabled);
        GL20.glUseProgram((int)0);
        this.enabled = false;
    }

    public void enable() {
        assert (!this.enabled);
        GL20.glUseProgram((int)this.id);
        this.enabled = true;
    }

    private int getLocation(String string) {
        int n = -1;
        if (this.locations.containsKey(string)) {
            n = this.locations.get(string);
        } else {
            n = GL20.glGetUniformLocation((int)this.id, (CharSequence)string);
            this.locations.put(string, n);
        }
        assert (n != -1) : "Could not get location for name '" + string + "'.";
        return n;
    }

    public void setUniform1i(String string, int n) {
        assert (this.enabled) : "Enable program";
        GL20.glUniform1i((int)this.getLocation(string), (int)n);
    }

    public void setUniform2f(String string, float f, float f2) {
        assert (this.enabled) : "Enable program";
        GL20.glUniform2f((int)this.getLocation(string), (float)f, (float)f2);
    }

    public void setUniform4f(String string, float f, float f2, float f3, float f4) {
        assert (this.enabled) : "Enable program";
        GL20.glUniform4f((int)this.getLocation(string), (float)f, (float)f2, (float)f3, (float)f4);
    }

    public void setUniform4fv(String string, float[] fArray) {
        assert (this.enabled) : "Enable program";
        GL20.glUniform4fv((int)this.getLocation(string), (float[])fArray);
    }

    public void setUniformMatrix4f(String string, Matrix4f matrix4f) {
        assert (this.enabled) : "Enable program";
        matrix4f.get(this.fb);
        GL20.glUniformMatrix4fv((int)this.getLocation(string), (boolean)false, (FloatBuffer)this.fb);
        this.fb.clear();
    }
}

