/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.opengl;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;

public class Image {
    public static final int FORMAT_RGB = 6407;
    public static final int FORMAT_RGBA = 6408;
    public ByteBuffer bb;
    public final int format;
    public final int height;
    public final int width;

    public Image(ByteBuffer byteBuffer, int n, int n2, int n3) {
        this.bb = byteBuffer;
        this.width = n;
        this.height = n2;
        this.format = n3;
    }

    public Image(int n, int n2, int n3) {
        this.width = n;
        this.height = n2;
        this.format = n3;
        int n4 = n * n2 * this.getSize(n3);
        this.bb = BufferUtils.createByteBuffer(n4);
        this.bb.position(n4);
        this.bb.flip();
    }

    public void clear() {
        this.bb.clear();
        this.bb = null;
    }

    public ByteBuffer getBuffer() {
        return this.bb;
    }

    public int getFormat() {
        return this.format;
    }

    public int getHeight() {
        return this.height;
    }

    private int getIndex(int n, int n2) {
        return (n2 * this.width + n) * this.getSize(this.format);
    }

    private int getSize(int n) {
        switch (n) {
            case 6407: {
                return 3;
            }
            case 6408: {
                return 4;
            }
        }
        return 0;
    }

    public int getWidth() {
        return this.width;
    }

    public void put(int n, int n2, int n3, int n4, int n5) {
        int n6 = this.getIndex(n, n2);
        switch (this.format) {
            case 6407: {
                this.bb.put(n6, (byte)n3);
                this.bb.put(n6 + 1, (byte)n4);
                this.bb.put(n6 + 2, (byte)n5);
                break;
            }
            case 6408: {
                this.bb.put(n6, (byte)n3);
                this.bb.put(n6 + 1, (byte)n4);
                this.bb.put(n6 + 2, (byte)n5);
                this.bb.put(n6 + 3, (byte)-1);
                break;
            }
        }
    }

    public void put(int n, int n2, int n3, int n4, int n5, int n6) {
        assert (this.format == 6408);
        int n7 = this.getIndex(n, n2);
        this.bb.put(n7, (byte)n3);
        this.bb.put(n7 + 1, (byte)n4);
        this.bb.put(n7 + 2, (byte)n5);
        this.bb.put(n7 + 3, (byte)n6);
    }
}

