/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.opengl;

import de.slashbinbash.opengl.Font;
import de.slashbinbash.opengl.ImageFactory;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;

public class FontFactory {
    public static Font createFont(File file) throws IOException {
        try {
            ZipFile zipFile = new ZipFile(file);
            ZipEntry zipEntry = zipFile.getEntry("font.properties");
            Properties properties = new Properties();
            properties.load(zipFile.getInputStream(zipEntry));
            int n = Integer.parseInt(properties.getProperty("charWidth"));
            int n2 = Integer.parseInt(properties.getProperty("charHeight"));
            String string = properties.getProperty("file", n + "x" + n2 + ".png");
            String string2 = properties.getProperty("format").toLowerCase();
            int n3 = 0;
            switch (string2) {
                case "ascii_16x16": {
                    n3 = 1;
                    break;
                }
                case "ascii_33_126": {
                    n3 = 2;
                }
            }
            Object object = zipFile.getEntry(string);
            BufferedImage bufferedImage = ImageIO.read(zipFile.getInputStream((ZipEntry)object));
            zipFile.close();
            return FontFactory.createFont(bufferedImage, n, n2, n3);
        }
        catch (ZipException zipException) {
            zipException.printStackTrace();
            return null;
        }
    }

    public static Font createFont(BufferedImage bufferedImage, int n, int n2, int n3) {
        Font font = new Font();
        font.format = n3;
        font.charWidth = n;
        font.charHeight = n2;
        font.image = ImageFactory.createImage(bufferedImage);
        return font;
    }
}

