/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.workbench;

import de.slashbinbash.hexen.check.CheckFactory;
import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.factory.SceneFactory;
import de.slashbinbash.hexen.model.Recipe;
import de.slashbinbash.hexen.workbench.Craft;
import de.slashbinbash.hexen.workbench.Workbench;
import de.slashbinbash.util.StaticXML;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WorkbenchFactory {
    public static Workbench.Data createWorkbenchData(Element element) {
        Workbench.Data data = new Workbench.Data();
        block24: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "description": {
                    data.description = Factory.unformatMD(StaticXML.getText(element2));
                    break;
                }
                case "scene": {
                    data.scene = SceneFactory.createScene(element2);
                    break;
                }
                case "assemble": {
                    Craft.Data data2;
                    String string;
                    if (data.assemble == null) {
                        data.assemble = new Workbench.Category();
                    }
                    if (StaticXML.hasAttribute(element2, "ratio")) {
                        data.assemble.durationRatio = StaticXML.getFloat(element2, "ratio");
                    }
                    block25: for (Element element3 : StaticXML.getChildElements(element2)) {
                        switch (element3.getTagName()) {
                            case "item": {
                                string = StaticXML.getAttribute(element3, "ref");
                                data2 = WorkbenchFactory.createCraftData(string);
                                if (data2.assemble == null) continue block25;
                                data.assemble.recipes.add(data2.assemble);
                                continue block25;
                            }
                        }
                        StaticXML.errUnknownTag(element3);
                    }
                    continue block24;
                }
                case "disassemble": {
                    Craft.Data data2;
                    String string;
                    if (data.disassemble == null) {
                        data.disassemble = new Workbench.Category();
                    }
                    if (StaticXML.hasAttribute(element2, "ratio")) {
                        data.disassemble.durationRatio = StaticXML.getFloat(element2, "ratio");
                    }
                    block26: for (Element element3 : StaticXML.getChildElements(element2)) {
                        switch (element3.getTagName()) {
                            case "item": {
                                string = StaticXML.getAttribute(element3, "ref");
                                data2 = WorkbenchFactory.createCraftData(string);
                                if (data2.disassemble == null) continue block26;
                                data.disassemble.recipes.add(data2.disassemble);
                                continue block26;
                            }
                        }
                        StaticXML.errUnknownTag(element3);
                    }
                    continue block24;
                }
                default: {
                    StaticXML.errUnknownTag(element2);
                }
            }
        }
        return data;
    }

    public static Workbench.Data createWorkbenchData(String string) {
        try {
            File file = new File(Factory.WORKBENCH_PATH + string + ".xml");
            Document document = StaticXML.loadXML(file);
            Element element = document.getDocumentElement();
            Workbench.Data data = WorkbenchFactory.createWorkbenchData(element);
            data.__id__ = string;
            return data;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Recipe createRecipe(Element element) {
        Recipe recipe = new Recipe();
        block12: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "requirements": {
                    recipe.requirements = CheckFactory.createChecks(element2);
                    continue block12;
                }
                case "duration": {
                    recipe.duration = Factory.parseDuration(element2);
                    continue block12;
                }
                case "input": {
                    recipe.input = Factory.createItemGroups(element2);
                    continue block12;
                }
                case "output": {
                    recipe.output = Factory.createItemGroups(element2);
                    continue block12;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return recipe;
    }

    public static Craft.Data createCraftData(String string) {
        try {
            File file = new File(Factory.ITEM_PATH + string + ".xml");
            Document document = StaticXML.loadXML(file);
            Element element = document.getDocumentElement();
            Element element2 = StaticXML.getElement(element, "craft");
            if (element2 == null) {
                return null;
            }
            String string2 = StaticXML.getText(StaticXML.getElement(element, "name"));
            assert (!string2.isEmpty());
            Craft.Data data = new Craft.Data();
            data.__id__ = string;
            block10: for (Element element3 : StaticXML.getChildElements(element2)) {
                switch (element3.getTagName()) {
                    case "assemble": {
                        data.assemble = WorkbenchFactory.createRecipe(element3);
                        data.assemble.__id__ = string;
                        data.assemble.name = string2;
                        continue block10;
                    }
                    case "disassemble": {
                        data.disassemble = WorkbenchFactory.createRecipe(element3);
                        data.disassemble.__id__ = string;
                        data.disassemble.name = string2;
                        continue block10;
                    }
                }
                StaticXML.errUnknownTag(element3);
            }
            return data;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

