/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.view;

import de.slashbinbash.hexen.handler.HandlerBase;
import de.slashbinbash.hexen.renderer.ButtonRenderer;
import de.slashbinbash.hexen.view.StaticView;
import de.slashbinbash.opengl.Color;
import de.slashbinbash.opengl.math.Rect2f;
import de.slashbinbash.opengl.renderer.Draw2D;

public class ViewBase {
    private static final Rect2f LC = StaticView.LEFT_COLUMN;
    private static final Rect2f RC = StaticView.RIGHT_COLUMN;

    public static void draw(Draw2D draw2D, HandlerBase handlerBase) {
        StaticView.drawBackground(draw2D);
        StaticView.drawStatusBar(draw2D);
        if (handlerBase.scene != null) {
            StaticView.drawPortrait(draw2D, handlerBase.scene);
        } else {
            StaticView.drawPortrait(draw2D, null, "");
        }
        StaticView.drawBottomPane(draw2D);
        if (handlerBase.leftText != null) {
            draw2D.setColor(Color.WHITE);
            draw2D.drawString(ViewBase.LC.x, ViewBase.LC.y, handlerBase.leftText);
        }
        if (handlerBase.rightText != null) {
            draw2D.setColor(Color.WHITE);
            draw2D.drawString(ViewBase.RC.x, ViewBase.RC.y, handlerBase.rightText);
        }
        switch (handlerBase.mode) {
            case Default: {
                if (0 <= handlerBase.buttonIndex && handlerBase.buttonIndex < handlerBase.buttons.size()) {
                    ButtonRenderer.drawSelectionHighlight(draw2D, handlerBase.buttons.get(handlerBase.buttonIndex));
                }
                ButtonRenderer.drawButtons(draw2D, handlerBase.buttons, ButtonRenderer.Style.Item);
                break;
            }
            case Input: {
                draw2D.setColor(Color.WHITE);
                draw2D.drawString(ViewBase.LC.x - 8.0f, ViewBase.LC.y + 8.0f, ">");
                draw2D.drawString(ViewBase.LC.x, ViewBase.LC.y + 8.0f, handlerBase.getInput());
                draw2D.drawString(ViewBase.LC.x + (float)handlerBase.getInputLength() * 8.0f, ViewBase.LC.y + 8.0f, "_");
            }
        }
    }
}

