/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.view;

import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.enums.Direction;
import de.slashbinbash.hexen.handler.SpaceHandler;
import de.slashbinbash.hexen.map.Level;
import de.slashbinbash.hexen.map.Location;
import de.slashbinbash.hexen.renderer.ButtonRenderer;
import de.slashbinbash.hexen.renderer.Map2DGridRenderer;
import de.slashbinbash.hexen.renderer.Map2DSpriteRenderer;
import de.slashbinbash.hexen.renderer.Map3DRenderer;
import de.slashbinbash.hexen.renderer.MapIsoRenderer;
import de.slashbinbash.hexen.renderer.MapRenderer;
import de.slashbinbash.hexen.ui.Button;
import de.slashbinbash.hexen.view.StaticView;
import de.slashbinbash.opengl.Color;
import de.slashbinbash.opengl.Texture;
import de.slashbinbash.opengl.math.Rect2f;
import de.slashbinbash.opengl.renderer.Draw2D;

public class SpaceView {
    public static Rect2f mapRect = new Rect2f(192.0f, 16.0f, 224.0f, 224.0f);
    public static Rect2f textRect = new Rect2f(432.0f, 16.0f, 192.0f, 224.0f);
    public static Rect2f portRect = new Rect2f(16.0f, 16.0f, 160.0f, 160.0f);
    public static Rect2f menuRect = new Rect2f(portRect.left(), portRect.bottom() + 32.0f, 0.0f, 0.0f);

    private static void drawMap2D(Draw2D draw2D, SpaceHandler spaceHandler) {
        if (!spaceHandler.draw2dMap) {
            return;
        }
        if (spaceHandler.hideMap) {
            return;
        }
        switch (0) {
            case 0: {
                Object object = Map2DGridRenderer.getInstance();
                ((Map2DGridRenderer)object).draw(draw2D, 16, 16);
                break;
            }
            case 1: {
                Object object = Map2DSpriteRenderer.getInstance();
                ((Map2DSpriteRenderer)object).draw(draw2D);
                break;
            }
            case 2: {
                Object object = Map3DRenderer.getInstance().renderToTarget();
                draw2D.setColor(Color.WHITE);
                draw2D.drawTexture((Texture)object, 32.0f, 32.0f);
                break;
            }
        }
        if (!spaceHandler.options.isEmpty()) {
            int n = spaceHandler.options.size();
            int n2 = 96 - n * 8;
            draw2D.setColor(Color.WHITE);
            draw2D.fillRect(n2, 88.0f, n * 16, 16.0f);
            draw2D.setColor(Color.WHITE);
            draw2D.begin();
            int n3 = 0;
            for (Button button : spaceHandler.options) {
                if (button.tex != null) {
                    draw2D.drawTexture(button.tex, button.tx, button.ty, button.twidth, button.theight, n2 + n3 * 16, 88.0f, 16.0f, 16.0f);
                }
                ++n3;
            }
            draw2D.end();
        }
    }

    public static void draw(Draw2D draw2D, SpaceHandler spaceHandler) {
        RPG rPG = RPG.getInstance();
        MapRenderer mapRenderer = MapRenderer.getInstance();
        Location location = rPG.party.getLocation();
        Level level = location.getLevel();
        StaticView.drawBackground(draw2D);
        if (rPG.party.isDead()) {
            StaticView.drawPortrait(draw2D, "gameover", "Game Over");
        } else if (spaceHandler.scene != null) {
            StaticView.drawPortrait(draw2D, spaceHandler.scene);
        } else {
            StaticView.drawPortrait(draw2D, null, null);
        }
        if (spaceHandler.text != null && !spaceHandler.text.isEmpty()) {
            draw2D.setColor(Color.WHITE);
            draw2D.drawString(SpaceView.textRect.x, SpaceView.textRect.y, spaceHandler.text);
        }
        draw2D.setColor(Color.BLACK);
        draw2D.fillRect(SpaceView.mapRect.x, SpaceView.mapRect.y, SpaceView.mapRect.width, SpaceView.mapRect.height);
        if (level.showMapTiles) {
            draw2D.pushMatrix();
            draw2D.translatef(SpaceView.mapRect.x, SpaceView.mapRect.y);
            if (spaceHandler.hideMap) {
                // empty if block
            }
            mapRenderer.restrictView = spaceHandler.hideMap;
            mapRenderer.direction = rPG.party.direction;
            mapRenderer.draw(draw2D, (int)SpaceView.mapRect.width, (int)SpaceView.mapRect.height, location.x, location.y);
            draw2D.popMatrix();
        }
        if (level.showMapTextures) {
            MapIsoRenderer mapIsoRenderer = MapIsoRenderer.getInstance();
            mapIsoRenderer.restrictView = spaceHandler.hideMap;
            draw2D.pushMatrix();
            draw2D.translatef(SpaceView.mapRect.x, SpaceView.mapRect.y);
            draw2D.pushMatrix();
            draw2D.translatef(-32 * location.x, -32 * location.y);
            draw2D.translatef(96.0f, 96.0f);
            mapIsoRenderer.draw(draw2D, location.getLevel(), location.x, location.y);
            draw2D.popMatrix();
            int n = (int)SpaceView.mapRect.width;
            int n2 = (int)SpaceView.mapRect.height;
            if (rPG.party.direction != null) {
                draw2D.setColor(Color.RED);
                float f = (float)n * 0.5f - 4.0f;
                float f2 = (float)n2 * 0.5f - 4.0f;
                switch (rPG.party.direction) {
                    case EAST: {
                        draw2D.fillPolygon(f, f2, f + 8.0f, f2 + 4.0f, f, f2 + 8.0f);
                        break;
                    }
                    case NORTH: {
                        draw2D.fillPolygon(f + 4.0f, f2, f + 8.0f, f2 + 8.0f, f, f2 + 8.0f);
                        break;
                    }
                    case SOUTH: {
                        draw2D.fillPolygon(f, f2, f + 8.0f, f2, f + 4.0f, f2 + 8.0f);
                        break;
                    }
                    case WEST: {
                        draw2D.fillPolygon(f, f2 + 4.0f, f + 8.0f, f2, f + 8.0f, f2 + 8.0f);
                        break;
                    }
                    default: {
                        draw2D.fillRect((float)n * 0.5f - 4.0f, (float)n2 * 0.5f - 4.0f, 8.0f, 8.0f);
                        break;
                    }
                }
            } else {
                draw2D.setColor(Color.RED);
                draw2D.fillRect((float)n * 0.5f - 4.0f, (float)n2 * 0.5f - 4.0f, 8.0f, 8.0f);
            }
            draw2D.popMatrix();
        }
        StaticView.drawStatusBar(draw2D);
        ButtonRenderer.drawOptions(draw2D, spaceHandler.options);
        ButtonRenderer.drawButtons(draw2D, spaceHandler.buttons, ButtonRenderer.Style.Image);
        StaticView.drawBottomPane(draw2D);
        SpaceView.drawMap2D(draw2D, spaceHandler);
    }

    public static void update(SpaceHandler spaceHandler) {
        if (spaceHandler.draw2dMap) {
            Location location = RPG.getInstance().party.getLocation();
            Direction direction = RPG.getInstance().party.direction;
            Map2DGridRenderer map2DGridRenderer = Map2DGridRenderer.getInstance();
            map2DGridRenderer.update(location, direction);
            Map2DSpriteRenderer map2DSpriteRenderer = Map2DSpriteRenderer.getInstance();
            map2DSpriteRenderer.update(location, direction);
        }
    }
}

