/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.view;

import de.slashbinbash.hexen.combat.CombatState;
import de.slashbinbash.hexen.combat.Combatant;
import de.slashbinbash.hexen.combat.CombatantGroup;
import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.handler.CombatHandler;
import de.slashbinbash.hexen.model.ClassCreature;
import de.slashbinbash.hexen.model.CombatAction;
import de.slashbinbash.hexen.model.Condition;
import de.slashbinbash.hexen.model.Item;
import de.slashbinbash.hexen.view.StaticView;
import de.slashbinbash.opengl.Color;
import de.slashbinbash.opengl.Texture;
import de.slashbinbash.opengl.TextureFactory;
import de.slashbinbash.opengl.math.Rect2f;
import de.slashbinbash.opengl.renderer.Draw2D;
import de.slashbinbash.util.Strings;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public class CombatView {
    private static Rect2f textRect = new Rect2f(192.0f, 16.0f, 432.0f, 224.0f);
    private static StringBuilder sb = new StringBuilder();
    public static TextView text = new TextView();
    private static Texture texGrid = null;
    private static final int PWIDTH = 32;
    private static final int PHEIGHT = 32;
    private static final int NUM_IMAGES = 12;
    private static BufferedImage imgAtlas = new BufferedImage(384, 32, 2);
    private static Texture texAtlas = null;
    private static ArrayList<String> keys = new ArrayList();

    private static int countEnemiesAtRange(List<CombatantGroup> list, int n) {
        int n2 = 0;
        for (CombatantGroup combatantGroup : list) {
            if (combatantGroup.range != n) continue;
            n2 += combatantGroup.size();
        }
        return n2;
    }

    public static void draw(Draw2D draw2D, CombatHandler combatHandler) {
        int n;
        int string;
        Object object;
        int n3;
        int n4;
        int n5;
        Rect2f rect2f = StaticView.RIGHT_COLUMN;
        float f = rect2f.y + rect2f.height / 2.0f;
        CombatState combatState = combatHandler.combatState;
        StaticView.drawBackground(draw2D);
        switch (combatHandler.state) {
            case LOOT_CONFIRMER: {
                StaticView.drawPortrait(draw2D, null, "Loot");
                break;
            }
            case LOG_CONFIRMER: {
                if (combatHandler.isPartyDead()) {
                    StaticView.drawPortrait(draw2D, "gameover", "Game Over");
                    break;
                }
                Combatant combatant = CombatView.getTopEnemy(combatState);
                if (combatant != null) {
                    StaticView.drawPortrait(draw2D, combatant.creature);
                    break;
                }
                StaticView.drawPortrait(draw2D, null, "");
                break;
            }
            case PICK_OPT: 
            case PICK_CREATURE: 
            case PICK_GROUP: {
                if (combatHandler.currCombatant == null) break;
                Combatant combatant = combatHandler.currCombatant;
                StaticView.drawPortrait(draw2D, combatant.creature);
                break;
            }
            default: {
                Combatant combatant = CombatView.getTopEnemy(combatState);
                if (combatant != null) {
                    StaticView.drawPortrait(draw2D, combatant.creature);
                    break;
                }
                StaticView.drawPortrait(draw2D, null, "");
                break;
            }
        }
        StaticView.drawBottomRect(draw2D);
        CombatView.drawParty(draw2D, combatHandler);
        CombatView.drawEnemies(draw2D, combatState);
        draw2D.setColor(0.3019608f, 0.27058825f, 0.27058825f, 1.0f);
        draw2D.fillRect(192.0f, 16.0f, 224.0f, 224.0f);
        draw2D.setColor(0.2509804f, 0.22352941f, 0.22352941f, 1.0f);
        draw2D.drawTexture(texGrid, 192.0f, 16.0f);
        switch (combatHandler.state) {
            case EXIT: {
                draw2D.setColor(Color.WHITE);
                draw2D.drawString(CombatView.textRect.x, CombatView.textRect.y, "- The fight is over -");
                break;
            }
            case LOOT_CONFIRMER: 
            case INIT_CONFIRMER: {
                CombatView.drawText(draw2D, rect2f.x, rect2f.y);
                CombatView.drawMenu(draw2D, combatHandler);
                break;
            }
            case LOG_CONFIRMER: {
                CombatView.drawText(draw2D, rect2f.x, rect2f.y);
                break;
            }
            case PICK_OPT: 
            case PICK_CREATURE: 
            case PICK_GROUP: 
            case PICK_ITEM: {
                CombatView.drawMenu(draw2D, combatHandler);
                break;
            }
            case TURN_CONFIRMER: {
                CombatView.drawText(draw2D, rect2f.x, rect2f.y);
                CombatView.drawMenu(draw2D, combatHandler);
                break;
            }
        }
        int n6 = 192;
        int n7 = 96;
        draw2D.setColor(Color.WHITE);
        draw2D.begin();
        List<CombatantGroup> list = combatHandler.combatState.enemyGroups;
        for (int i = 0; i < 3; ++i) {
            n5 = CombatView.countEnemiesAtRange(list, i);
            n4 = 0;
            n3 = n7 - i * 40;
            object = list.iterator();
            while (object.hasNext()) {
                CombatantGroup combatantGroup = object.next();
                if (combatantGroup.range != i) continue;
                if (n5 > 7) {
                    int n8 = n6 + n4;
                    int n9 = CombatView.getX(combatantGroup.list().get((int)0).creature.portrait);
                    if (n9 >= 0) {
                        draw2D.drawTexture(texAtlas, n9, 0, 32, 32, n8, n3, 32.0f, 32.0f);
                    }
                    n4 += 32;
                    continue;
                }
                for (Combatant combatant : combatantGroup.list()) {
                    string = n6 + n4;
                    n = CombatView.getX(combatant.creature.portrait);
                    if (n >= 0) {
                        draw2D.drawTexture(texAtlas, n, 0, 32, 32, string, n3, 32.0f, 32.0f);
                    }
                    n4 += 32;
                }
            }
        }
        List<Combatant> list2 = combatHandler.combatState.allies;
        for (n5 = 0; n5 < 6; ++n5) {
            int n10;
            n4 = 256 + n5 % 3 * 32;
            n3 = 160 + n5 / 3 * 40;
            if (0 > n5 || n5 >= list2.size() || ((Combatant)(object = list2.get(n5))).hasRunAway() || (n10 = CombatView.getX(((Combatant)object).creature.portrait)) < 0) continue;
            draw2D.drawTexture(texAtlas, n10, 0, 32, 32, n4, n3, 32.0f, 32.0f);
        }
        draw2D.end();
        list = combatHandler.combatState.enemyGroups;
        for (int i = 0; i < 3; ++i) {
            n5 = CombatView.countEnemiesAtRange(list, i);
            n4 = 0;
            n3 = n7 - i * 40;
            object = list.iterator();
            while (object.hasNext()) {
                int combatant;
                float f2;
                CombatantGroup combatantGroup = (CombatantGroup)object.next();
                if (combatantGroup.range != i) continue;
                if (n5 > 7) {
                    int n12 = n6 + n4;
                    String object2 = String.valueOf(combatantGroup.size());
                    draw2D.setColor(Color.BLACK);
                    draw2D.fillRect(n12, n3, object2.length() * 8, 8.0f);
                    draw2D.setColor(Color.WHITE);
                    draw2D.drawString((float)n12, (float)n3, object2);
                    string = 0;
                    n = 0;
                    for (Combatant combatant2 : combatantGroup.list()) {
                        string += combatant2.getHitPoints();
                        n += combatant2.getMaxHitPoints();
                    }
                    f2 = (float)string / (float)n;
                    combatant = (int)(f2 * 32.0f);
                    draw2D.setColor(Color.BLACK);
                    draw2D.fillRect(n12, n3 + 32, 32.0f, 4.0f);
                    draw2D.setColor(Color.RED);
                    draw2D.fillRect(n12, n3 + 32, combatant, 4.0f);
                    n4 += 32;
                    continue;
                }
                for (Combatant condition : combatantGroup.list()) {
                    string = n6 + n4;
                    n4 += 32;
                    n = condition.hasConditions() ? 1 : 0;
                    f2 = (float)condition.getHitPoints() / (float)condition.getMaxHitPoints();
                    combatant = (int)(f2 * (float)(n != 0 ? 16 : 32));
                    float f3 = (float)condition.getActionPoints() / (float)condition.getMaxActionPoints();
                    int n2 = (int)(f3 * (float)(n != 0 ? 16 : 32));
                    draw2D.setColor(0.2509804f, 0.22352941f, 0.22352941f, 1.0f);
                    draw2D.fillRect(string, n3 + 32, 32.0f, 8.0f);
                    draw2D.setColor(Color.RED);
                    draw2D.fillRect(string, n3 + 32, combatant, 4.0f);
                    draw2D.setColor(Color.GREEN);
                    draw2D.fillRect(string, n3 + 32 + 4, n2, 4.0f);
                    if (!condition.hasConditions()) continue;
                    int n8 = StaticView.conditionCycle % condition.getConditions().size();
                    Condition condition2 = condition.getConditions().get(n8);
                    String string2 = condition2.getName();
                    draw2D.begin();
                    draw2D.setColor(Color.WHITE);
                    for (int j = 0; j < 2; ++j) {
                        draw2D.drawString((float)(string + 16 + j * 8), (float)(n3 + 32), string2.charAt(j));
                    }
                    draw2D.end();
                }
            }
        }
        List<Combatant> list3 = combatHandler.combatState.allies;
        for (n5 = 0; n5 < 6; ++n5) {
            n4 = 256 + n5 % 3 * 32;
            n3 = 160 + n5 / 3 * 40;
            if (0 > n5 || n5 >= list3.size() || ((Combatant)(object = list3.get(n5))).hasRunAway()) continue;
            draw2D.setColor(0.2509804f, 0.22352941f, 0.22352941f, 1.0f);
            draw2D.fillRect(n4, n3 + 32, 32.0f, 8.0f);
            if (((Combatant)object).isDead()) {
                draw2D.setColor(Color.WHITE);
                draw2D.drawString((float)n4, (float)(n3 + 32), "Dead");
                continue;
            }
            boolean bl = ((Combatant)object).hasConditions();
            if (((Combatant)object).hasConditions()) {
                int n15 = StaticView.conditionCycle % ((Combatant)object).getConditions().size();
                Condition f5 = ((Combatant)object).getConditions().get(n15);
                String string3 = f5.getName();
                draw2D.begin();
                draw2D.setColor(Color.WHITE);
                for (n = 0; n < 2; ++n) {
                    draw2D.drawString((float)(n4 + 16 + n * 8), (float)(n3 + 32), string3.charAt(n));
                }
                draw2D.end();
            }
            float f4 = (float)((Combatant)object).getHitPoints() / (float)((Combatant)object).getMaxHitPoints();
            float f5 = (float)((Combatant)object).getActionPoints() / (float)((Combatant)object).getMaxActionPoints();
            string = (int)(f4 * (float)(bl ? 16 : 32));
            draw2D.setColor(Color.RED);
            draw2D.fillRect(n4, n3 + 32, string, 4.0f);
            string = (int)(f5 * (float)(bl ? 16 : 32));
            draw2D.setColor(Color.GREEN);
            draw2D.fillRect(n4, n3 + 32 + 4, string, 4.0f);
            if (object != combatHandler.currCombatant) continue;
            draw2D.setColor(Color.YELLOW);
            draw2D.drawTexture(texGrid, 0, 0, 32, 40, n4, n3, 32.0f, 40.0f);
        }
    }

    private static void drawEnemies(Draw2D draw2D, CombatState combatState) {
        Rect2f rect2f = StaticView.PORTRAIT_RECT;
        sb.setLength(0);
        for (int i = 0; i < combatState.enemyGroups.size(); ++i) {
            CombatantGroup combatantGroup = combatState.enemyGroups.get(i);
            if (combatantGroup != null) {
                sb.append(combatantGroup.range + 1).append(") ");
                sb.append(combatantGroup.size());
                sb.append(" ");
                sb.append(combatantGroup.getName());
            }
            sb.append("\n");
        }
        draw2D.setColor(Color.WHITE);
        draw2D.drawString(rect2f.x, rect2f.bottom() + 32.0f, sb.toString());
    }

    public static void drawMenu(Draw2D draw2D, CombatHandler combatHandler) {
        Rect2f rect2f = StaticView.RIGHT_COLUMN;
        float f = rect2f.y + rect2f.height / 2.0f;
        ClassCreature classCreature = combatHandler.currCombatant != null ? combatHandler.currCombatant.creature : null;
        switch (combatHandler.state) {
            case PICK_OPT: {
                Object object;
                sb.setLength(0);
                sb.append(classCreature.name);
                sb.append("\n");
                for (int i = 0; i < combatHandler.buttons.size(); ++i) {
                    object = combatHandler.buttons.get((int)i).label;
                    sb.append(i == combatHandler.buttonIndex ? ">" : " ");
                    sb.append((String)object);
                    sb.append("\n");
                }
                draw2D.setColor(Color.WHITE);
                draw2D.drawString(rect2f.x, f, sb.toString());
                Object object2 = combatHandler.buttons.get((int)combatHandler.buttonIndex).data;
                if (!(object2 instanceof CombatAction)) break;
                object = (CombatAction)object2;
                sb.setLength(0);
                CombatView.printCombatAction(sb, (CombatAction)object);
                draw2D.setColor(Color.WHITE);
                draw2D.drawString(rect2f.x, rect2f.y, Strings.wwrap(sb, 26));
                break;
            }
            case PICK_CREATURE: {
                sb.setLength(0);
                sb.append(classCreature.name);
                sb.append("\n");
                for (int i = 0; i < combatHandler.buttons.size(); ++i) {
                    Combatant combatant = (Combatant)combatHandler.buttons.get((int)i).data;
                    sb.append(i == combatHandler.buttonIndex ? ">" : " ");
                    sb.append(combatant.range + 1).append(") ");
                    sb.append(combatant.getName());
                    sb.append("\n");
                }
                draw2D.setColor(Color.WHITE);
                draw2D.drawString(rect2f.x, f, sb.toString());
                break;
            }
            case PICK_GROUP: {
                sb.setLength(0);
                sb.append(classCreature.name);
                for (int i = 0; i < combatHandler.buttons.size(); ++i) {
                    CombatantGroup combatantGroup = (CombatantGroup)combatHandler.buttons.get((int)i).data;
                    sb.append("\n");
                    sb.append(i == combatHandler.buttonIndex ? ">" : " ");
                    sb.append(combatantGroup.range + 1).append(") ");
                    sb.append(combatantGroup.size());
                    sb.append(" ");
                    sb.append(combatantGroup.get(0).getName());
                }
                draw2D.setColor(Color.WHITE);
                draw2D.drawString(rect2f.x, f, sb.toString());
                break;
            }
            case PICK_ITEM: {
                sb.setLength(0);
                sb.append(classCreature.name);
                for (int i = 0; i < combatHandler.buttons.size(); ++i) {
                    Item item = (Item)combatHandler.buttons.get((int)i).data;
                    sb.append("\n");
                    sb.append(i == combatHandler.buttonIndex ? ">" : " ");
                    sb.append(item.count).append(" ").append(item.getName());
                }
                draw2D.setColor(Color.WHITE);
                draw2D.drawString(rect2f.x, f, sb.toString());
                break;
            }
            case LOOT_CONFIRMER: 
            case INIT_CONFIRMER: {
                sb.setLength(0);
                for (int i = 0; i < combatHandler.buttons.size(); ++i) {
                    String string = combatHandler.buttons.get((int)i).label;
                    sb.append(combatHandler.buttonIndex == i ? ">" : " ");
                    sb.append(string);
                    sb.append("\n");
                }
                draw2D.setColor(Color.WHITE);
                draw2D.drawString(rect2f.x, f, sb.toString());
                break;
            }
            case TURN_CONFIRMER: {
                sb.setLength(0);
                sb.append("Agree?");
                for (int i = 0; i < combatHandler.buttons.size(); ++i) {
                    String string = combatHandler.buttons.get((int)i).label;
                    sb.append("\n");
                    sb.append(combatHandler.buttonIndex == i ? ">" : " ");
                    sb.append(string);
                }
                draw2D.setColor(Color.WHITE);
                draw2D.drawString(rect2f.x, f, sb.toString());
                break;
            }
        }
    }

    private static void drawParty(Draw2D draw2D, CombatHandler combatHandler) {
        CombatState combatState = combatHandler.combatState;
        sb.setLength(0);
        StaticView.printPartyHeader(sb);
        for (Combatant combatant : combatState.allies) {
            CombatState.Action action = combatState.findAction(combatHandler.actionQueue, combatant);
            ClassCreature classCreature = combatant.creature;
            StaticView.printPartyRow(sb, classCreature);
            if (action != null) {
                switch (action.action) {
                    case ATTACK: {
                        sb.append(action.combatAction.getName());
                        break;
                    }
                    case PASS: {
                        sb.append("Pass");
                        break;
                    }
                    case RUN_AWAY: {
                        sb.append("Run");
                        break;
                    }
                    case USE_ITEM: {
                        sb.append(action.item.getName());
                        break;
                    }
                    default: {
                        sb.append("??????");
                        break;
                    }
                }
            } else if (combatant.hasRunAway()) {
                sb.append("Ran away");
            } else if (combatant.isDead()) {
                sb.append("Dead");
            } else if (combatant.hasConditions()) {
                StaticView.printPartyRowCond(sb, classCreature, StaticView.conditionCycle);
            } else {
                sb.append("??????");
            }
            sb.append("\n");
        }
        StaticView.drawBottomText(draw2D, sb.toString());
    }

    private static void drawText(Draw2D draw2D, float f, float f2) {
        if (text == null) {
            return;
        }
        int n = 0;
        float f3 = f;
        float f4 = f2;
        draw2D.setColor(Color.WHITE);
        draw2D.begin();
        int n2 = 0;
        int n3 = CombatView.text.offset;
        for (n2 = 0; n2 < CombatView.text.text.length(); ++n2) {
            char c = CombatView.text.text.charAt(n2);
            if (c == '\n') {
                if (n3 > 0) {
                    --n3;
                    continue;
                }
                if (++n >= 26) break;
                f3 = f;
                f4 += 8.0f;
                continue;
            }
            if (n3 != 0) continue;
            draw2D.drawString(f3, f4, c);
            f3 += 8.0f;
        }
        draw2D.end();
        if (CombatView.text.numPages > 1) {
            Rect2f rect2f = StaticView.RIGHT_COLUMN;
            draw2D.drawString(rect2f.x, rect2f.bottom() - 8.0f, CombatView.text.strPages);
        }
    }

    private static Combatant getTopEnemy(CombatState combatState) {
        for (Combatant combatant : combatState.enemies) {
            if (combatant.isDead()) continue;
            return combatant;
        }
        return null;
    }

    private static int getX(String string) {
        return keys.indexOf(string) * 32;
    }

    public static void init(CombatHandler combatHandler) {
        if (texGrid == null) {
            try {
                texGrid = TextureFactory.createTexture(new File("data/res/battlegrid.png"));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        keys.clear();
        if (texAtlas != null) {
            TextureFactory.deleteTexture(texAtlas);
            texAtlas = null;
        }
        for (Combatant combatant : combatHandler.combatState.enemies) {
            CombatView.load(combatant.creature.portrait, 32, 32);
        }
        for (Combatant combatant : combatHandler.combatState.allies) {
            CombatView.load(combatant.creature.portrait, 32, 32);
        }
        texAtlas = TextureFactory.createTexture(imgAtlas);
    }

    private static void load(String string, int n, int n2) {
        if (keys.contains(string)) {
            return;
        }
        if (keys.size() == 12) {
            return;
        }
        File file = new File(Factory.PORTRAIT_PATH + string + ".png");
        if (!file.exists()) {
            return;
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(file);
            Image image = bufferedImage.getScaledInstance(n, n2, 4);
            int n3 = keys.size() * 32;
            Graphics2D graphics2D = (Graphics2D)imgAtlas.getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics2D.drawImage(image, n3, 0, null);
            graphics2D.dispose();
            keys.add(string);
        }
        catch (IOException iOException) {
            System.err.println("Error creating texture: " + file.getPath());
            iOException.printStackTrace();
            System.exit(-1);
        }
    }

    public static void print(String string) {
        text.set(string);
    }

    public static void print(StringBuilder stringBuilder) {
        CombatView.print(stringBuilder.toString());
    }

    public static void printCombatAction(StringBuilder stringBuilder, CombatAction combatAction) {
        if (combatAction == null) {
            return;
        }
        stringBuilder.append(combatAction.getName());
        stringBuilder.append("\nAP ").append(combatAction.getActionPointCost());
        stringBuilder.append("\n");
        stringBuilder.append("\n").append((Object)combatAction.getTarget());
        stringBuilder.append("\n").append((Object)combatAction.getRangeFrom());
        if (combatAction.getRangeFrom() != combatAction.getRangeTo()) {
            stringBuilder.append("-").append((Object)combatAction.getRangeTo());
        }
    }

    public static class TextView {
        public static final int MAX_LINES = 26;
        public int numLines = 0;
        public int numPages = 0;
        public int page = 0;
        public int offset = 0;
        public String text;
        public String strPages;

        public void nextPage() {
            if (this.page < this.numPages) {
                this.offset += 26;
                this.page = this.offset / 26 + 1;
                this.updateStr();
            }
        }

        public void prevPage() {
            if (this.page > 1) {
                this.offset -= 26;
                this.page = this.offset / 26 + 1;
                this.updateStr();
            }
        }

        public void set(String string) {
            this.text = Strings.wwrap(string, 24).strip();
            this.numLines = Strings.getNumLines(this.text);
            this.numPages = this.numLines / 26 + 1;
            this.page = this.offset / 26 + 1;
            this.offset = 0;
            this.updateStr();
        }

        private void updateStr() {
            this.strPages = "Page " + String.valueOf(this.page) + "/" + String.valueOf(this.numPages);
        }
    }
}

