/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class PatternComposer {
    private static final String strPattern = "data/_orig/background";
    private static final String strBackground = "data/pak/img/background";

    private static void createImage(String string, int[] nArray) {
        try {
            File file = new File("data/_orig/background/" + string + ".png");
            File file2 = new File("data/pak/img/background/" + string + ".png");
            if (file2.exists()) {
                return;
            }
            System.out.println(string);
            BufferedImage bufferedImage = ImageIO.read(file);
            BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
            PatternComposer.repeat(bufferedImage, bufferedImage2);
            PatternComposer.recolor(bufferedImage2, nArray[0], nArray[1]);
            ImageIO.write((RenderedImage)bufferedImage2, "png", file2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static int[] generate(float f) {
        return new int[]{Color.HSBtoRGB(f, 0.1f, 0.25f), Color.HSBtoRGB(f, 0.1f, 0.3f)};
    }

    public static void main(String[] stringArray) {
        File file = new File(strPattern);
        float f = 0.0f;
        for (File file2 : file.listFiles()) {
            if (file2.isFile() && file2.getName().endsWith(".png")) {
                String string = file2.getName().substring(0, file2.getName().lastIndexOf("."));
                PatternComposer.createImage(string, PatternComposer.generate(f));
            }
            f = PatternComposer.mod(f + 0.137f);
        }
    }

    private static float mod(float f) {
        while (f > 1.0f) {
            f -= 1.0f;
        }
        return f;
    }

    private static void recolor(BufferedImage bufferedImage, int n, int n2) {
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                int n3 = bufferedImage.getRGB(j, i);
                if (n3 == -16777216) {
                    bufferedImage.setRGB(j, i, n);
                    continue;
                }
                if (n3 != -1) continue;
                bufferedImage.setRGB(j, i, n2);
            }
        }
    }

    private static void repeat(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Graphics graphics = bufferedImage2.getGraphics();
        int n = 0;
        for (int i = 0; i < bufferedImage2.getHeight(); i += bufferedImage.getHeight()) {
            while (n < bufferedImage2.getWidth()) {
                graphics.drawImage(bufferedImage, n, i, null);
                n += bufferedImage.getWidth();
            }
            n = 0;
        }
    }
}

