/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.travel;

import de.slashbinbash.hexen.check.CheckFactory;
import de.slashbinbash.hexen.encounter.EncounterFactory;
import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.general.General;
import de.slashbinbash.hexen.general.GeneralFactory;
import de.slashbinbash.hexen.travel.Travel;
import de.slashbinbash.util.StaticXML;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class TravelFactory {
    private static Travel.Data.Entry createDestination(Element element) {
        Travel.Data.Entry entry = new Travel.Data.Entry();
        block20: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "cost": {
                    entry.cost = Integer.valueOf(StaticXML.getText(element2));
                    continue block20;
                }
                case "description": {
                    entry.description = StaticXML.getText(element2);
                    continue block20;
                }
                case "label": {
                    entry.label = StaticXML.getText(element2);
                    continue block20;
                }
                case "duration": {
                    entry.timeSeconds = Factory.parseDuration(element2);
                    continue block20;
                }
                case "path": {
                    entry.path = Factory.createPath(element2);
                    continue block20;
                }
                case "encounter": {
                    entry.encounter.always = EncounterFactory.createEncounterType(element2, 1);
                    continue block20;
                }
                case "requirements": {
                    entry.requirementChecks = CheckFactory.createChecks(element2);
                    continue block20;
                }
                case "visible": {
                    entry.visibleChecks = CheckFactory.createChecks(element2);
                    continue block20;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return entry;
    }

    private static List<Travel.Data.Entry> createDestinations(Element element) {
        ArrayList<Travel.Data.Entry> arrayList = new ArrayList<Travel.Data.Entry>();
        block6: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "destination": {
                    arrayList.add(TravelFactory.createDestination(element2));
                    continue block6;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return arrayList;
    }

    public static Travel.Data createTravelData(Element element) {
        Travel.Data data = new Travel.Data();
        data.destinations = TravelFactory.createDestinations(element);
        return data;
    }

    public static General.Data createTravelerData(String string) {
        return GeneralFactory.createGenericData(Factory.TRAVEL_PATH, string);
    }
}

