/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.travel;

import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.StaticRPG;
import de.slashbinbash.hexen.encounter.Encounter;
import de.slashbinbash.hexen.model.Party;
import de.slashbinbash.hexen.travel.Travel;

public class StaticTravel {
    public static int calcCost(Travel.Data.Entry entry) {
        Party party = RPG.getInstance().party;
        return entry.cost * party.getMembers().size();
    }

    public static StaticRPG.Result travel(Travel.Data.Entry entry) {
        Party party = RPG.getInstance().party;
        if (entry.requirementChecks != null && entry.requirementChecks.checkAll(party)) {
            return StaticRPG.Result.FAILURE;
        }
        int n = StaticTravel.calcCost(entry);
        if (party.inventory.getCurrency() < n) {
            return StaticRPG.Result.NOT_ENOUGH_CURRENCY;
        }
        party.inventory.removeCurrency(n);
        StaticRPG.passTime(entry.timeSeconds);
        StaticRPG.Result result = StaticRPG.move(party, entry.path.mapId, entry.path.level, entry.path.x, entry.path.y);
        if (entry.encounter != null) {
            Encounter.Entry entry2 = null;
            if (entry.encounter.condition != null && !entry.encounter.condition.checkAll(party)) {
                return result;
            }
            entry2 = entry.encounter.always.getRandomEntry();
            if (entry2 != null) {
                RPG.getInstance().encounterSystem.pushEncounter(entry2);
            }
        }
        return result;
    }
}

