/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.temple;

import de.slashbinbash.hexen.StaticRPG;
import de.slashbinbash.hexen.model.ClassCreature;
import de.slashbinbash.hexen.model.Duration;

public class StaticHeal {
    public static final long REVIVE_DURATION = Duration.Days(1L);
    public static final long REMOVE_CONDITION_DURATION = Duration.Minutes(30L);
    public static final long HEAL_DURATION = Duration.Minutes(5L);
    public static final int REVIVE_COST = 1;
    public static final int REMOVE_CONDITION_COST = 1;
    public static final int HEAL_COST = 1;

    public static void heal(ClassCreature classCreature) {
        int n = classCreature.calcMaxHitPoints() - classCreature.hitPoints;
        if (StaticRPG.restoreHP(classCreature)) {
            StaticRPG.passTime(HEAL_DURATION * (long)n);
        }
    }

    public static void removeConditions(ClassCreature classCreature) {
        int n = classCreature.getConditions().size();
        if (StaticRPG.removeConditions(classCreature)) {
            StaticRPG.passTime(REMOVE_CONDITION_DURATION * (long)n);
        }
    }

    public static void revive(ClassCreature classCreature) {
        assert (classCreature.canRevive());
        if (StaticRPG.revive(classCreature)) {
            StaticRPG.passTime(REVIVE_DURATION);
        }
    }
}

