/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.shop;

import de.slashbinbash.hexen.factory.AbilityFactory;
import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.factory.ItemFactory;
import de.slashbinbash.hexen.general.General;
import de.slashbinbash.hexen.general.GeneralFactory;
import de.slashbinbash.hexen.model.Item;
import de.slashbinbash.hexen.shop.Buy;
import de.slashbinbash.hexen.shop.Identify;
import de.slashbinbash.hexen.shop.Sell;
import de.slashbinbash.hexen.shop.Trade;
import de.slashbinbash.util.StaticXML;
import java.util.ArrayList;
import org.w3c.dom.Element;

public class ShopFactory {
    public static Buy.Data createBuyData(Element element) {
        Buy.Data data = new Buy.Data();
        data.buyRatio = StaticXML.getFloat(element, "ratio", 1.0f);
        if (StaticXML.hasAttribute(element, "currency")) {
            data.currency = StaticXML.getAttribute(element, "currency");
        }
        if (data.buyList == null) {
            data.buyList = new ArrayList<Item>();
        }
        for (Element element2 : StaticXML.getChildElements(element)) {
            String string = StaticXML.getAttribute(element2, "ref");
            Item item = ItemFactory.createItem(string);
            data.buyList.add(item);
        }
        return data;
    }

    public static Sell.Data createSellData(Element element) {
        Sell.Data data = new Sell.Data();
        data.sellRatio = StaticXML.getFloat(element, "ratio", 0.5f);
        if (StaticXML.hasAttribute(element, "currency")) {
            data.currency = StaticXML.getAttribute(element, "currency");
        }
        if (data.sellList == null) {
            data.sellList = new ArrayList<String>();
        }
        for (Element element2 : StaticXML.getChildElements(element)) {
            String string = StaticXML.getAttribute(element2, "ref");
            data.sellList.add(string);
        }
        return data;
    }

    public static Identify.Data createIdentifyData(Element element) {
        Identify.Data data = new Identify.Data();
        block6: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "abilities": {
                    data.abilities = AbilityFactory.createAbilities(element2);
                    continue block6;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return data;
    }

    public static General.Data createShopModel(String string) {
        return GeneralFactory.createGenericData(Factory.SHOP_PATH, string);
    }

    private static Trade.Data.Entry createTradeEntry(Element element) {
        Trade.Data.Entry entry = new Trade.Data.Entry();
        block8: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "input": {
                    entry.input = Factory.createItemGroups(element2);
                    continue block8;
                }
                case "output": {
                    entry.output = Factory.createItemGroups(element2);
                    continue block8;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return entry;
    }

    public static Trade.Data createTradeData(Element element) {
        Trade.Data data = new Trade.Data();
        for (Element element2 : StaticXML.getChildElements(element)) {
            data.entries.add(ShopFactory.createTradeEntry(element2));
        }
        return data;
    }
}

