/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.renderer;

import java.awt.Color;

public class Util {
    public static float clamp(float f, float f2, float f3) {
        return Math.min(Math.max(f, f2), f3);
    }

    public static int clamp(int n, int n2, int n3) {
        return Math.min(Math.max(n, n2), n3);
    }

    public static double distance(float[] fArray, float[] fArray2) {
        assert (fArray.length == fArray2.length);
        double d = 0.0;
        for (int i = 0; i < fArray.length; ++i) {
            d += Math.pow(fArray2[i] - fArray[i], 2.0);
        }
        return Math.sqrt(d);
    }

    public static double distance(int[] nArray, int[] nArray2) {
        assert (nArray.length == nArray2.length);
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            d += Math.pow(nArray2[i] - nArray[i], 2.0);
        }
        return Math.sqrt(d);
    }

    public static int getAlpha(int n) {
        return n >> 24 & 0xFF;
    }

    public static int getBlue(int n) {
        return n & 0xFF;
    }

    public static int getGreen(int n) {
        return n >> 8 & 0xFF;
    }

    public static int getRed(int n) {
        return n >> 16 & 0xFF;
    }

    public static int getRGB(float f, float f2, float f3) {
        return Util.getRGB((int)(f * 255.0f), (int)(f2 * 255.0f), (int)(f3 * 255.0f));
    }

    public static int getRGB(int n, int n2, int n3) {
        return new Color(n, n2, n3).getRGB();
    }

    public static void getRGBA(int n, float[] fArray) {
        assert (fArray.length == 4);
        fArray[0] = (float)Util.getRed(n) / 255.0f;
        fArray[1] = (float)Util.getGreen(n) / 255.0f;
        fArray[2] = (float)Util.getBlue(n) / 255.0f;
        fArray[3] = (float)Util.getAlpha(n) / 255.0f;
    }

    public static void getRGBA(int n, int[] nArray) {
        assert (nArray.length == 4);
        nArray[0] = Util.getRed(n);
        nArray[1] = Util.getGreen(n);
        nArray[2] = Util.getBlue(n);
        nArray[3] = Util.getAlpha(n);
    }

    public static int minmax(int n) {
        return Util.clamp(n, 0, 255);
    }

    public static int mod(int n) {
        return n % 256;
    }

    public static int wrap(int n, int n2, int n3) {
        if (n < n2) {
            return n + n3;
        }
        if (n >= n3) {
            return n % n3;
        }
        return n;
    }
}

