/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.renderer;

import de.slashbinbash.opengl.Texture;
import de.slashbinbash.opengl.TextureFactory;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class TextureManager {
    private HashMap<String, Texture> textureMap = new HashMap();

    public Texture get(String string, int n) {
        String string2 = string;
        if (this.textureMap.containsKey(string2)) {
            return this.textureMap.get(string2);
        }
        try {
            Texture texture = null;
            File file = new File(string);
            if (file.exists()) {
                texture = TextureFactory.createTexture(new File(string), n);
            }
            this.textureMap.put(string2, texture);
            return texture;
        }
        catch (IOException iOException) {
            System.err.println("Error creating texture: " + string);
            iOException.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    public boolean has(String string) {
        return this.textureMap.containsKey(string);
    }

    public void set(String string, Texture texture) {
        if (this.textureMap.containsKey(string)) {
            Texture texture2 = this.textureMap.remove(string);
            TextureFactory.deleteTexture(texture2);
        }
        this.textureMap.put(string, texture);
    }

    public void remove(String string) {
        String string2 = string;
        if (this.textureMap.containsKey(string2)) {
            Texture texture = this.textureMap.get(string2);
            TextureFactory.deleteTexture(texture);
            this.textureMap.remove(string2);
        }
    }

    public void clear() {
        for (String string : this.textureMap.keySet()) {
            Texture texture = this.textureMap.get(string);
            if (texture == null) continue;
            TextureFactory.deleteTexture(texture);
        }
        this.textureMap.clear();
    }
}

