/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.renderer;

import de.slashbinbash.hexen.enums.Direction;
import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.map.Level;
import de.slashbinbash.hexen.map.Location;
import de.slashbinbash.hexen.map.Tile;
import de.slashbinbash.hexen.map.TileEdge;
import de.slashbinbash.opengl.Color;
import de.slashbinbash.opengl.Texture;
import de.slashbinbash.opengl.TextureFactory;
import de.slashbinbash.opengl.renderer.Draw2D;
import java.io.File;
import java.io.IOException;

public class Map2DSpriteRenderer {
    public static Map2DSpriteRenderer _instance = null;
    public static final int NONE = 0;
    public static final int WALL = 1;
    public static final int DOOR = 2;
    private Texture texDC;
    private static final int WIDTH = 7;
    private static final int HEIGHT = 4;
    private RTile[][] tileBuffer = new RTile[7][4];
    private int[][] segments160 = new int[][]{{0, 0, 0, 0}, {0, 0, 16, 160}, {16, 0, 32, 160}, {48, 0, 64, 160}, {112, 0, 128, 160}, {240, 0, 16, 160}, {256, 0, 32, 160}, {288, 0, 16, 160}, {304, 0, 8, 160}, {336, 0, 32, 160}, {368, 0, 24, 160}, {416, 0, 40, 160}};
    private int[][] segmentsMap = new int[][]{{1, 11, 2, 0}, {1, 10, 2, 11}, {1, 8, 2, 10}, {1, -8, 2, 8}, {1, -10, 2, -8}, {1, -11, 2, -10}, {1, 0, 2, -11}, {0, 0, 0, 0}, {2, 9, 3, 0}, {2, 7, 3, 9}, {2, -7, 3, 7}, {2, -9, 3, -7}, {2, 0, 3, -9}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {3, 6, 4, 0}, {3, -6, 4, 6}, {3, 0, 4, -6}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {4, 5, 0, 0}, {4, -5, 0, 5}, {4, 0, 0, -5}, {0, 0, 0, 0}, {0, 0, 0, 0}};
    private int scale = 1;

    public static Map2DSpriteRenderer getInstance() {
        if (_instance == null) {
            _instance = new Map2DSpriteRenderer();
        }
        return _instance;
    }

    private File asset(String string) {
        return new File(Factory.PAK_ASSETS + "/" + string);
    }

    private Map2DSpriteRenderer() {
        Object object;
        int n;
        int n2;
        try {
            this.texDC = TextureFactory.createTexture(this.asset("dc-tiles-160.png"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        for (n2 = 0; n2 < 7; ++n2) {
            for (n = 0; n < 4; ++n) {
                object = new RTile();
                ((RTile)object).edgeNorth = new REdge();
                ((RTile)object).edgeEast = new REdge();
                ((RTile)object).edgeSouth = new REdge();
                ((RTile)object).edgeWest = new REdge();
                this.tileBuffer[n2][n] = object;
            }
        }
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 7; ++n) {
                this.tileBuffer[n][n2].edgeSouth = object = new REdge();
                this.tileBuffer[n][n2 + 1].edgeNorth = object;
            }
        }
        for (n2 = 0; n2 < 4; ++n2) {
            for (n = 0; n < 6; ++n) {
                this.tileBuffer[n][n2].edgeEast = object = new REdge();
                this.tileBuffer[n + 1][n2].edgeWest = object;
            }
        }
        for (n2 = 0; n2 < 4; ++n2) {
            for (n = 0; n < 7; ++n) {
                int n3 = n2 * 7 + n;
                RTile rTile = this.tileBuffer[n][n2];
                rTile.edgeNorth.segment = this.segmentsMap[n3][0];
                rTile.edgeEast.segment = this.segmentsMap[n3][1];
                rTile.edgeSouth.segment = this.segmentsMap[n3][2];
                rTile.edgeWest.segment = this.segmentsMap[n3][3];
            }
        }
    }

    private int getType(TileEdge tileEdge) {
        switch (tileEdge.type) {
            case 0: {
                return 0;
            }
            case 1: 
            case 8: {
                return 1;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return 2;
            }
        }
        return 0;
    }

    private void putTiles(Location location, Direction direction) {
        block11: {
            int n;
            int n2;
            int n3;
            int n4;
            Level level;
            block13: {
                block12: {
                    block10: {
                        level = location.getLevel();
                        n4 = location.x;
                        n3 = location.y;
                        for (n2 = 0; n2 < 7; ++n2) {
                            for (n = 0; n < 4; ++n) {
                                RTile rTile = this.tileBuffer[n2][n];
                                rTile.type = 0;
                                rTile.edgeNorth.type = 0;
                                rTile.edgeEast.type = 0;
                                rTile.edgeSouth.type = 0;
                                rTile.edgeWest.type = 0;
                            }
                        }
                        if (direction != Direction.NORTH) break block10;
                        for (n2 = 0; n2 < 7; ++n2) {
                            for (n = 0; n < 4; ++n) {
                                int n5 = n2 - 3;
                                int n6 = n - 3;
                                RTile rTile = this.tileBuffer[n2][n];
                                Tile tile = level.getTile(n4 + n5, n3 + n6);
                                if (tile == null) continue;
                                rTile.type = tile.type;
                                rTile.edgeNorth.type = this.getType(tile.edgeNorth);
                                rTile.edgeEast.type = this.getType(tile.edgeEast);
                                rTile.edgeSouth.type = this.getType(tile.edgeSouth);
                                rTile.edgeWest.type = this.getType(tile.edgeWest);
                            }
                        }
                        break block11;
                    }
                    if (direction != Direction.EAST) break block12;
                    for (n2 = 0; n2 < 7; ++n2) {
                        for (n = 0; n < 4; ++n) {
                            int n7 = (n - 3) * -1;
                            int n8 = n2 - 3;
                            RTile rTile = this.tileBuffer[n2][n];
                            Tile tile = level.getTile(n4 + n7, n3 + n8);
                            if (tile == null) continue;
                            rTile.type = tile.type;
                            rTile.edgeNorth.type = this.getType(tile.edgeEast);
                            rTile.edgeEast.type = this.getType(tile.edgeSouth);
                            rTile.edgeSouth.type = this.getType(tile.edgeWest);
                            rTile.edgeWest.type = this.getType(tile.edgeNorth);
                        }
                    }
                    break block11;
                }
                if (direction != Direction.SOUTH) break block13;
                for (n2 = 0; n2 < 7; ++n2) {
                    for (n = 0; n < 4; ++n) {
                        int n9 = (n2 - 3) * -1;
                        int n10 = (n - 3) * -1;
                        RTile rTile = this.tileBuffer[n2][n];
                        Tile tile = level.getTile(n4 + n9, n3 + n10);
                        if (tile == null) continue;
                        rTile.type = tile.type;
                        rTile.edgeNorth.type = this.getType(tile.edgeSouth);
                        rTile.edgeEast.type = this.getType(tile.edgeWest);
                        rTile.edgeSouth.type = this.getType(tile.edgeNorth);
                        rTile.edgeWest.type = this.getType(tile.edgeEast);
                    }
                }
                break block11;
            }
            if (direction != Direction.WEST) break block11;
            for (n2 = 0; n2 < 7; ++n2) {
                for (n = 0; n < 4; ++n) {
                    int n11 = n - 3;
                    int n12 = (n2 - 3) * -1;
                    RTile rTile = this.tileBuffer[n2][n];
                    Tile tile = level.getTile(n4 + n11, n3 + n12);
                    if (tile == null) continue;
                    rTile.type = tile.type;
                    rTile.edgeNorth.type = this.getType(tile.edgeWest);
                    rTile.edgeEast.type = this.getType(tile.edgeNorth);
                    rTile.edgeSouth.type = this.getType(tile.edgeEast);
                    rTile.edgeWest.type = this.getType(tile.edgeSouth);
                }
            }
        }
    }

    private void put(Draw2D draw2D, REdge rEdge, int n) {
        if (rEdge.type == 0) {
            return;
        }
        int n2 = rEdge.type - 1;
        int[] nArray = this.segments160[Math.abs(rEdge.segment)];
        int n3 = nArray[0];
        int n4 = nArray[1];
        int n5 = nArray[2];
        int n6 = nArray[3];
        boolean bl = false;
        int n7 = n5;
        int n8 = n6;
        if (n < 0) {
            n3 += n5 - (n + n7);
            n5 = n + n7;
            n7 = n + n7;
            n = 0;
        }
        if (n + n7 > 160) {
            n5 = 160 - n;
            n7 = 160 - n;
        }
        if (rEdge.segment < 0) {
            n += n5;
            n7 *= -1;
        }
        draw2D.drawTexture(this.texDC, n3, n4 + n2 * 160, n5, n6, n, (float)bl, n7, n8);
    }

    public void draw(Draw2D draw2D) {
        this.draw160(draw2D);
    }

    private void draw80(Draw2D draw2D) {
        draw2D.pushMatrix();
        draw2D.translatef(16.0f, 16.0f);
        draw2D.setColor(Color.DARK_GREY);
        draw2D.fillRect(0.0f, 0.0f, 160.0f, 160.0f);
        draw2D.setColor(Color.DARK_GREEN);
        draw2D.fillRect(0.0f, 80.0f, 160.0f, 80.0f);
        draw2D.setColor(Color.BLACK);
        draw2D.setColor(Color.WHITE);
        RTile rTile = this.tileBuffer[0][0];
        RTile rTile2 = this.tileBuffer[1][0];
        RTile rTile3 = this.tileBuffer[2][0];
        RTile rTile4 = this.tileBuffer[3][0];
        RTile rTile5 = this.tileBuffer[4][0];
        RTile rTile6 = this.tileBuffer[5][0];
        RTile rTile7 = this.tileBuffer[6][0];
        RTile rTile8 = this.tileBuffer[1][1];
        RTile rTile9 = this.tileBuffer[2][1];
        RTile rTile10 = this.tileBuffer[3][1];
        RTile rTile11 = this.tileBuffer[4][1];
        RTile rTile12 = this.tileBuffer[5][1];
        RTile rTile13 = this.tileBuffer[2][2];
        RTile rTile14 = this.tileBuffer[3][2];
        RTile rTile15 = this.tileBuffer[4][2];
        RTile rTile16 = this.tileBuffer[3][3];
        this.put(draw2D, rTile.edgeEast, 0);
        this.put(draw2D, rTile7.edgeWest, 0);
        this.put(draw2D, rTile2.edgeEast, 16);
        this.put(draw2D, rTile6.edgeWest, 48);
        this.put(draw2D, rTile3.edgeEast, 32);
        this.put(draw2D, rTile5.edgeWest, 40);
        this.put(draw2D, rTile2.edgeSouth, 0);
        this.put(draw2D, rTile3.edgeSouth, 16);
        this.put(draw2D, rTile4.edgeSouth, 32);
        this.put(draw2D, rTile5.edgeSouth, 48);
        this.put(draw2D, rTile6.edgeSouth, 64);
        this.put(draw2D, rTile8.edgeEast, 0);
        this.put(draw2D, rTile12.edgeWest, 64);
        this.put(draw2D, rTile9.edgeEast, 24);
        this.put(draw2D, rTile11.edgeWest, 48);
        this.put(draw2D, rTile9.edgeSouth, 0);
        this.put(draw2D, rTile10.edgeSouth, 24);
        this.put(draw2D, rTile11.edgeSouth, 56);
        this.put(draw2D, rTile13.edgeEast, 8);
        this.put(draw2D, rTile15.edgeWest, 56);
        this.put(draw2D, rTile13.edgeSouth, 0);
        this.put(draw2D, rTile14.edgeSouth, 8);
        this.put(draw2D, rTile15.edgeSouth, 72);
        this.put(draw2D, rTile16.edgeWest, 0);
        this.put(draw2D, rTile16.edgeEast, 80);
        draw2D.popMatrix();
    }

    private void draw160(Draw2D draw2D) {
        draw2D.pushMatrix();
        draw2D.translatef(16.0f, 16.0f);
        draw2D.setColor(Color.DARK_GREY);
        draw2D.fillRect(0.0f, 0.0f, 160.0f, 160.0f);
        draw2D.setColor(Color.DARK_GREEN);
        draw2D.fillRect(0.0f, 80.0f, 160.0f, 80.0f);
        draw2D.setColor(Color.BLACK);
        draw2D.fillRect(0.0f, 72.0f, 160.0f, 16.0f);
        draw2D.setColor(Color.WHITE);
        RTile rTile = this.tileBuffer[0][0];
        RTile rTile2 = this.tileBuffer[1][0];
        RTile rTile3 = this.tileBuffer[2][0];
        RTile rTile4 = this.tileBuffer[3][0];
        RTile rTile5 = this.tileBuffer[4][0];
        RTile rTile6 = this.tileBuffer[5][0];
        RTile rTile7 = this.tileBuffer[6][0];
        RTile rTile8 = this.tileBuffer[1][1];
        RTile rTile9 = this.tileBuffer[2][1];
        RTile rTile10 = this.tileBuffer[3][1];
        RTile rTile11 = this.tileBuffer[4][1];
        RTile rTile12 = this.tileBuffer[5][1];
        RTile rTile13 = this.tileBuffer[2][2];
        RTile rTile14 = this.tileBuffer[3][2];
        RTile rTile15 = this.tileBuffer[4][2];
        RTile rTile16 = this.tileBuffer[3][3];
        this.put(draw2D, rTile.edgeNorth, 24);
        this.put(draw2D, rTile2.edgeNorth, 40);
        this.put(draw2D, rTile3.edgeNorth, 56);
        this.put(draw2D, rTile4.edgeNorth, 72);
        this.put(draw2D, rTile5.edgeNorth, 88);
        this.put(draw2D, rTile6.edgeNorth, 104);
        this.put(draw2D, rTile7.edgeNorth, 120);
        this.put(draw2D, rTile2.edgeEast, 32);
        this.put(draw2D, rTile6.edgeWest, 104);
        this.put(draw2D, rTile3.edgeEast, 64);
        this.put(draw2D, rTile5.edgeWest, 88);
        this.put(draw2D, rTile2.edgeSouth, 0);
        this.put(draw2D, rTile3.edgeSouth, 32);
        this.put(draw2D, rTile4.edgeSouth, 64);
        this.put(draw2D, rTile5.edgeSouth, 96);
        this.put(draw2D, rTile6.edgeSouth, 128);
        this.put(draw2D, rTile8.edgeEast, 0);
        this.put(draw2D, rTile12.edgeWest, 128);
        this.put(draw2D, rTile9.edgeEast, 48);
        this.put(draw2D, rTile11.edgeWest, 96);
        this.put(draw2D, rTile9.edgeSouth, -16);
        this.put(draw2D, rTile10.edgeSouth, 48);
        this.put(draw2D, rTile11.edgeSouth, 112);
        this.put(draw2D, rTile13.edgeEast, 16);
        this.put(draw2D, rTile15.edgeWest, 112);
        this.put(draw2D, rTile13.edgeSouth, -112);
        this.put(draw2D, rTile14.edgeSouth, 16);
        this.put(draw2D, rTile15.edgeSouth, 144);
        this.put(draw2D, rTile16.edgeWest, 0);
        this.put(draw2D, rTile16.edgeEast, 144);
        draw2D.popMatrix();
    }

    public void update(Location location, Direction direction) {
        this.putTiles(location, direction);
    }

    private static class RTile {
        public int type;
        public REdge edgeNorth;
        public REdge edgeEast;
        public REdge edgeSouth;
        public REdge edgeWest;

        private RTile() {
        }
    }

    private static class REdge {
        public int segment;
        public int type;

        private REdge() {
        }
    }
}

