/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.renderer;

import de.slashbinbash.hexen.enums.Direction;
import de.slashbinbash.hexen.map.Level;
import de.slashbinbash.hexen.map.Location;
import de.slashbinbash.hexen.map.Tile;
import de.slashbinbash.hexen.map.TileEdge;
import de.slashbinbash.opengl.Color;
import de.slashbinbash.opengl.Texture;
import de.slashbinbash.opengl.TextureFactory;
import de.slashbinbash.opengl.renderer.Draw2D;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class Map2DGridRenderer {
    private static final int NORTH = 0;
    private static final int EAST = 1;
    private static final int SOUTH = 2;
    private static final int WEST = 3;
    public static final int NONE = 0;
    public static final int WALL = 1;
    public static final int DOOR = 2;
    private static final int WIDTH = 7;
    private static final int HEIGHT = 4;
    private static final int TWIDTH = 160;
    private static final int THEIGHT = 160;
    private static final int TX = 80;
    private static final int TY = 80;
    public static Map2DGridRenderer _instance = null;
    private BufferedImage image;
    private Texture texDC;
    private RTile[][] tileBuffer = new RTile[7][4];
    int[][][] segments = new int[][][]{new int[][]{{23, 23, 39, 39}, {88, 71, 71, 88}}, new int[][]{{39, 39, 55, 55}, {88, 71, 71, 88}}, new int[][]{{55, 55, 71, 71}, {88, 71, 71, 88}}, new int[][]{{71, 71, 88, 88}, {88, 71, 71, 88}}, new int[][]{{88, 88, 104, 104}, {88, 71, 71, 88}}, new int[][]{{104, 104, 120, 120}, {88, 71, 71, 88}}, new int[][]{{120, 120, 136, 136}, {88, 71, 71, 88}}, new int[][]{null, null}, new int[][]{{-1, -1, 31, 31}, {96, 63, 63, 96}}, new int[][]{{31, 31, 63, 63}, {96, 63, 63, 96}}, new int[][]{{63, 63, 96, 96}, {96, 63, 63, 96}}, new int[][]{{96, 96, 128, 128}, {96, 63, 63, 96}}, new int[][]{{128, 128, 160, 160}, {96, 63, 63, 96}}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{{-17, -17, 47, 47}, {112, 47, 47, 112}}, new int[][]{{47, 47, 112, 112}, {112, 47, 47, 112}}, new int[][]{{112, 112, 176, 176}, {112, 47, 47, 112}}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{{-113, -113, 15, 15}, {144, 15, 15, 144}}, new int[][]{{15, 15, 144, 144}, {144, 15, 15, 144}}, new int[][]{{144, 144, 272, 272}, {144, 15, 15, 144}}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{{-33, -33, 23, 23}, {96, 63, 71, 88}}, new int[][]{{-1, -1, 39, 39}, {96, 63, 71, 88}}, new int[][]{{31, 31, 55, 55}, {96, 63, 71, 88}}, new int[][]{{63, 63, 71, 71}, {96, 63, 71, 88}}, new int[][]{{88, 88, 96, 96}, {88, 71, 63, 96}}, new int[][]{{104, 104, 128, 128}, {88, 71, 63, 96}}, new int[][]{{120, 120, 160, 160}, {88, 71, 63, 96}}, new int[][]{{136, 136, 192, 192}, {88, 71, 63, 96}}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{{-17, -17, 31, 31}, {112, 47, 63, 96}}, new int[][]{{47, 47, 63, 63}, {112, 47, 63, 96}}, new int[][]{{96, 96, 112, 112}, {96, 63, 47, 112}}, new int[][]{{128, 128, 176, 176}, {96, 63, 47, 112}}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{{15, 15, 47, 47}, {144, 15, 47, 112}}, new int[][]{{112, 112, 144, 144}, {112, 47, 15, 144}}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{{-49, -49, 15, 15}, {208, -49, 15, 144}}, new int[][]{{144, 144, 208, 208}, {144, 15, -49, 208}}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}};
    int[][][] doors = new int[][][]{new int[][]{{25, 25, 37, 37}, {88, 73, 73, 88}}, new int[][]{{41, 41, 53, 53}, {88, 73, 73, 88}}, new int[][]{{57, 57, 69, 69}, {88, 73, 73, 88}}, new int[][]{{73, 73, 86, 86}, {88, 73, 73, 88}}, new int[][]{{90, 90, 102, 102}, {88, 73, 73, 88}}, new int[][]{{106, 106, 118, 118}, {88, 73, 73, 88}}, new int[][]{{122, 122, 134, 134}, {88, 73, 73, 88}}, new int[][]{null, null}, new int[][]{{3, 3, 27, 27}, {96, 67, 67, 96}}, new int[][]{{35, 35, 59, 59}, {96, 67, 67, 96}}, new int[][]{{67, 67, 92, 92}, {96, 67, 67, 96}}, new int[][]{{100, 100, 124, 124}, {96, 67, 67, 96}}, new int[][]{{132, 132, 156, 156}, {96, 67, 67, 96}}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{{-9, -9, 39, 39}, {112, 55, 55, 112}}, new int[][]{{55, 55, 104, 104}, {112, 55, 55, 112}}, new int[][]{{120, 120, 168, 168}, {112, 55, 55, 112}}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{{-97, -97, -1, -1}, {144, 31, 31, 144}}, new int[][]{{31, 31, 128, 128}, {144, 31, 31, 144}}, new int[][]{{160, 160, 256, 256}, {144, 31, 31, 144}}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{{-31, -31, 21, 21}, {94, 67, 71, 90}}, new int[][]{{1, 1, 37, 37}, {94, 67, 71, 90}}, new int[][]{{33, 33, 53, 53}, {94, 67, 71, 90}}, new int[][]{{65, 65, 69, 69}, {94, 67, 71, 90}}, new int[][]{{90, 90, 94, 94}, {90, 71, 67, 94}}, new int[][]{{106, 106, 126, 126}, {90, 71, 67, 94}}, new int[][]{{122, 122, 158, 158}, {90, 71, 67, 94}}, new int[][]{{138, 138, 190, 190}, {90, 71, 67, 94}}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{{-13, -13, 27, 27}, {108, 55, 63, 100}}, new int[][]{{51, 51, 59, 59}, {108, 55, 63, 100}}, new int[][]{{100, 100, 108, 108}, {100, 63, 55, 108}}, new int[][]{{132, 132, 172, 172}, {100, 63, 55, 108}}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{{23, 23, 39, 39}, {136, 31, 47, 120}}, new int[][]{{120, 120, 136, 136}, {120, 47, 31, 136}}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{{-41, -41, 7, 7}, {200, -33, 15, 152}}, new int[][]{{152, 152, 200, 200}, {152, 15, -33, 200}}, new int[][]{null, null}, new int[][]{null, null}, new int[][]{null, null}};

    public static void main(String[] stringArray) {
        String string;
        int[] nArray;
        int[] nArray2;
        int n;
        SegmentGenerator segmentGenerator = new SegmentGenerator();
        int[][][] nArray3 = segmentGenerator.generate(80, 80);
        System.out.println("int[][][] segments = {");
        System.out.println("// @formatter:off");
        System.out.println("// rows");
        for (n = 0; n < 35; ++n) {
            nArray2 = nArray3[n][0];
            nArray = nArray3[n][1];
            string = nArray2 == null && nArray == null ? "{                 null,                 null}" : String.format("{{%4d,%4d,%4d,%4d},{%4d,%4d,%4d,%4d}}", nArray2[0], nArray2[1], nArray2[2], nArray2[3], nArray[0], nArray[1], nArray[2], nArray[3]);
            System.out.print(string + ", //" + n + "\n");
        }
        System.out.println("// cols");
        for (n = 35; n < nArray3.length; ++n) {
            nArray2 = nArray3[n][0];
            nArray = nArray3[n][1];
            string = nArray2 == null && nArray == null ? "{                 null,                 null}" : String.format("{{%4d,%4d,%4d,%4d},{%4d,%4d,%4d,%4d}}", nArray2[0], nArray2[1], nArray2[2], nArray2[3], nArray[0], nArray[1], nArray[2], nArray[3]);
            System.out.print(string + ", //" + n + "\n");
        }
        System.out.println("// @formatter:on");
        System.out.println("};");
        System.out.println("int[][][] doors = {");
        System.out.println("// @formatter:off");
        for (n = 0; n < nArray3.length; ++n) {
            nArray2 = nArray3[n][0];
            nArray = nArray3[n][1];
            string = nArray2 == null || nArray == null ? "{                 null,                 null}" : (0 <= n && n <= 34 ? (0 <= n && n <= 6 ? String.format("{{%4d,%4d,%4d,%4d},{%4d,%4d,%4d,%4d}}", nArray2[0] + 2, nArray2[1] + 2, nArray2[2] - 2, nArray2[3] - 2, nArray[0], nArray[1] + 2, nArray[2] + 2, nArray[3]) : (7 <= n && n <= 13 ? String.format("{{%4d,%4d,%4d,%4d},{%4d,%4d,%4d,%4d}}", nArray2[0] + 4, nArray2[1] + 4, nArray2[2] - 4, nArray2[3] - 4, nArray[0], nArray[1] + 4, nArray[2] + 4, nArray[3]) : (14 <= n && n <= 20 ? String.format("{{%4d,%4d,%4d,%4d},{%4d,%4d,%4d,%4d}}", nArray2[0] + 8, nArray2[1] + 8, nArray2[2] - 8, nArray2[3] - 8, nArray[0], nArray[1] + 8, nArray[2] + 8, nArray[3]) : (21 <= n && n <= 27 ? String.format("{{%4d,%4d,%4d,%4d},{%4d,%4d,%4d,%4d}}", nArray2[0] + 16, nArray2[1] + 16, nArray2[2] - 16, nArray2[3] - 16, nArray[0], nArray[1] + 16, nArray[2] + 16, nArray[3]) : "{                 null,                 null}")))) : (35 <= n && n <= 66 ? (35 <= n && n <= 38 ? String.format("{{%4d,%4d,%4d,%4d},{%4d,%4d,%4d,%4d}}", nArray2[0] + 2, nArray2[1] + 2, nArray2[2] - 2, nArray2[3] - 2, nArray[0] - 2, nArray[1] + 4, nArray[2], nArray[3] + 2) : (43 <= n && n <= 46 ? String.format("{{%4d,%4d,%4d,%4d},{%4d,%4d,%4d,%4d}}", nArray2[0] + 4, nArray2[1] + 4, nArray2[2] - 4, nArray2[3] - 4, nArray[0] - 4, nArray[1] + 8, nArray[2], nArray[3] + 4) : (51 <= n && n <= 54 ? String.format("{{%4d,%4d,%4d,%4d},{%4d,%4d,%4d,%4d}}", nArray2[0] + 8, nArray2[1] + 8, nArray2[2] - 8, nArray2[3] - 8, nArray[0] - 8, nArray[1] + 16, nArray[2], nArray[3] + 8) : (59 <= n && n <= 62 ? String.format("{{%4d,%4d,%4d,%4d},{%4d,%4d,%4d,%4d}}", nArray2[0] + 8, nArray2[1] + 8, nArray2[2] - 8, nArray2[3] - 8, nArray[0] - 8, nArray[1] + 16, nArray[2], nArray[3] + 8) : (39 <= n && n <= 42 ? String.format("{{%4d,%4d,%4d,%4d},{%4d,%4d,%4d,%4d}}", nArray2[0] + 2, nArray2[1] + 2, nArray2[2] - 2, nArray2[3] - 2, nArray[0] + 2, nArray[1], nArray[2] + 4, nArray[3] - 2) : (47 <= n && n <= 50 ? String.format("{{%4d,%4d,%4d,%4d},{%4d,%4d,%4d,%4d}}", nArray2[0] + 4, nArray2[1] + 4, nArray2[2] - 4, nArray2[3] - 4, nArray[0] + 4, nArray[1], nArray[2] + 8, nArray[3] - 4) : (55 <= n && n <= 58 ? String.format("{{%4d,%4d,%4d,%4d},{%4d,%4d,%4d,%4d}}", nArray2[0] + 8, nArray2[1] + 8, nArray2[2] - 8, nArray2[3] - 8, nArray[0] + 8, nArray[1], nArray[2] + 16, nArray[3] - 8) : (63 <= n && n <= 66 ? String.format("{{%4d,%4d,%4d,%4d},{%4d,%4d,%4d,%4d}}", nArray2[0] + 8, nArray2[1] + 8, nArray2[2] - 8, nArray2[3] - 8, nArray[0] + 8, nArray[1], nArray[2] + 16, nArray[3] - 8) : "{                 null,                 null}")))))))) : "{                 null,                 null}"));
            System.out.print(string + ", //" + n + "\n");
        }
        System.out.println("// @formatter:on");
        System.out.println("};");
    }

    public static Map2DGridRenderer getInstance() {
        if (_instance == null) {
            _instance = new Map2DGridRenderer();
        }
        return _instance;
    }

    private Map2DGridRenderer() {
        this.image = new BufferedImage(160, 160, 2);
        this.texDC = TextureFactory.createTexture(this.image);
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 4; ++j) {
                RTile rTile = new RTile();
                rTile.x = i;
                rTile.y = j;
                this.tileBuffer[i][j] = rTile;
            }
        }
    }

    public void draw(Draw2D draw2D, int n, int n2) {
        draw2D.setColor(Color.WHITE);
        draw2D.drawTexture(this.texDC, n, n2);
    }

    private void draw160(Graphics graphics) {
        RTile[][] rTileArray = this.tileBuffer;
        this.put(graphics, rTileArray[0][0], 0);
        this.put(graphics, rTileArray[1][0], 0);
        this.put(graphics, rTileArray[2][0], 0);
        this.put(graphics, rTileArray[3][0], 0);
        this.put(graphics, rTileArray[4][0], 0);
        this.put(graphics, rTileArray[5][0], 0);
        this.put(graphics, rTileArray[6][0], 0);
        this.put(graphics, rTileArray[0][0], 3);
        this.put(graphics, rTileArray[6][0], 1);
        this.put(graphics, rTileArray[0][0], 1);
        this.put(graphics, rTileArray[6][0], 3);
        this.put(graphics, rTileArray[1][0], 1);
        this.put(graphics, rTileArray[5][0], 3);
        this.put(graphics, rTileArray[2][0], 1);
        this.put(graphics, rTileArray[4][0], 3);
        this.put(graphics, rTileArray[1][0], 2);
        this.put(graphics, rTileArray[2][0], 2);
        this.put(graphics, rTileArray[3][0], 2);
        this.put(graphics, rTileArray[4][0], 2);
        this.put(graphics, rTileArray[5][0], 2);
        this.put(graphics, rTileArray[1][1], 1);
        this.put(graphics, rTileArray[5][1], 3);
        this.put(graphics, rTileArray[2][1], 1);
        this.put(graphics, rTileArray[4][1], 3);
        this.put(graphics, rTileArray[2][1], 2);
        this.put(graphics, rTileArray[3][1], 2);
        this.put(graphics, rTileArray[4][1], 2);
        this.put(graphics, rTileArray[2][2], 1);
        this.put(graphics, rTileArray[4][2], 3);
        this.put(graphics, rTileArray[2][2], 2);
        this.put(graphics, rTileArray[3][2], 2);
        this.put(graphics, rTileArray[4][2], 2);
        this.put(graphics, rTileArray[3][3], 3);
        this.put(graphics, rTileArray[3][3], 1);
    }

    private int getType(TileEdge tileEdge) {
        switch (tileEdge.type) {
            case 0: {
                return 0;
            }
            case 1: 
            case 8: {
                return 1;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return 2;
            }
        }
        return 0;
    }

    private void put(Graphics graphics, RTile rTile, int n) {
        this.put(graphics, rTile.x, rTile.y, n, rTile.type[n]);
    }

    private void put(Graphics graphics, int n, int n2, int n3, int n4) {
        if (n4 == 0) {
            return;
        }
        int n5 = n2 * 7 + n;
        int n6 = 35 + n2 * 8 + n;
        int n7 = -1;
        switch (n3) {
            case 0: {
                n7 = n5;
                break;
            }
            case 2: {
                n7 = n5 + 7;
                break;
            }
            case 3: {
                n7 = n6;
                break;
            }
            case 1: {
                n7 = n6 + 1;
                break;
            }
        }
        int[] nArray = this.segments[n7][0];
        int[] nArray2 = this.segments[n7][1];
        graphics.setColor(java.awt.Color.black);
        graphics.fillPolygon(nArray, nArray2, 4);
        graphics.setColor(java.awt.Color.white);
        graphics.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
        graphics.drawLine(nArray[1], nArray2[1], nArray[2], nArray2[2]);
        graphics.drawLine(nArray[2], nArray2[2], nArray[3], nArray2[3]);
        graphics.drawLine(nArray[3], nArray2[3], nArray[0], nArray2[0]);
        if (n4 == 2) {
            nArray = this.doors[n7][0];
            nArray2 = this.doors[n7][1];
            if (nArray != null || nArray2 != null) {
                graphics.setColor(java.awt.Color.white);
                graphics.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
                graphics.drawLine(nArray[1], nArray2[1], nArray[2], nArray2[2]);
                graphics.drawLine(nArray[2], nArray2[2], nArray[3], nArray2[3]);
            }
        }
    }

    private void putTiles(Location location, Direction direction) {
        block11: {
            int n;
            int n2;
            int n3;
            int n4;
            Level level;
            block13: {
                block12: {
                    block10: {
                        level = location.getLevel();
                        n4 = location.x;
                        n3 = location.y;
                        for (n2 = 0; n2 < 7; ++n2) {
                            for (n = 0; n < 4; ++n) {
                                RTile rTile = this.tileBuffer[n2][n];
                                rTile.type[0] = 0;
                                rTile.type[1] = 0;
                                rTile.type[2] = 0;
                                rTile.type[3] = 0;
                            }
                        }
                        if (direction != Direction.NORTH) break block10;
                        for (n2 = 0; n2 < 7; ++n2) {
                            for (n = 0; n < 4; ++n) {
                                int n5 = n2 - 3;
                                int n6 = n - 3;
                                RTile rTile = this.tileBuffer[n2][n];
                                Tile tile = level.getTile(n4 + n5, n3 + n6);
                                if (tile == null) continue;
                                rTile.type[0] = this.getType(tile.edgeNorth);
                                rTile.type[1] = this.getType(tile.edgeEast);
                                rTile.type[2] = this.getType(tile.edgeSouth);
                                rTile.type[3] = this.getType(tile.edgeWest);
                            }
                        }
                        break block11;
                    }
                    if (direction != Direction.EAST) break block12;
                    for (n2 = 0; n2 < 7; ++n2) {
                        for (n = 0; n < 4; ++n) {
                            int n7 = (n - 3) * -1;
                            int n8 = n2 - 3;
                            RTile rTile = this.tileBuffer[n2][n];
                            Tile tile = level.getTile(n4 + n7, n3 + n8);
                            if (tile == null) continue;
                            rTile.type[0] = this.getType(tile.edgeEast);
                            rTile.type[1] = this.getType(tile.edgeSouth);
                            rTile.type[2] = this.getType(tile.edgeWest);
                            rTile.type[3] = this.getType(tile.edgeNorth);
                        }
                    }
                    break block11;
                }
                if (direction != Direction.SOUTH) break block13;
                for (n2 = 0; n2 < 7; ++n2) {
                    for (n = 0; n < 4; ++n) {
                        int n9 = (n2 - 3) * -1;
                        int n10 = (n - 3) * -1;
                        RTile rTile = this.tileBuffer[n2][n];
                        Tile tile = level.getTile(n4 + n9, n3 + n10);
                        if (tile == null) continue;
                        rTile.type[0] = this.getType(tile.edgeSouth);
                        rTile.type[1] = this.getType(tile.edgeWest);
                        rTile.type[2] = this.getType(tile.edgeNorth);
                        rTile.type[3] = this.getType(tile.edgeEast);
                    }
                }
                break block11;
            }
            if (direction != Direction.WEST) break block11;
            for (n2 = 0; n2 < 7; ++n2) {
                for (n = 0; n < 4; ++n) {
                    int n11 = n - 3;
                    int n12 = (n2 - 3) * -1;
                    RTile rTile = this.tileBuffer[n2][n];
                    Tile tile = level.getTile(n4 + n11, n3 + n12);
                    if (tile == null) continue;
                    rTile.type[0] = this.getType(tile.edgeWest);
                    rTile.type[1] = this.getType(tile.edgeNorth);
                    rTile.type[2] = this.getType(tile.edgeEast);
                    rTile.type[3] = this.getType(tile.edgeSouth);
                }
            }
        }
    }

    private void debug_render() {
        try {
            ImageIO.write((RenderedImage)this.image, "png", new File("grid_render.png"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void update(Location location, Direction direction) {
        this.putTiles(location, direction);
        Graphics graphics = this.image.getGraphics();
        graphics.setColor(java.awt.Color.black);
        graphics.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
        graphics.setColor(java.awt.Color.white);
        this.draw160(graphics);
        for (int i = 0; i < this.image.getHeight(); ++i) {
            for (int j = 0; j < this.image.getWidth(); ++j) {
                int n = this.image.getRGB(j, i);
                if ((n & 0xFFFFFF) != 0) continue;
                this.image.setRGB(j, i, 0);
            }
        }
        TextureFactory.updateTexture(this.texDC, this.image);
    }

    public static class SegmentGenerator {
        private int[] pts = new int[]{8, 8, 24, 8, 40, 8, 56, 8, 16, 16, 48, 16, 80, 16, 112, 16, 32, 32, 96, 32, 160, 32, 224, 32, 64, 64, 192, 64, 320, 64, 448, 64, 128, 128};
        private int[] idx = new int[]{-4, 0, 0, -4, 0, 1, -3, 0, 1, -3, 0, 0, -3, 0, 0, -3, 0, 1, -2, 0, 1, -2, 0, 0, -2, 0, 0, -2, 0, 1, -1, 0, 1, -1, 0, 0, -1, 0, 0, -1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 1, 0, 0, 1, 0, 1, 2, 0, 1, 2, 0, 0, 2, 0, 0, 2, 0, 1, 3, 0, 1, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -3, 1, 0, -3, 1, 1, -2, 1, 1, -2, 1, 0, -2, 1, 0, -2, 1, 1, -1, 1, 1, -1, 1, 0, -1, 1, 0, -1, 1, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 2, 1, 1, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2, 2, 0, -2, 2, 1, -1, 2, 1, -1, 2, 0, -1, 2, 0, -1, 2, 1, 0, 2, 1, 0, 2, 0, 0, 2, 0, 0, 2, 1, 1, 2, 1, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2, 3, 0, -2, 3, 1, -1, 3, 1, -1, 3, 0, -1, 3, 0, -1, 3, 1, 0, 3, 1, 0, 3, 0, 0, 3, 0, 0, 3, 1, 1, 3, 1, 1, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -4, 1, 0, -4, 1, 1, -4, 0, 1, -4, 0, 0, -3, 1, 0, -3, 1, 1, -3, 0, 1, -3, 0, 0, -2, 1, 0, -2, 1, 1, -2, 0, 1, -2, 0, 0, -1, 1, 0, -1, 1, 1, -1, 0, 1, -1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 2, 0, 0, 2, 0, 1, 2, 1, 1, 2, 1, 0, 3, 0, 0, 3, 0, 1, 3, 1, 1, 3, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2, 2, 0, -2, 2, 1, -2, 1, 1, -2, 1, 0, -1, 2, 0, -1, 2, 1, -1, 1, 1, -1, 1, 0, 0, 1, 0, 0, 1, 1, 0, 2, 1, 0, 2, 0, 1, 1, 0, 1, 1, 1, 1, 2, 1, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 3, 0, -1, 3, 1, -1, 2, 1, -1, 2, 0, 0, 2, 0, 0, 2, 1, 0, 3, 1, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 4, 0, -1, 4, 1, -1, 3, 1, -1, 3, 0, 0, 3, 0, 0, 3, 1, 0, 4, 1, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

        private int[] getPoint(int n, int n2, int n3) {
            if (n3 == 0) {
                if (n >= 0) {
                    int n4 = n;
                    int n5 = n2;
                    int n6 = n5 * 4 + n4;
                    int n7 = this.pts[n6 * 2 + 0];
                    int n8 = this.pts[n6 * 2 + 1];
                    return new int[]{n7, n8};
                }
                int n9 = Math.abs(n) - 1;
                int n10 = n2;
                int n11 = n10 * 4 + n9;
                int n12 = this.pts[n11 * 2 + 0];
                int n13 = this.pts[n11 * 2 + 1];
                return new int[]{-n12 - 1, n13};
            }
            if (n >= 0) {
                int n14 = n;
                int n15 = n2;
                int n16 = n15 * 4 + n14;
                int n17 = this.pts[n16 * 2 + 0];
                int n18 = this.pts[n16 * 2 + 1];
                return new int[]{n17, -n18 - 1};
            }
            int n19 = Math.abs(n) - 1;
            int n20 = n2;
            int n21 = n20 * 4 + n19;
            int n22 = this.pts[n21 * 2 + 0];
            int n23 = this.pts[n21 * 2 + 1];
            return new int[]{-n22 - 1, -n23 - 1};
        }

        private boolean isEmptyIdx(int n) {
            for (int i = 0; i < 12; ++i) {
                if (this.idx[n + i] == 0) continue;
                return false;
            }
            return true;
        }

        public int[][][] generate(int n, int n2) {
            int[][][] nArray = new int[67][2][4];
            int n3 = 0;
            for (int i = 0; i < this.idx.length; i += 12) {
                if (this.isEmptyIdx(i)) {
                    nArray[n3][0] = null;
                    nArray[n3][1] = null;
                } else {
                    int[] nArray2 = this.getPoint(this.idx[i + 0], this.idx[i + 1], this.idx[i + 2]);
                    int[] nArray3 = this.getPoint(this.idx[i + 3], this.idx[i + 4], this.idx[i + 5]);
                    int[] nArray4 = this.getPoint(this.idx[i + 6], this.idx[i + 7], this.idx[i + 8]);
                    int[] nArray5 = this.getPoint(this.idx[i + 9], this.idx[i + 10], this.idx[i + 11]);
                    int[] nArray6 = new int[]{nArray2[0], nArray3[0], nArray4[0], nArray5[0]};
                    int[] nArray7 = new int[]{nArray2[1], nArray3[1], nArray4[1], nArray5[1]};
                    int n4 = 0;
                    while (n4 < 4) {
                        int n5 = n4;
                        nArray6[n5] = nArray6[n5] + n;
                        int n6 = n4++;
                        nArray7[n6] = nArray7[n6] + n2;
                    }
                    nArray[n3][0] = nArray6;
                    nArray[n3][1] = nArray7;
                }
                ++n3;
            }
            return nArray;
        }
    }

    private static class RTile {
        public int x;
        public int y;
        public int[] type = new int[4];

        private RTile() {
        }
    }
}

