/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.renderer;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class Map2DGenerator {
    public static void skew_step(BufferedImage bufferedImage, BufferedImage bufferedImage2, float[] fArray, int n, int n2, boolean bl, float f) {
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        float f2 = fArray[0];
        float f3 = fArray[1];
        float f4 = fArray[2];
        float f5 = fArray[3];
        float f6 = (float)n3 / f4;
        for (int i = 0; i < (int)f4; ++i) {
            float f7 = (float)i * f6;
            float f8 = f2 + (float)i;
            int n5 = n != 0 ? i / n : 0;
            int n6 = n2 != 0 ? (int)f5 + i / n2 : (int)f5;
            for (int j = n5; j < n6; ++j) {
                int n7;
                float f9 = (float)(n6 - n5) / (float)n4;
                float f10 = (float)(j - n5) / f9;
                float f11 = f3 + (float)j;
                if (f7 < 0.0f || f7 >= (float)bufferedImage.getWidth() || f10 < 0.0f || f10 >= (float)bufferedImage.getHeight()) continue;
                if (bl) {
                    n7 = bufferedImage.getRGB((int)f7, (int)f10);
                    if (n7 == 0) continue;
                    ArrayList<Point> arrayList = new ArrayList<Point>();
                    if (f7 - 1.0f >= 0.0f) {
                        arrayList.add(new Point(f7 - 1.0f, f10));
                    }
                    if (f7 + 1.0f < (float)bufferedImage.getWidth()) {
                        arrayList.add(new Point(f7 + 1.0f, f10));
                    }
                    if (f10 - 1.0f >= 0.0f) {
                        arrayList.add(new Point(f7, f10 - 1.0f));
                    }
                    if (f10 + 1.0f < (float)bufferedImage.getHeight()) {
                        arrayList.add(new Point(f7, f10 + 1.0f));
                    }
                    float f12 = n7 >> 16 & 0xFF;
                    float f13 = n7 >> 8 & 0xFF;
                    float f14 = n7 & 0xFF;
                    int n8 = 0;
                    for (Point point : arrayList) {
                        int n9 = bufferedImage.getRGB((int)point.x, (int)point.y);
                        if (n9 == 0) continue;
                        float f15 = n9 >> 16 & 0xFF;
                        float f16 = n9 >> 8 & 0xFF;
                        float f17 = n9 & 0xFF;
                        f12 += f15 * f;
                        f13 += f16 * f;
                        f14 += f17 * f;
                        ++n8;
                    }
                    int n10 = 0xFF000000 | (int)(f12 /= (float)n8 * f + 1.0f) << 16 | (int)(f13 /= (float)n8 * f + 1.0f) << 8 | (int)(f14 /= (float)n8 * f + 1.0f);
                    bufferedImage2.setRGB((int)f8, (int)f11, n10);
                    continue;
                }
                n7 = bufferedImage.getRGB((int)f7, (int)f10);
                bufferedImage2.setRGB((int)f8, (int)f11, n7);
            }
        }
    }

    public static void generate(BufferedImage bufferedImage, BufferedImage bufferedImage2, boolean bl) {
        Map2DGenerator.skew_step(bufferedImage, bufferedImage2, new float[]{0.0f, 72.0f, 16.0f, 16.0f}, 0, 0, bl, 1.0f);
        Map2DGenerator.skew_step(bufferedImage, bufferedImage2, new float[]{16.0f, 64.0f, 32.0f, 32.0f}, 0, 0, bl, 0.4f);
        Map2DGenerator.skew_step(bufferedImage, bufferedImage2, new float[]{48.0f, 48.0f, 64.0f, 64.0f}, 0, 0, bl, 0.2f);
        Map2DGenerator.skew_step(bufferedImage, bufferedImage2, new float[]{112.0f, 16.0f, 128.0f, 128.0f}, 0, 0, bl, 0.1f);
        BufferedImage bufferedImage3 = bufferedImage.getSubimage(96, 0, 32, 128);
        Map2DGenerator.skew_step(bufferedImage3, bufferedImage2, new float[]{240.0f, 0.0f, 16.0f, 160.0f}, 1, -1, bl, 0.3f);
        Map2DGenerator.skew_step(bufferedImage, bufferedImage2, new float[]{256.0f, 16.0f, 32.0f, 128.0f}, 1, -1, bl, 0.2f);
        Map2DGenerator.skew_step(bufferedImage, bufferedImage2, new float[]{288.0f, 48.0f, 16.0f, 64.0f}, 1, -1, bl, 0.4f);
        Map2DGenerator.skew_step(bufferedImage, bufferedImage2, new float[]{304.0f, 64.0f, 8.0f, 32.0f}, 1, -1, bl, 1.0f);
        Map2DGenerator.skew_step(bufferedImage, bufferedImage2, new float[]{320.0f, 48.0f, 48.0f, 64.0f}, 3, -3, bl, 0.4f);
        Map2DGenerator.skew_step(bufferedImage, bufferedImage2, new float[]{368.0f, 64.0f, 24.0f, 32.0f}, 3, -3, bl, 0.8f);
        Map2DGenerator.skew_step(bufferedImage, bufferedImage2, new float[]{416.0f, 64.0f, 40.0f, 32.0f}, 4, -4, bl, 1.0f);
    }

    public static void main(String[] stringArray) {
        try {
            BufferedImage bufferedImage = ImageIO.read(new File("dc-tiles-texture.png"));
            BufferedImage bufferedImage2 = new BufferedImage(496, 160, 2);
            Map2DGenerator.generate(bufferedImage, bufferedImage2, true);
            ImageIO.write((RenderedImage)bufferedImage2, "png", new File("fnardbobjeo.png"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static class Point {
        public float x;
        public float y;

        public Point(float f, float f2) {
            this.x = f;
            this.y = f2;
        }
    }
}

