/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.persistence;

import de.slashbinbash.hexen.bank.BankSystem;
import de.slashbinbash.hexen.bestiary.Bestiary;
import de.slashbinbash.hexen.bestiary.BestiarySystem;
import de.slashbinbash.hexen.chest.Chest;
import de.slashbinbash.hexen.chest.ChestSystem;
import de.slashbinbash.hexen.deadpool.DeadpoolSystem;
import de.slashbinbash.hexen.door.Door;
import de.slashbinbash.hexen.door.DoorSystem;
import de.slashbinbash.hexen.factory.AbilityFactory;
import de.slashbinbash.hexen.factory.AttributeFactory;
import de.slashbinbash.hexen.factory.CombatActionFactory;
import de.slashbinbash.hexen.factory.CreatureFactory;
import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.factory.ItemFactory;
import de.slashbinbash.hexen.factory.ModFactory;
import de.slashbinbash.hexen.factory.ModifierFactory;
import de.slashbinbash.hexen.factory.TraitFactory;
import de.slashbinbash.hexen.guild.Guild;
import de.slashbinbash.hexen.guild.GuildSystem;
import de.slashbinbash.hexen.map.Location;
import de.slashbinbash.hexen.model.ClassCreature;
import de.slashbinbash.hexen.model.Condition;
import de.slashbinbash.hexen.model.Conditions;
import de.slashbinbash.hexen.model.ItemGroup;
import de.slashbinbash.hexen.model.Modifiers;
import de.slashbinbash.hexen.model.Party;
import de.slashbinbash.hexen.model.SlotItem;
import de.slashbinbash.hexen.model.Slots;
import de.slashbinbash.hexen.persistence.SaveState;
import de.slashbinbash.hexen.quest.Quest;
import de.slashbinbash.hexen.quest.QuestState;
import de.slashbinbash.hexen.quest.QuestSystem;
import de.slashbinbash.hexen.shop.ShopSystem;
import de.slashbinbash.hexen.temple.TempleSystem;
import de.slashbinbash.hexen.workbench.RecipeSystem;
import de.slashbinbash.util.StaticXML;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Loader {
    public static BankSystem createBankSystem(Element element) {
        BankSystem bankSystem = new BankSystem();
        block6: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "account": {
                    bankSystem.currency = StaticXML.getInt(element2, "balance");
                    continue block6;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return bankSystem;
    }

    public static BestiarySystem createBestiarySystem(Element element) {
        BestiarySystem bestiarySystem = new BestiarySystem();
        for (Element element2 : StaticXML.getChildElements(element)) {
            String string = StaticXML.getAttribute(element2, "id");
            Bestiary.State state = new Bestiary.State(string);
            state.creatureName = StaticXML.getAttribute(element2, "name");
            state.recorded = StaticXML.getInt(element2, "defeated");
            state.reported = StaticXML.getInt(element2, "reported");
            bestiarySystem.map.put(string, state);
        }
        return bestiarySystem;
    }

    public static ChestSystem createChestSystem(Element element) {
        ChestSystem chestSystem = new ChestSystem();
        for (Element element2 : StaticXML.getChildElements(element)) {
            Chest.State state = new Chest.State();
            state.id = StaticXML.getAttribute(element2, "id");
            state.empty = StaticXML.getBool(element2, "empty");
            chestSystem.states.put(state.id, state);
        }
        return chestSystem;
    }

    public static ClassCreature createCreature(Element element) {
        ClassCreature classCreature = new ClassCreature();
        classCreature.modifiers = new Modifiers();
        block58: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "id": {
                    classCreature.__id__ = StaticXML.getText(element2);
                    break;
                }
                case "hp": {
                    classCreature.hitPoints = Integer.parseInt(StaticXML.getText(element2));
                    break;
                }
                case "maxhp": {
                    classCreature.maxHitPoints = Integer.parseInt(StaticXML.getText(element2));
                    break;
                }
                case "ap": {
                    classCreature.actionPoints = Integer.parseInt(StaticXML.getText(element2));
                    break;
                }
                case "maxap": {
                    classCreature.maxActionPoints = Integer.parseInt(StaticXML.getText(element2));
                    break;
                }
                case "name": {
                    classCreature.name = StaticXML.getText(element2);
                    break;
                }
                case "numCombats": {
                    classCreature.numCombats = Integer.valueOf(StaticXML.getText(element2));
                    break;
                }
                case "numRevives": {
                    classCreature.numRevives = Integer.valueOf(StaticXML.getText(element2));
                    break;
                }
                case "portrait": {
                    classCreature.portrait = StaticXML.getText(element2);
                    break;
                }
                case "playable": {
                    classCreature.playable = Boolean.valueOf(StaticXML.getText(element2));
                    break;
                }
                case "timeStarted": {
                    classCreature.timeStarted = Long.valueOf(StaticXML.getText(element2));
                    break;
                }
                case "vim": {
                    classCreature.vim = Integer.valueOf(StaticXML.getText(element2));
                    break;
                }
                case "job": {
                    classCreature.job = StaticXML.getText(element2);
                    break;
                }
                case "abilities": {
                    classCreature.modifiers.modAbilities = AbilityFactory.createAbilities(element2);
                    break;
                }
                case "attributes": {
                    classCreature.modifiers.modAttributes = AttributeFactory.createAttributes(element2);
                    break;
                }
                case "combatActions": {
                    classCreature.combatActions = CombatActionFactory.createCombatActions(element2);
                    break;
                }
                case "conditions": {
                    Object object;
                    classCreature.conditions = new Conditions();
                    Object object2 = StaticXML.getChildElements(element2).iterator();
                    while (object2.hasNext()) {
                        object = (Element)object2.next();
                        String string = StaticXML.getAttribute((Element)object, "ref");
                        Condition condition = new Condition(string);
                        block60: for (Element element3 : StaticXML.getChildElements((Element)object)) {
                            switch (element3.getTagName()) {
                                case "timeLeftSeconds": {
                                    condition.timeLeftSeconds = Long.valueOf(StaticXML.getText(element3));
                                    continue block60;
                                }
                            }
                            StaticXML.errUnknownTag(element3);
                        }
                        classCreature.conditions.add(condition);
                    }
                    continue block58;
                }
                case "equipment": {
                    Object object2;
                    if (!StaticXML.hasAttribute(element2, "ref")) continue block58;
                    classCreature.equipment = object2 = ItemFactory.createItem(element2.getAttribute("ref"));
                    break;
                }
                case "modifiers": {
                    classCreature.modifiers = ModifierFactory.createModifiers(element2);
                    break;
                }
                case "mods": {
                    Object object2 = StaticXML.getAttribute(element2, "slots");
                    Object object = CreatureFactory.createSlots((String)object2);
                    block61: for (Element element4 : StaticXML.getChildElements(element2)) {
                        switch (element4.getTagName()) {
                            case "slot": {
                                int n = StaticXML.getInt(element4, "id");
                                String string = StaticXML.getAttribute(element4, "ref");
                                SlotItem.Data data = ModFactory.createModDesc(string);
                                boolean bl = ((Slots)object).set(n, data);
                                assert (bl);
                                continue block61;
                            }
                        }
                        StaticXML.errUnknownTag(element4);
                    }
                    classCreature.mods = object;
                    break;
                }
                case "traits": {
                    classCreature.setTraits(TraitFactory.createTraits(element2));
                    break;
                }
                default: {
                    StaticXML.errUnknownTag(element2);
                }
            }
        }
        return classCreature;
    }

    public static List<ClassCreature> createCreatures(Element element) {
        ArrayList<ClassCreature> arrayList = new ArrayList<ClassCreature>();
        for (Element element2 : StaticXML.getChildElements(element)) {
            assert (element2.getTagName().equals("creature"));
            arrayList.add(Loader.createCreature(element2));
        }
        return arrayList;
    }

    public static DeadpoolSystem createDeadpoolSystem(Element element) {
        DeadpoolSystem deadpoolSystem = new DeadpoolSystem();
        deadpoolSystem.lostSouls = StaticXML.getInt(element, "lost");
        DeadpoolSystem.Entry entry = new DeadpoolSystem.Entry();
        block8: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "location": {
                    String string = StaticXML.getAttribute(element2, "map");
                    int n = StaticXML.getInt(element2, "level");
                    int n2 = StaticXML.getInt(element2, "x");
                    int n3 = StaticXML.getInt(element2, "y");
                    entry.location = new DeadpoolSystem.Location(string, n, n2, n3);
                    continue block8;
                }
                case "party": {
                    entry.party = Loader.createParty(element2);
                    continue block8;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        assert (entry.location != null);
        assert (entry.party != null);
        deadpoolSystem.entry = entry;
        return deadpoolSystem;
    }

    public static DoorSystem createDoorSystem(Element element) {
        DoorSystem doorSystem = new DoorSystem();
        for (Element element2 : StaticXML.getChildElements(element)) {
            Door.State state = new Door.State();
            state.id = StaticXML.getAttribute(element2, "id");
            state.lock_unlocked = StaticXML.getBool(element2, "lock_unlocked");
            doorSystem.states.put(state.id, state);
        }
        return doorSystem;
    }

    public static GuildSystem createGuildSystem(Element element) {
        GuildSystem guildSystem = new GuildSystem();
        for (Element element2 : StaticXML.getChildElements(element)) {
            String string = StaticXML.getAttribute(element2, "id");
            Guild.State state = new Guild.State();
            Element element3 = StaticXML.getElement(element2, "creatures");
            if (element3 != null) {
                state.entries = Loader.createCreatures(element3);
            }
            guildSystem.setState(string, state);
        }
        return guildSystem;
    }

    public static boolean[][] createLevelVisited(Element element) {
        int n = StaticXML.getInt(element, "width");
        int n2 = StaticXML.getInt(element, "height");
        return Loader.readBinaryData(StaticXML.getText(element), n, n2);
    }

    public static Party createParty(Element element) {
        Party party = new Party();
        block12: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "creatures": {
                    party.getMembers().addAll(Loader.createCreatures(element2));
                    break;
                }
                case "gold": {
                    party.inventory.addCurrency(Integer.parseInt(StaticXML.getText(element2)));
                    break;
                }
                case "inventory": {
                    for (ItemGroup itemGroup : Factory.createItemGroups(element2)) {
                        party.inventory.add(itemGroup.getId(), itemGroup.size);
                    }
                    continue block12;
                }
                case "guild": {
                    party.guild = StaticXML.getAttribute(element2, "id");
                    break;
                }
                default: {
                    StaticXML.errUnknownTag(element2);
                }
            }
        }
        return party;
    }

    public static QuestSystem createQuestSystem(Element element) {
        QuestSystem questSystem = new QuestSystem();
        for (Element element2 : StaticXML.getChildElements(element)) {
            assert (element2.getTagName().equals("quest"));
            String string = StaticXML.getAttribute(element2, "ref");
            Quest.State state = new Quest.State();
            state.state = QuestState.valueOf(StaticXML.getAttribute(element2, "state"));
            state.started = StaticXML.getLong(element2, "started");
            questSystem.setState(string, state);
        }
        return questSystem;
    }

    public static RecipeSystem createRecipeSystem(Element element) {
        RecipeSystem recipeSystem = new RecipeSystem();
        for (Element element2 : StaticXML.getChildElements(element)) {
            String string = StaticXML.getAttribute(element2, "ref");
            recipeSystem.addRecipe(string);
        }
        return recipeSystem;
    }

    public static SaveState createSaveState(Document document) {
        SaveState saveState = new SaveState();
        block36: for (Element element : StaticXML.getChildElements(document.getDocumentElement())) {
            switch (element.getTagName()) {
                case "location": {
                    Location location = new Location();
                    location.mapId = StaticXML.getAttribute(element, "mapId");
                    location.level = StaticXML.getInt(element, "level");
                    location.x = StaticXML.getInt(element, "x");
                    location.y = StaticXML.getInt(element, "y");
                    saveState.location = location;
                    continue block36;
                }
                case "pak": {
                    saveState.pak = StaticXML.getText(element);
                    continue block36;
                }
                case "party": {
                    saveState.party = Loader.createParty(element);
                    continue block36;
                }
                case "levelVisited": {
                    saveState.levelVisited = Loader.createLevelVisited(element);
                    continue block36;
                }
                case "bank": {
                    saveState.bankSystem = Loader.createBankSystem(element);
                    continue block36;
                }
                case "bestiary": {
                    saveState.bestiarySystem = Loader.createBestiarySystem(element);
                    continue block36;
                }
                case "chests": {
                    saveState.chestSystem = Loader.createChestSystem(element);
                    continue block36;
                }
                case "deadpool": {
                    saveState.deadpoolSystem = Loader.createDeadpoolSystem(element);
                    continue block36;
                }
                case "doors": {
                    saveState.doorSystem = Loader.createDoorSystem(element);
                    continue block36;
                }
                case "guilds": {
                    saveState.guildSystem = Loader.createGuildSystem(element);
                    continue block36;
                }
                case "quests": {
                    saveState.questSystem = Loader.createQuestSystem(element);
                    continue block36;
                }
                case "recipes": {
                    saveState.recipeSystem = Loader.createRecipeSystem(element);
                    continue block36;
                }
                case "shops": {
                    saveState.shopSystem = Loader.createShopSystem(element);
                    continue block36;
                }
                case "states": {
                    saveState.stateMap = Loader.createStateMap(element);
                    continue block36;
                }
                case "temples": {
                    saveState.templeSystem = Loader.createTempleSystem(element);
                    continue block36;
                }
                case "timeSeconds": {
                    saveState.timeSeconds = Long.valueOf(StaticXML.getText(element));
                    continue block36;
                }
            }
            StaticXML.errUnknownTag(element);
        }
        return saveState;
    }

    public static ShopSystem createShopSystem(Element element) {
        ShopSystem shopSystem = new ShopSystem();
        block6: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "identified": {
                    for (Element element3 : StaticXML.getChildElements(element2)) {
                        String string = StaticXML.getAttribute(element3, "ref");
                        shopSystem.identifiedItems.add(string);
                    }
                    continue block6;
                }
                default: {
                    StaticXML.errUnknownTag(element2);
                }
            }
        }
        return shopSystem;
    }

    public static HashMap<String, Object> createStateMap(Element element) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        block6: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "state": {
                    String string = StaticXML.getAttribute(element2, "key");
                    Object object = null;
                    String string2 = StaticXML.getAttribute(element2, "value", null);
                    object = Loader.isBoolean(string2) ? Boolean.valueOf(Boolean.parseBoolean(string2)) : (Loader.isInteger(string2) ? Integer.valueOf(Integer.parseInt(string2)) : string2);
                    hashMap.put(string, object);
                    continue block6;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return hashMap;
    }

    public static TempleSystem createTempleSystem(Element element) {
        TempleSystem templeSystem = new TempleSystem();
        block6: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "donations": {
                    for (Element element3 : StaticXML.getChildElements(element2)) {
                        String string = StaticXML.getAttribute(element3, "id");
                        int n = StaticXML.getInt(element3, "value");
                        templeSystem.donations.put(string, n);
                    }
                    continue block6;
                }
                default: {
                    StaticXML.errUnknownTag(element2);
                }
            }
        }
        return templeSystem;
    }

    private static boolean isBoolean(String string) {
        return string != null && (string.equals("true") || string.equals("false"));
    }

    private static boolean isInteger(String string) {
        if (string == null) {
            return false;
        }
        char c = string.charAt(0);
        return '0' <= c && c <= '9';
    }

    public static SaveState load(File file) throws Exception {
        Document document = StaticXML.loadXML(file);
        return Loader.createSaveState(document);
    }

    public static boolean[][] readBinaryData(String string, int n, int n2) {
        string = string.strip();
        boolean[][] blArray = new boolean[n][n2];
        for (int i = 0; i < n * n2; ++i) {
            char c = string.charAt(i);
            int n3 = i / n2;
            int n4 = i % n2;
            blArray[n3][n4] = c != '0';
        }
        return blArray;
    }
}

