/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.model;

import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.enums.Ability;
import de.slashbinbash.hexen.enums.Attribute;
import de.slashbinbash.hexen.enums.Direction;
import de.slashbinbash.hexen.map.Location;
import de.slashbinbash.hexen.model.Abilities;
import de.slashbinbash.hexen.model.ClassCreature;
import de.slashbinbash.hexen.model.Condition;
import de.slashbinbash.hexen.model.Inventory;
import de.slashbinbash.hexen.model.Trait;
import de.slashbinbash.hexen.quest.Quest;
import de.slashbinbash.hexen.quest.QuestFactory;
import de.slashbinbash.hexen.quest.QuestState;
import de.slashbinbash.hexen.quest.QuestSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Party {
    public static int MAX_SIZE = 6;
    private Location location;
    public Direction direction = Direction.NORTH;
    private List<ClassCreature> members = new ArrayList<ClassCreature>();
    public Inventory inventory = new Inventory();
    public String guild = null;

    public void addMember(ClassCreature classCreature) {
        if (!this.members.contains(classCreature)) {
            this.members.add(classCreature);
        }
    }

    public boolean canMove() {
        if (this.isEncumbered()) {
            return false;
        }
        for (ClassCreature classCreature : this.members) {
            if (!classCreature.canMove()) continue;
            return true;
        }
        return false;
    }

    public boolean containsMember(ClassCreature classCreature) {
        if (this.members.contains(classCreature)) {
            return true;
        }
        for (ClassCreature classCreature2 : this.members) {
            if (!classCreature.__id__.equals(classCreature2.__id__)) continue;
            return true;
        }
        return false;
    }

    public List<ClassCreature> filterByAbility(Abilities abilities, boolean bl) {
        ArrayList<ClassCreature> arrayList = new ArrayList<ClassCreature>(this.members);
        arrayList.removeIf(classCreature -> !classCreature.hasAbilities(abilities));
        return arrayList;
    }

    public int getAbilityScoreMax(Ability ability) {
        int n = 0;
        for (ClassCreature classCreature : this.members) {
            if (!classCreature.canUseAbilities()) continue;
            n = Math.max(n, classCreature.calcAbilityScore(ability));
        }
        return n;
    }

    public int getAbilityScoreMin(Ability ability) {
        int n = Integer.MAX_VALUE;
        for (ClassCreature classCreature : this.members) {
            if (!classCreature.canUseAbilities()) continue;
            n = Math.min(n, classCreature.calcAbilityScore(ability));
        }
        return n;
    }

    public int getAbilityScoreSum(Ability ability) {
        int n = 0;
        for (ClassCreature classCreature : this.members) {
            if (!classCreature.canUseAbilities()) continue;
            n += classCreature.calcAbilityScore(ability);
        }
        return n;
    }

    public int getAbilityScoreAvg(Ability ability) {
        return Math.round((float)this.getAbilityScoreSum(ability) / (float)this.members.size());
    }

    public int getAttributeScoreSum(Attribute attribute) {
        int n = 0;
        for (ClassCreature object : this.members) {
            n += object.calcAttributeScore(attribute);
        }
        QuestSystem questSystem = RPG.getInstance().questSystem;
        for (Map.Entry<String, Quest.State> entry : questSystem.entrySet()) {
            String string = entry.getKey();
            Quest.State state = entry.getValue();
            if (state.state != QuestState.CLOSED) continue;
            Quest quest = QuestFactory.createQuest(string);
            if (quest._data.attributes == null) continue;
            n += quest._data.attributes.get(attribute);
        }
        return n;
    }

    public Location getLocation() {
        return this.location;
    }

    public ClassCreature getMember(int n) {
        return this.members.get(n);
    }

    public List<ClassCreature> getMembers() {
        return this.members;
    }

    public boolean hasCondition(Condition condition) {
        for (ClassCreature classCreature : this.members) {
            if (!classCreature.hasCondition(condition)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMember(ClassCreature classCreature) {
        for (ClassCreature classCreature2 : this.members) {
            if (classCreature2 != classCreature) continue;
            return true;
        }
        return false;
    }

    public boolean hasTrait(Trait trait) {
        for (ClassCreature classCreature : this.members) {
            if (!classCreature.hasTrait(trait)) continue;
            return true;
        }
        return false;
    }

    public boolean isDead() {
        if (this.members.isEmpty()) {
            return false;
        }
        for (ClassCreature classCreature : this.members) {
            if (!classCreature.isAlive()) continue;
            return false;
        }
        return true;
    }

    public boolean isEncumbered() {
        return this.inventory.size() > 12;
    }

    public boolean isFull() {
        return this.members.size() >= MAX_SIZE;
    }

    public ClassCreature pickRandom() {
        return this.members.get(RPG.rand.nextInt(this.members.size()));
    }

    public void removeMember(ClassCreature classCreature) {
        this.members.remove(classCreature);
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void tickConditions(long l) {
        for (ClassCreature classCreature : this.members) {
            classCreature.tickConditions(l);
            classCreature.removeConditionsIf(condition -> condition.timeLeftSeconds <= 0L);
        }
    }
}

