/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.model;

import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.Util;
import de.slashbinbash.hexen.enums.Ability;
import de.slashbinbash.hexen.enums.Attribute;
import de.slashbinbash.hexen.model.Abilities;
import de.slashbinbash.hexen.model.CombatAction;
import de.slashbinbash.hexen.model.CombatActions;
import de.slashbinbash.hexen.model.Condition;
import de.slashbinbash.hexen.model.ConditionImmunities;
import de.slashbinbash.hexen.model.ConditionImmunity;
import de.slashbinbash.hexen.model.Conditions;
import de.slashbinbash.hexen.model.Damage;
import de.slashbinbash.hexen.model.Item;
import de.slashbinbash.hexen.model.Modifiers;
import de.slashbinbash.hexen.model.Slot;
import de.slashbinbash.hexen.model.SlotItem;
import de.slashbinbash.hexen.model.Slots;
import de.slashbinbash.hexen.model.Trait;
import de.slashbinbash.hexen.model.Traits;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class ClassCreature {
    public String __id__ = null;
    public String name = null;
    public String portrait = null;
    public String job = null;
    public boolean playable = true;
    public int hitPoints = 0;
    public int actionPoints = 0;
    public int maxHitPoints = 0;
    public int maxActionPoints = 0;
    public int maxCombatActions = 8;
    public int vim = 0;
    public long timeStarted = 0L;
    public int numCombats = 0;
    public int numRevives = 0;
    public Traits traits = null;
    public CombatActions combatActions = null;
    public Modifiers modifiers = null;
    public Slots mods = null;
    public Item equipment = null;
    public Conditions conditions = null;

    public void addCondition(Condition condition) {
        if (this.isImmuneToCondition(condition)) {
            return;
        }
        if (this.conditions == null) {
            this.conditions = new Conditions();
        }
        boolean bl = false;
        for (Condition condition2 : this.conditions) {
            if (!condition2.equals(condition)) continue;
            condition2.timeLeftSeconds = condition2.durationStacks() ? (condition2.timeLeftSeconds += condition.timeLeftSeconds) : Math.max(condition2.timeLeftSeconds, condition.timeLeftSeconds);
            bl = true;
        }
        if (!bl) {
            this.conditions.add(new Condition(condition));
        }
    }

    public void addImmunity(ConditionImmunity conditionImmunity) {
        if (this.modifiers == null) {
            this.modifiers = new Modifiers();
        }
        if (this.modifiers.modImmunities == null) {
            this.modifiers.modImmunities = new ConditionImmunities();
        }
        this.modifiers.modImmunities.add(conditionImmunity);
    }

    public boolean canUseAbilities() {
        if (this.isDead()) {
            return false;
        }
        if (this.conditions != null) {
            for (Condition condition : this.conditions) {
                if (!condition.cannotUseAbilities()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean canAdd(CombatAction combatAction) {
        if (this.combatActions.size() >= this.maxCombatActions) {
            return false;
        }
        return !this.combatActions.contains(combatAction);
    }

    public int calcAbilityScore(Ability ability) {
        int n = 0;
        if (this.conditions != null) {
            n += this.conditions.getAbilityScore(ability);
        }
        if (this.equipment != null) {
            n += this.equipment.getAbilityScore(ability);
        }
        if (this.modifiers != null) {
            n += this.modifiers.getAbilityScore(ability);
        }
        if (this.mods != null) {
            n += this.mods.getAbilityScore(ability);
        }
        if (this.traits != null) {
            n += this.traits.getAbilityScore(ability);
        }
        return n;
    }

    public int calcAttributeScore(Attribute attribute) {
        int n = 0;
        if (this.conditions != null) {
            n += this.conditions.getAttributeScore(attribute);
        }
        if (this.equipment != null) {
            n += this.equipment.getAttributeScore(attribute);
        }
        if (this.modifiers != null) {
            n += this.modifiers.getAttributeScore(attribute);
        }
        if (this.mods != null) {
            n += this.mods.getAttributeScore(attribute);
        }
        if (this.traits != null) {
            n += this.traits.getAttributeScore(attribute);
        }
        return n;
    }

    public float calcCritChance() {
        float f = 0.0f;
        if (this.conditions != null) {
            f += this.conditions.getCritChance();
        }
        if (this.equipment != null) {
            f += this.equipment.getCritChance();
        }
        if (this.modifiers != null) {
            f += this.modifiers.modCritChance;
        }
        if (this.mods != null) {
            f += this.mods.getCritChance();
        }
        if (this.traits != null) {
            f += this.traits.getCritChance();
        }
        return f;
    }

    public float calcCritMultiplier() {
        float f = 0.0f;
        if (this.conditions != null) {
            f += this.conditions.getCritMultiplier();
        }
        if (this.equipment != null) {
            f += this.equipment.getCritMultiplier();
        }
        if (this.modifiers != null) {
            f += this.modifiers.modCritMultiplier;
        }
        if (this.mods != null) {
            f += this.mods.getCritMultiplier();
        }
        if (this.traits != null) {
            f += this.traits.getCritMultiplier();
        }
        return f;
    }

    public int calcDamageAttack(Damage damage) {
        int n = 0;
        if (this.conditions != null) {
            n += this.conditions.getDamageAttack(damage);
        }
        if (this.equipment != null) {
            n += this.equipment.getDamageAttack(damage);
        }
        if (this.modifiers != null) {
            n += this.modifiers.getDamageAttack(damage);
        }
        if (this.mods != null) {
            n += this.mods.getDamageAttack(damage);
        }
        if (this.traits != null) {
            n += this.traits.getDamageAttack(damage);
        }
        return n;
    }

    public float calcDamageMultiplier(Damage damage) {
        float f = 0.0f;
        if (this.conditions != null) {
            f += this.conditions.getDamageMultiplier(damage);
        }
        if (this.equipment != null) {
            f += this.equipment.getDamageMultiplier(damage);
        }
        if (this.modifiers != null) {
            f += this.modifiers.getDamageMultiplier(damage);
        }
        if (this.mods != null) {
            f += this.mods.getDamageMultiplier(damage);
        }
        if (this.traits != null) {
            f += this.traits.getDamageMultiplier(damage);
        }
        return f;
    }

    public int calcDamageReduction(Damage damage) {
        int n = 0;
        if (this.conditions != null) {
            n += this.conditions.getDamageReduction(damage);
        }
        if (this.equipment != null) {
            n += this.equipment.getDamageReduction(damage);
        }
        if (this.modifiers != null) {
            n += this.modifiers.getDamageReduction(damage);
        }
        if (this.mods != null) {
            n += this.mods.getDamageReduction(damage);
        }
        if (this.traits != null) {
            n += this.traits.getDamageReduction(damage);
        }
        return n;
    }

    public float calcDamageResistance(Damage damage) {
        float f = 0.0f;
        if (this.conditions != null) {
            f += this.conditions.getDamageResistance(damage);
        }
        if (this.equipment != null) {
            f += this.equipment.getDamageResistance(damage);
        }
        if (this.modifiers != null) {
            f += this.modifiers.getDamageResistance(damage);
        }
        if (this.mods != null) {
            f += this.mods.getDamageResistance(damage);
        }
        if (this.traits != null) {
            f += this.traits.getDamageResistance(damage);
        }
        return f;
    }

    public float calcHitChanceAttacker() {
        float f = 0.0f;
        if (this.conditions != null) {
            f += this.conditions.getHitChanceAttacker();
        }
        if (this.equipment != null) {
            f += this.equipment.getHitChanceAttacker();
        }
        if (this.modifiers != null) {
            f += this.modifiers.modHitChanceAttacker;
        }
        if (this.mods != null) {
            f += this.mods.getHitChanceAttacker();
        }
        if (this.traits != null) {
            f += this.traits.getHitChanceAttacker();
        }
        return f;
    }

    public float calcHitChanceDefender() {
        float f = 0.0f;
        if (this.conditions != null) {
            f += this.conditions.getHitChanceDefender();
        }
        if (this.equipment != null) {
            f += this.equipment.getHitChanceDefender();
        }
        if (this.modifiers != null) {
            f += this.modifiers.modHitChanceDefender;
        }
        if (this.mods != null) {
            f += this.mods.getHitChanceDefender();
        }
        if (this.traits != null) {
            f += this.traits.getHitChanceDefender();
        }
        return f;
    }

    public int calcMaxActionPoints() {
        int n = this.maxActionPoints;
        if (this.conditions != null) {
            n += this.conditions.getMaxActionPoints();
        }
        if (this.equipment != null) {
            n += this.equipment.getMaxActionPoints();
        }
        if (this.modifiers != null) {
            n += this.modifiers.modMaxActionPoints;
        }
        if (this.mods != null) {
            n += this.mods.getMaxActionPoints();
        }
        if (this.traits != null) {
            n += this.traits.getMaxActionPoints();
        }
        return n;
    }

    public int calcMaxHitPoints() {
        int n = this.maxHitPoints;
        if (this.conditions != null) {
            n += this.conditions.getMaxHitPoints();
        }
        if (this.equipment != null) {
            n += this.equipment.getMaxHitPoints();
        }
        if (this.modifiers != null) {
            n += this.modifiers.modMaxHitPoints;
        }
        if (this.mods != null) {
            n += this.mods.getMaxHitPoints();
        }
        if (this.traits != null) {
            n += this.traits.getMaxHitPoints();
        }
        return n;
    }

    public float calcRunAwayChance() {
        float f = 0.0f;
        if (this.conditions != null) {
            f += this.conditions.getRunAwayChance();
        }
        if (this.equipment != null) {
            f += this.equipment.getRunAwayChance();
        }
        if (this.modifiers != null) {
            f += this.modifiers.modRunAwayChance;
        }
        if (this.mods != null) {
            f += this.mods.getRunAwayChance();
        }
        if (this.traits != null) {
            f += this.traits.getRunAwayChance();
        }
        return f;
    }

    public int calcVim() {
        int n = this.vim;
        if (this.conditions != null) {
            n += this.conditions.getVim();
        }
        if (this.equipment != null) {
            n += this.equipment.getVim();
        }
        if (this.modifiers != null) {
            n += this.modifiers.modVim;
        }
        if (this.mods != null) {
            n += this.mods.getVim();
        }
        if (this.traits != null) {
            n += this.traits.getVim();
        }
        return n;
    }

    public float calcVimRatio() {
        long l = RPG.getInstance().timeSeconds;
        int n = (int)((l - this.timeStarted) / 60L / 60L / 24L);
        int n2 = n + this.numCombats / 4 + this.numRevives * 4;
        float f = (float)n2 / (float)this.calcVim();
        return 1.0f - Util.clamp(f, 0.0f, 1.0f);
    }

    public boolean canMove() {
        if (this.isDead()) {
            return false;
        }
        if (this.conditions != null) {
            for (Condition condition : this.conditions) {
                if (!condition.cannotMove()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean canRestoreAP() {
        if (this.isDead() || this.isRetired()) {
            return false;
        }
        if (this.conditions != null) {
            for (Condition condition : this.conditions) {
                if (!condition.cannotRestoreAP()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean canRestoreHP() {
        if (this.isDead()) {
            return false;
        }
        if (this.conditions != null) {
            for (Condition condition : this.conditions) {
                if (!condition.cannotRestoreHP()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean canRest() {
        if (this.isDead()) {
            return false;
        }
        if (this.modifiers != null && this.modifiers.cannotRest) {
            return false;
        }
        return this.traits == null || !this.traits.cannotRest();
    }

    public boolean canRevive() {
        return this.isDead() && !this.isRetired();
    }

    public ConditionImmunities collectImmunities() {
        ConditionImmunities conditionImmunities = new ConditionImmunities();
        if (this.conditions != null) {
            for (Object object : this.conditions) {
                if (((Condition)object).getImmunities() == null) continue;
                for (ConditionImmunity conditionImmunity : ((Condition)object).getImmunities()) {
                    conditionImmunities.add(conditionImmunity);
                }
            }
        }
        if (this.equipment != null && this.equipment.getImmunities() != null) {
            for (Object object : this.equipment.getImmunities()) {
                conditionImmunities.add(object);
            }
        }
        if (this.modifiers != null && this.modifiers.modImmunities != null) {
            conditionImmunities.addAll(this.modifiers.modImmunities);
        }
        if (this.mods != null) {
            // empty if block
        }
        if (this.traits != null) {
            for (Object object : this.traits) {
                if (((Trait)object).getImmunities() == null) continue;
                for (ConditionImmunity conditionImmunity : ((Trait)object).getImmunities()) {
                    conditionImmunities.add(conditionImmunity);
                }
            }
        }
        return conditionImmunities;
    }

    public int getAbilityScore(Ability ability) {
        return this.modifiers != null ? this.modifiers.getAbilityScore(ability) : 0;
    }

    public int getAttributeScore(Attribute attribute) {
        return this.modifiers != null ? this.modifiers.getAttributeScore(attribute) : 0;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public int getDamageReduction(Damage damage) {
        return this.modifiers != null ? this.modifiers.getDamageReduction(damage) : 0;
    }

    public float getDamageResistance(Damage damage) {
        return this.modifiers != null ? this.modifiers.getDamageResistance(damage) : 0.0f;
    }

    private boolean hasAbilities() {
        for (Ability ability : Ability.values()) {
            if (this.calcAbilityScore(ability) <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasAbilities(Abilities abilities) {
        if (abilities == null) {
            return true;
        }
        for (Map.Entry<Ability, Integer> entry : abilities.entrySet()) {
            Ability ability = entry.getKey();
            int n = entry.getValue();
            if (this.calcAbilityScore(ability) < n) continue;
            return true;
        }
        return false;
    }

    public boolean hasCombatAction(CombatAction combatAction) {
        for (CombatAction combatAction2 : this.combatActions) {
            if (!combatAction2.equals(combatAction)) continue;
            return true;
        }
        return false;
    }

    public boolean hasCondition(Condition condition) {
        if (this.conditions != null) {
            for (Condition condition2 : this.conditions) {
                if (!condition2.equals(condition)) continue;
                assert (condition2.timeLeftSeconds > 0L);
                return true;
            }
        }
        return false;
    }

    public boolean hasCondition(String string) {
        if (this.conditions != null) {
            for (Condition condition : this.conditions) {
                if (!condition.getId().equals(string)) continue;
                assert (condition.timeLeftSeconds > 0L);
                return true;
            }
        }
        return false;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    private boolean hasDamageReductions() {
        if (this.conditions != null) {
            for (Object object : this.conditions) {
                if (!((Condition)object).hasDamageReductions()) continue;
                return true;
            }
        }
        if (this.equipment != null && this.equipment.hasDamageReductions()) {
            return true;
        }
        if (this.modifiers != null && this.modifiers.hasDamageReductions()) {
            return true;
        }
        if (this.traits != null) {
            for (Object object : this.traits) {
                if (!((Trait)object).hasDamageReductions()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasDamageResistances() {
        if (this.conditions != null) {
            for (Object object : this.conditions) {
                if (!((Condition)object).hasDamageResistances()) continue;
                return true;
            }
        }
        if (this.equipment != null && this.equipment.hasDamageResistances()) {
            return true;
        }
        if (this.modifiers != null && this.modifiers.modDamageResistances != null && !this.modifiers.modDamageResistances.isEmpty()) {
            return true;
        }
        if (this.traits != null) {
            for (Object object : this.traits) {
                if (!((Trait)object).hasDamageResistances()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasImmunities() {
        return this.collectImmunities().size() > 0;
    }

    public boolean hasTrait(Trait trait) {
        return this.traits != null && this.traits.contains(trait);
    }

    public boolean hasTraits() {
        return this.traits != null && !this.traits.isEmpty();
    }

    public boolean isAlive() {
        return !this.isDead();
    }

    public boolean isDead() {
        return this.hitPoints <= 0;
    }

    public boolean isImmuneToCondition(Condition condition) {
        if (this.conditions != null && this.conditions.getImmuneToCondition(condition)) {
            return true;
        }
        if (this.equipment != null && this.equipment.getImmuneToCondition(condition)) {
            return true;
        }
        if (this.modifiers != null && this.modifiers.getImmuneToCondition(condition)) {
            return true;
        }
        return this.traits != null && this.traits.getImmuneToCondition(condition);
    }

    public boolean isImmuneToCrits() {
        if (this.conditions != null && this.conditions.getImmuneToCrits()) {
            return true;
        }
        if (this.equipment != null && this.equipment.getImmuneToCrits()) {
            return true;
        }
        if (this.modifiers != null && this.modifiers.modImmuneToCrits) {
            return true;
        }
        return this.traits != null && this.traits.getImmuneToCrits();
    }

    public boolean isRetired() {
        return this.calcVimRatio() == 0.0f;
    }

    public void removeAll(List<Condition> list) {
        if (this.conditions != null) {
            for (Condition condition : list) {
                this.conditions.removeIf(condition2 -> condition2.equals(condition));
            }
        }
    }

    public void removeCondition(Condition condition) {
        if (this.conditions != null) {
            this.conditions.removeIf(condition2 -> condition2.equals(condition));
        }
    }

    public void removeCondition(String string) {
        if (this.conditions != null) {
            this.conditions.removeIf(condition -> condition.getId().equals(string));
        }
    }

    public void removeConditions() {
        if (this.conditions != null) {
            this.conditions.clear();
        }
    }

    public List<Condition> removeConditionsIf(Predicate<Condition> predicate) {
        ArrayList<Condition> arrayList = new ArrayList<Condition>();
        if (this.conditions != null) {
            for (Condition condition : this.conditions) {
                if (!predicate.test(condition)) continue;
                arrayList.add(condition);
            }
            this.conditions.removeAll(arrayList);
        }
        return arrayList;
    }

    public void setAbilityScore(Ability ability, int n) {
        if (this.modifiers == null) {
            this.modifiers = new Modifiers();
        }
        if (this.modifiers.modAbilities == null) {
            this.modifiers.modAbilities = new Abilities();
        }
        this.modifiers.modAbilities.put(ability, n);
    }

    public Slot[] getSlots() {
        return this.mods != null ? this.mods.values() : null;
    }

    public boolean setMod(int n, SlotItem.Data data) {
        return this.mods.set(n, data);
    }

    public void setTrait(Trait trait) {
        if (this.traits == null) {
            this.traits = new Traits();
        }
        this.traits.add(trait);
    }

    public void setTraits(Traits traits) {
        this.traits = traits;
    }

    public void tickConditions(long l) {
        if (this.conditions == null) {
            return;
        }
        for (Condition condition : this.conditions) {
            if (condition.timeLeftSeconds <= 0L) continue;
            condition.timeLeftSeconds = Math.max(condition.timeLeftSeconds - l, 0L);
        }
    }
}

