/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.modder;

import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.StaticRPG;
import de.slashbinbash.hexen.model.ClassCreature;
import de.slashbinbash.hexen.model.Inventory;
import de.slashbinbash.hexen.model.SlotItem;

public class StaticModder {
    public static final float COST_SCALE = 1.0f;

    public static int getCost(SlotItem.Data data) {
        return (int)((float)data.value * 1.0f);
    }

    public static boolean canBuyMod(SlotItem.Data data, Inventory inventory) {
        return (float)inventory.getCurrency() >= (float)data.value * 1.0f;
    }

    public static boolean canSetMod(SlotItem.Data data, ClassCreature classCreature, int n) {
        if (!classCreature.mods.canSet(n, data)) {
            return false;
        }
        return data.requirements == null || data.requirements.checkAll(classCreature);
    }

    public static StaticRPG.Result applyMod(SlotItem.Data data, ClassCreature classCreature, int n) {
        Inventory inventory = RPG.getInstance().party.inventory;
        if (!StaticModder.canBuyMod(data, inventory)) {
            return StaticRPG.Result.NOT_ENOUGH_CURRENCY;
        }
        if (!StaticModder.canSetMod(data, classCreature, n)) {
            return StaticRPG.Result.REQUIREMENT_CHECK_FAILED;
        }
        int n2 = StaticModder.getCost(data);
        inventory.removeCurrency(n2);
        boolean bl = classCreature.setMod(n, data);
        assert (bl);
        return StaticRPG.Result.OK;
    }

    public static StaticRPG.Result removeMod(ClassCreature classCreature, int n) {
        boolean bl = classCreature.setMod(n, null);
        return bl ? StaticRPG.Result.SUCCESS : StaticRPG.Result.FAILURE;
    }
}

