/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.message;

import de.slashbinbash.hexen.message.ISubscriber;
import de.slashbinbash.hexen.message.Message;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

public class MessageBus {
    private static List<ISubscriber> subscribers = new ArrayList<ISubscriber>();
    private static ArrayDeque<Entry> deque = new ArrayDeque();

    public static void send(Message message, Object object) {
        ArrayList<ISubscriber> arrayList = new ArrayList<ISubscriber>(subscribers);
        for (ISubscriber iSubscriber : arrayList) {
            iSubscriber.notify(message, object);
        }
    }

    public static void sendAll() {
        if (deque.isEmpty()) {
            return;
        }
        ArrayList<ISubscriber> arrayList = new ArrayList<ISubscriber>(subscribers);
        while (!deque.isEmpty()) {
            Entry entry = deque.poll();
            for (ISubscriber iSubscriber : arrayList) {
                iSubscriber.notify(entry.type, entry.object);
            }
        }
    }

    public static void push(Message message, Object object) {
        deque.add(new Entry(message, object));
    }

    public static void subscribe(ISubscriber iSubscriber) {
        if (!subscribers.contains(iSubscriber)) {
            subscribers.add(iSubscriber);
        }
    }

    public static void unsubscribe(ISubscriber iSubscriber) {
        subscribers.remove(iSubscriber);
    }

    public static void clear() {
        subscribers.clear();
    }

    private static class Entry {
        public Message type;
        public Object object;

        public Entry(Message message, Object object) {
            this.type = message;
            this.object = object;
        }
    }
}

