/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.map;

import de.slashbinbash.hexen.enums.Direction;
import de.slashbinbash.hexen.map.MapObject;
import de.slashbinbash.hexen.map.TileEdge;
import de.slashbinbash.hexen.map.TileObject;
import java.util.ArrayList;
import java.util.List;

public class Tile
extends MapObject {
    public static final int EMPTY = 0;
    public static final int FLOOR = 1;
    public static final int DARKNESS = 2;
    public String description = null;
    public int type = 0;
    public int texFloor = 0;
    public int texRoom = 0;
    public TileEdge edgeEast = null;
    public TileEdge edgeNorth = null;
    public TileEdge edgeSouth = null;
    public TileEdge edgeWest = null;
    public List<TileObject> objects = new ArrayList<TileObject>();

    public Tile() {
        super(null);
    }

    public boolean isBlocked(Direction direction) {
        switch (direction) {
            case NORTH: {
                return this.edgeNorth != null && this.edgeNorth.isBlocked(direction);
            }
            case EAST: {
                return this.edgeEast != null && this.edgeEast.isBlocked(direction);
            }
            case SOUTH: {
                return this.edgeSouth != null && this.edgeSouth.isBlocked(direction);
            }
            case WEST: {
                return this.edgeWest != null && this.edgeWest.isBlocked(direction);
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.objects.isEmpty();
    }

    public boolean isSolid() {
        return this.type == 0;
    }

    public TileEdge getEdge(Direction direction) {
        switch (direction) {
            case NORTH: {
                return this.edgeNorth;
            }
            case EAST: {
                return this.edgeEast;
            }
            case SOUTH: {
                return this.edgeSouth;
            }
            case WEST: {
                return this.edgeWest;
            }
        }
        return null;
    }
}

