/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.map;

import de.slashbinbash.hexen.lua.CreatureBinding;
import de.slashbinbash.hexen.lua.InventoryBinding;
import de.slashbinbash.hexen.lua.ItemBinding;
import de.slashbinbash.hexen.lua.MapBinding;
import de.slashbinbash.hexen.lua.PartyBinding;
import de.slashbinbash.hexen.lua.QuestBinding;
import de.slashbinbash.hexen.lua.StateBinding;
import de.slashbinbash.hexen.lua.UtilBinding;
import de.slashbinbash.hexen.map.Map;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.jse.JsePlatform;

public class LuaMap {
    private Globals globals = JsePlatform.standardGlobals();

    public LuaMap(Map map) {
        CreatureBinding.setup(this.globals);
        InventoryBinding.setup(this.globals);
        ItemBinding.setup(this.globals);
        PartyBinding.setup(this.globals);
        QuestBinding.setup(this.globals);
        StateBinding.setup(this.globals);
        MapBinding.setup(this.globals);
        UtilBinding.setup(this.globals);
    }

    public Globals getGlobals() {
        return this.globals;
    }

    public void load(String string) {
        try {
            LuaValue luaValue = this.globals.load(string);
            luaValue.call();
        }
        catch (LuaError luaError) {
            this.onError(luaError);
        }
    }

    public void loadFile(String string) {
        try {
            LuaValue luaValue = this.globals.loadfile(string);
            luaValue.call();
        }
        catch (LuaError luaError) {
            this.onError(luaError);
        }
    }

    private void onError(LuaError luaError) {
        System.err.println(luaError.getMessage());
        this.globals = null;
    }

    public int onMove(int n, int n2, int n3) {
        if (this.globals == null) {
            return -1;
        }
        LuaInteger luaInteger = LuaValue.valueOf(n);
        LuaInteger luaInteger2 = LuaValue.valueOf(n2);
        LuaInteger luaInteger3 = LuaValue.valueOf(n3);
        LuaValue[] luaValueArray = new LuaValue[]{luaInteger, luaInteger2, luaInteger3};
        LuaValue luaValue = this.globals.get("on_move");
        assert (luaValue != LuaValue.NIL);
        try {
            Varargs varargs = luaValue.invoke(luaValueArray);
            return varargs.toint(0);
        }
        catch (LuaError luaError) {
            this.onError(luaError);
            return 0;
        }
    }
}

