/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.lua;

import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.enums.Direction;
import de.slashbinbash.hexen.map.MapObject;
import de.slashbinbash.hexen.map.Tile;
import de.slashbinbash.hexen.map.TileEdge;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;

public class MapBinding {
    private static Tile getCurrentTile() {
        return RPG.getInstance().party.getLocation().getTile();
    }

    public static void setup(LuaTable luaTable) {
        luaTable.set("MapGetCurrentTile", (LuaValue)new GetCurrentTile());
        luaTable.set("MapGetTile", (LuaValue)new GetTile());
        luaTable.set("MapGetEdge", (LuaValue)new GetEdge());
        luaTable.set("MapSetEdge", (LuaValue)new SetEdge());
        luaTable.set("MapRemoveObject", (LuaValue)new RemoveObject());
        LuaTable luaTable2 = new LuaTable();
        luaTable2.set("NONE", 0);
        luaTable2.set("DOOR", 2);
        luaTable2.set("DOOR_LOCKED", 3);
        LuaTable luaTable3 = new LuaTable();
        luaTable3.set("edge", (LuaValue)luaTable2);
        luaTable.set("map", (LuaValue)luaTable3);
    }

    public static class GetCurrentTile
    extends ZeroArgFunction {
        @Override
        public LuaValue call() {
            Tile tile = RPG.getInstance().party.getLocation().getTile();
            return LuaValue.userdataOf(tile);
        }
    }

    public static class GetTile
    extends ThreeArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue, LuaValue luaValue2, LuaValue luaValue3) {
            int n = luaValue.toint();
            int n2 = luaValue2.toint();
            int n3 = luaValue3.toint();
            Tile tile = RPG.getInstance().map.levels.get(n).getTile(n2, n3);
            return LuaValue.userdataOf(tile);
        }
    }

    public static class GetEdge
    extends TwoArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            Tile tile = (Tile)luaValue.touserdata();
            Direction direction = Direction.valueOf(luaValue2.tojstring());
            TileEdge tileEdge = tile.getEdge(direction);
            return LuaValue.userdataOf(tileEdge);
        }
    }

    public static class SetEdge
    extends TwoArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            MapObject mapObject = (MapObject)luaValue.touserdata();
            int n = luaValue2.toint();
            while (!(mapObject instanceof TileEdge)) {
                mapObject = mapObject.parent;
            }
            TileEdge tileEdge = (TileEdge)mapObject;
            tileEdge.setType(n);
            return null;
        }
    }

    public static class RemoveObject
    extends OneArgFunction {
        @Override
        public LuaValue call(LuaValue luaValue) {
            String string = luaValue.tojstring();
            Tile tile = MapBinding.getCurrentTile();
            tile.objects.removeIf(tileObject -> tileObject.id.equals(string));
            return LuaValue.TRUE;
        }
    }
}

