/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.Documentation;
import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.handler.HandlerBase;
import de.slashbinbash.hexen.model.Inventory;
import de.slashbinbash.hexen.model.Item;
import de.slashbinbash.hexen.model.Recipe;
import de.slashbinbash.hexen.ui.Button;
import de.slashbinbash.hexen.view.StaticView;
import de.slashbinbash.hexen.workbench.Craft;
import de.slashbinbash.hexen.workbench.StaticWorkbench;
import de.slashbinbash.hexen.workbench.Workbench;
import de.slashbinbash.hexen.workbench.WorkbenchFactory;
import java.util.List;

public class WorkbenchHandler
extends HandlerBase {
    private static final int STATE_CRAFT = 0;
    private static final int STATE_BUILD = 1;
    private static final int STATE_DISASSEMBLE = 2;
    private static final int SHOW_MESSAGE = 3;
    private Workbench workbench = null;

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
        if (this.state == 3) {
            super.popState();
            return;
        }
        switch (commandEvent) {
            case CONFIRM: {
                Recipe recipe;
                if (this.state == 0) {
                    Action action = (Action)((Object)super.getSelectedButton().data);
                    switch (action.ordinal()) {
                        case 0: {
                            super.pushState(1);
                            break;
                        }
                        case 1: {
                            super.pushState(2);
                        }
                    }
                    break;
                }
                if (this.state == 1) {
                    Recipe recipe2;
                    if (this.buttons.size() <= 0 || (recipe2 = (Recipe)super.getSelectedButton().data) == null) break;
                    StaticWorkbench.craft(recipe2, this.workbench._data.assemble.durationRatio);
                    break;
                }
                if (this.state != 2 || this.buttons.size() <= 0 || (recipe = (Recipe)super.getSelectedButton().data) == null) break;
                StaticWorkbench.craft(recipe, this.workbench._data.disassemble.durationRatio);
                break;
            }
            case CANCEL: {
                this.popState();
                break;
            }
            case SHOW_DOCUMENTATION: {
                if (this.state != 1 && this.state != 2) break;
                Recipe recipe = (Recipe)((Button)this.buttons.get((int)this.buttonIndex)).data;
                Documentation.showItem(recipe.__id__);
                break;
            }
        }
    }

    public void init(Workbench workbench) {
        this.state = 0;
        this.workbench = workbench;
        super.init();
    }

    @Override
    public void updateButtons() {
        List<Recipe> list = this.workbench._data.assemble.recipes;
        List<Recipe> list2 = this.workbench._data.disassemble.recipes;
        switch (this.state) {
            case 0: {
                if (list != null) {
                    super.addButton("Build", (Object)Action.Build);
                }
                if (list2 == null) break;
                super.addButton("Disassemble", (Object)Action.Disassemble);
                break;
            }
            case 1: {
                if (list == null) break;
                for (Recipe recipe : list) {
                    super.addButton(recipe.name, recipe);
                }
                break;
            }
            case 2: {
                if (list2 != null && !list2.isEmpty()) {
                    for (Recipe recipe : list2) {
                        super.addButton(recipe.name, recipe);
                    }
                } else {
                    Inventory inventory = RPG.getInstance().party.inventory;
                    for (Item item : inventory) {
                        if (!item._data.craftable) continue;
                        Craft.Data data = WorkbenchFactory.createCraftData(item.getId());
                        if (data.disassemble == null) continue;
                        super.addButton(item.getName(), data.disassemble);
                    }
                }
                break;
            }
            case 3: {
                break;
            }
        }
    }

    @Override
    public void updateLeftText() {
        switch (this.state) {
            case 1: {
                if (!this.buttons.isEmpty()) break;
                this.leftText = "No recipies.";
                break;
            }
            case 2: {
                if (!this.buttons.isEmpty()) break;
                this.leftText = "No recipies.";
                break;
            }
            default: {
                this.leftText = null;
            }
        }
    }

    @Override
    public void updateRightText() {
        this.rightText = null;
        switch (this.state) {
            case 0: {
                if (this.workbench._data.description == null) break;
                this.rightText = this.workbench._data.description;
                break;
            }
            case 1: {
                if (this.buttons.isEmpty()) break;
                Recipe recipe = (Recipe)super.getSelectedButton().data;
                if (recipe != null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    StaticView.printRecipe(stringBuilder, recipe, this.workbench._data.assemble.durationRatio);
                    this.rightText = stringBuilder.toString();
                    break;
                }
                this.rightText = "No recipe";
                break;
            }
            case 2: {
                if (this.buttons.isEmpty()) break;
                Recipe recipe = (Recipe)super.getSelectedButton().data;
                if (recipe != null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    StaticView.printRecipe(stringBuilder, recipe, this.workbench._data.disassemble.durationRatio);
                    this.rightText = stringBuilder.toString();
                    break;
                }
                this.rightText = "No recipe";
                break;
            }
        }
    }

    @Override
    public void updateScene() {
        if (this.workbench._data.scene != null) {
            super.setScene(this.workbench._data.scene);
        } else {
            this.scene.portrait = "workbench";
            this.scene.portraitTitle = "Workbench";
            super.setScene(this.scene);
        }
    }

    private static enum Action {
        Build,
        Disassemble;

    }
}

