/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.Documentation;
import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.handler.HandlerBase;
import de.slashbinbash.hexen.model.Inventory;
import de.slashbinbash.hexen.model.ItemGroup;
import de.slashbinbash.hexen.shop.StaticTrade;
import de.slashbinbash.hexen.shop.Trade;
import java.util.List;

public class TradeHandler
extends HandlerBase {
    private static final int PICK_ITEM = 0;
    private static final int SHOW_MESSAGE = 1;
    private Trade trade = null;

    public TradeHandler(HandlerBase handlerBase) {
        super.setScene(handlerBase.scene);
    }

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
        switch (this.state) {
            case 0: {
                this.handlePickItem(commandEvent, object);
                break;
            }
            case 1: {
                break;
            }
        }
    }

    private void handlePickItem(CommandEvent commandEvent, Object object) {
        if (this.buttons.isEmpty()) {
            return;
        }
        switch (commandEvent) {
            case CONFIRM: {
                Trade.Data.Entry entry = (Trade.Data.Entry)this.getSelectedButton().data;
                StaticTrade.trade(entry);
                break;
            }
            case CANCEL: {
                this.popState();
                break;
            }
            case SHOW_DOCUMENTATION: {
                Trade.Data.Entry entry = (Trade.Data.Entry)this.getSelectedButton().data;
                ItemGroup itemGroup = entry.output.get(0);
                Documentation.showItem(itemGroup.getId());
                break;
            }
        }
    }

    public void init(Trade trade) {
        this.trade = trade;
        super.init();
    }

    @Override
    public void updateButtons() {
        if (this.state == 0) {
            List<Trade.Data.Entry> list = this.trade._data.entries;
            if (list == null) {
                return;
            }
            RPG rPG = RPG.getInstance();
            for (Trade.Data.Entry entry : list) {
                ItemGroup itemGroup = entry.output.get(0);
                int n = rPG.party.inventory.count(itemGroup.getId());
                String string = String.format("%-21s %4d", itemGroup.getName(), n);
                super.addButton(string, entry);
            }
        }
    }

    @Override
    public void updateRightText() {
        if (this.state == 0) {
            if (this.trade._data.entries.isEmpty()) {
                this.rightText = "No items.";
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                Inventory inventory = RPG.getInstance().party.inventory;
                Trade.Data.Entry entry = (Trade.Data.Entry)super.getSelectedButton().data;
                stringBuilder.setLength(0);
                stringBuilder.append(entry.output.get(0).getDescription());
                stringBuilder.append("\n");
                stringBuilder.append("\nINPUT");
                for (ItemGroup itemGroup : entry.input) {
                    int n = inventory.count(itemGroup.getId());
                    stringBuilder.append("\n");
                    stringBuilder.append(itemGroup.getName());
                    stringBuilder.append(" (");
                    stringBuilder.append(n);
                    stringBuilder.append("/");
                    stringBuilder.append(itemGroup.size);
                    stringBuilder.append(")");
                }
                stringBuilder.append("\n\nOUTPUT");
                for (ItemGroup itemGroup : entry.output) {
                    stringBuilder.append("\n");
                    stringBuilder.append(itemGroup.getName());
                    stringBuilder.append(" ");
                    stringBuilder.append(itemGroup.size);
                }
                this.rightText = stringBuilder.toString();
            }
        } else {
            this.rightText = null;
        }
    }

    @Override
    public void updateScene() {
        if (this.trade._data.scene != null) {
            super.setScene(this.trade._data.scene);
        }
    }
}

