/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.Util;
import de.slashbinbash.hexen.factory.ItemFactory;
import de.slashbinbash.hexen.handler.HandlerBase;
import de.slashbinbash.hexen.model.Inventory;
import de.slashbinbash.hexen.model.Item;
import de.slashbinbash.hexen.model.Party;
import de.slashbinbash.hexen.shop.Sell;
import de.slashbinbash.hexen.shop.StaticShop;
import de.slashbinbash.hexen.ui.Button;
import de.slashbinbash.hexen.view.StaticView;
import java.util.ArrayList;
import java.util.List;

public class SellHandler
extends HandlerBase {
    private static final int PICK_ITEM = 0;
    private static final int CANT_SELL_ITEM = 1;
    private static final int PICK_AMOUNT = 2;
    private Sell sell = null;
    private Entry selectedItem = null;
    private boolean sellInventory = false;
    private List<Entry> entries = new ArrayList<Entry>();

    public SellHandler(HandlerBase handlerBase) {
        super.setScene(handlerBase.scene);
    }

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
        switch (this.state) {
            case 0: {
                this.handleSellItem(commandEvent, object);
                break;
            }
            case 2: {
                this.handlePickAmount(commandEvent, object);
                break;
            }
            case 1: {
                super.popState();
                break;
            }
        }
    }

    private void handlePickAmount(CommandEvent commandEvent, Object object) {
        switch (commandEvent) {
            case CONFIRM: {
                String string = super.getInput();
                if (string.isEmpty()) break;
                if (this.sellInventory) {
                    int n = this.selectedItem.item.count;
                    int n2 = Util.clamp(Integer.valueOf(string), 0, n);
                    StaticShop.sellItem(this.selectedItem.item, n2, this.sell._data.currency, this.selectedItem.price);
                } else {
                    String string2 = this.selectedItem.item.getId();
                    int n = RPG.getInstance().party.inventory.count(string2);
                    int n3 = Util.clamp(Integer.valueOf(string), 0, n);
                    StaticShop.sellItem(string2, n3, this.sell._data.currency, this.selectedItem.price);
                }
                super.popState();
                super.setMode(HandlerBase.Mode.Default);
                break;
            }
            case CANCEL: {
                super.popState();
                super.setMode(HandlerBase.Mode.Default);
                break;
            }
        }
    }

    private void handleSellItem(CommandEvent commandEvent, Object object) {
        switch (commandEvent) {
            case CONFIRM: {
                if (this.buttons.isEmpty()) break;
                if (this.sellInventory) {
                    Entry entry = (Entry)super.getSelectedButton().data;
                    Item item = entry.item;
                    if (item.count > 0) {
                        if (item.count > 10) {
                            this.selectedItem = entry;
                            super.pushState(2);
                            super.setMode(HandlerBase.Mode.Input, HandlerBase.InputType.Integer);
                            break;
                        }
                        StaticShop.sellItem(item, 1, this.sell._data.currency, entry.price);
                        break;
                    }
                    super.pushState(1);
                    break;
                }
                Entry entry = (Entry)super.getSelectedButton().data;
                String string = entry.item.getId();
                int n = RPG.getInstance().party.inventory.count(string);
                if (n > 0) {
                    if (n > 10) {
                        this.selectedItem = entry;
                        super.pushState(2);
                        super.setMode(HandlerBase.Mode.Input, HandlerBase.InputType.Integer);
                        break;
                    }
                    StaticShop.sellItem(string, 1, this.sell._data.currency, entry.price);
                    break;
                }
                super.pushState(1);
                break;
            }
            case CANCEL: {
                super.popState();
                break;
            }
        }
    }

    public void init(Sell sell) {
        this.sell = sell;
        this.sellInventory = sell._data.sellList.isEmpty();
        for (String string : sell._data.sellList) {
            Item item = ItemFactory.createItem(string);
            Entry entry = new Entry();
            entry.item = item;
            entry.price = sell._data.getSellPrice(item, 1);
            this.entries.add(entry);
        }
        super.init();
    }

    @Override
    public void updateButtons() {
        block4: {
            Party party = RPG.getInstance().party;
            Inventory inventory = party.inventory;
            if (this.state != 0) break block4;
            if (this.sellInventory) {
                for (Item item : RPG.getInstance().party.inventory) {
                    if (!StaticShop.canSell(this.sell._data, item)) continue;
                    int n = item.count;
                    int n2 = this.sell._data.getSellPrice(item, 1);
                    String string = String.format("%-3d%-21s%4d", n, item.getName(), n2);
                    Entry entry = new Entry();
                    entry.item = item;
                    entry.price = n2;
                    super.addButton(string, entry);
                }
            } else {
                for (Entry entry : this.entries) {
                    int n = inventory.count(entry.item.getId());
                    String string = String.format("%-3d%-21s%4d", n, entry.item.getName(), entry.price);
                    super.addButton(string, entry);
                }
            }
        }
    }

    @Override
    public void updateLeftText() {
        this.leftText = null;
        if (this.state == 0 && this.buttons.isEmpty()) {
            this.leftText = "No items to sell.";
        }
        if (this.state == 2 && this.selectedItem != null) {
            int n = 0;
            n = this.sellInventory ? this.selectedItem.item.count : RPG.getInstance().party.inventory.count(this.selectedItem.item.getId());
            this.leftText = this.selectedItem.item.getName() + " " + n;
        }
        if (this.state == 1) {
            this.leftText = "Cannot sell item.";
        }
    }

    @Override
    public void updateRightText() {
        this.rightText = null;
        if (this.state == 0) {
            Button button;
            StringBuilder stringBuilder = new StringBuilder();
            Inventory inventory = RPG.getInstance().party.inventory;
            int n = inventory.getCurrency();
            if (this.sell._data.currency != null) {
                n = inventory.count(this.sell._data.currency);
                stringBuilder.append("Payment:\n").append(n).append(" ").append(this.sell._data.currency).append("\n\n");
            }
            if ((button = super.getSelectedButton()) != null) {
                Entry entry = (Entry)button.data;
                StaticView.printItem(stringBuilder, entry.item);
            }
            this.rightText = stringBuilder.toString();
        }
    }

    @Override
    public void updateScene() {
        if (this.sell._data.scene != null) {
            super.setScene(this.sell._data.scene);
        }
    }

    private static class Entry {
        public Item item;
        public int price;

        private Entry() {
        }
    }
}

