/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.handler.HandlerBase;
import de.slashbinbash.hexen.model.ClassCreature;
import de.slashbinbash.hexen.ui.Button;
import de.slashbinbash.hexen.view.StaticView;
import java.util.List;

public class RetireHandler
extends HandlerBase {
    private static final int PICK_CREATURE = 0;
    private static final int SHOW_MESSAGE = 1;

    public RetireHandler(HandlerBase handlerBase) {
        super.setScene(handlerBase.scene);
    }

    private ClassCreature getSelectedCreature() {
        if (0 <= this.buttonIndex && this.buttonIndex < this.buttons.size()) {
            return (ClassCreature)((Button)this.buttons.get((int)this.buttonIndex)).data;
        }
        return null;
    }

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
        switch (this.state) {
            case 0: {
                this.handlePickCreature(commandEvent, object);
                break;
            }
            case 1: {
                this.popState();
            }
        }
    }

    private void handlePickCreature(CommandEvent commandEvent, Object object) {
        switch (commandEvent) {
            case CONFIRM: {
                List<ClassCreature> list = RPG.getInstance().party.getMembers();
                if (list.size() == 1) {
                    this.showMessage("Party must have at least one member.");
                    break;
                }
                ClassCreature classCreature = this.getSelectedCreature();
                list.remove(classCreature);
                break;
            }
            case CANCEL: {
                this.popState();
                break;
            }
        }
    }

    private void showMessage(String string) {
        this.leftText = string;
        this.pushState(1);
    }

    @Override
    public void updateButtons() {
        switch (this.state) {
            case 0: {
                List<ClassCreature> list = RPG.getInstance().party.getMembers();
                for (ClassCreature classCreature : list) {
                    String string = String.format("%-21s", classCreature.name);
                    super.addButton(string, classCreature);
                }
                break;
            }
        }
    }

    @Override
    public void updateLeftText() {
        if (this.state != 1) {
            this.leftText = null;
        }
        switch (this.state) {
            case 0: {
                if (this.buttons.isEmpty()) {
                    this.leftText = "No members in party.";
                    break;
                }
                this.leftText = null;
                break;
            }
        }
    }

    @Override
    public void updateRightText() {
        this.rightText = null;
        switch (this.state) {
            case 0: {
                ClassCreature classCreature = this.getSelectedCreature();
                if (classCreature == null) break;
                StringBuilder stringBuilder = new StringBuilder();
                StaticView.printCharacter(stringBuilder, classCreature);
                this.rightText = stringBuilder.toString();
                break;
            }
        }
    }

    @Override
    public void updateScene() {
    }
}

