/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.StaticRPG;
import de.slashbinbash.hexen.handler.HandlerBase;
import de.slashbinbash.hexen.inn.Rest;
import de.slashbinbash.hexen.inn.StaticRest;
import de.slashbinbash.hexen.model.Party;
import de.slashbinbash.hexen.ui.Button;

public class RestHandler
extends HandlerBase {
    private static final int STATE_REST = 0;
    private static final int SHOW_MESSAGE = 1;
    private Rest rest = null;

    public RestHandler(HandlerBase handlerBase) {
        super.setScene(handlerBase.scene);
    }

    private void addButton(int n) {
        int n2 = RPG.getInstance().party.getMembers().size();
        int n3 = StaticRest.calcCost(this.rest._data, n, n2);
        String string = String.format("%2d Hours                %4d", n, n3);
        super.addButton(string, n);
    }

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
        if (this.state == 1) {
            super.popState();
            return;
        }
        switch (commandEvent) {
            case CONFIRM: {
                if (this.state != 0) break;
                Party party = RPG.getInstance().party;
                int n = (Integer)((Button)this.buttons.get((int)this.buttonIndex)).data;
                int n2 = RPG.getInstance().party.getMembers().size();
                int n3 = StaticRest.calcCost(this.rest._data, n, n2);
                if (party.inventory.getCurrency() < n3) {
                    this.showMessage("Not enough currency.", new Object[0]);
                    break;
                }
                party.inventory.removeCurrency(n3);
                StaticRPG.Result result = StaticRest.restHours(n);
                if (result != StaticRPG.Result.OK) break;
                this.showMessage("Party rested for %d hours.", n);
                break;
            }
            case CANCEL: {
                this.popState();
                break;
            }
        }
    }

    public void init(Rest rest) {
        this.rest = rest;
        super.init();
    }

    private void showMessage(String string, Object ... objectArray) {
        this.leftText = String.format(string, objectArray);
        this.pushState(1);
    }

    @Override
    public void updateButtons() {
        switch (this.state) {
            case 0: {
                this.addButton(1);
                this.addButton(2);
                this.addButton(4);
                this.addButton(8);
                this.addButton(12);
                this.addButton(24);
                break;
            }
            case 1: {
                break;
            }
        }
    }

    @Override
    public void updateRightText() {
        this.rightText = null;
        int n = (Integer)super.getSelectedButton().data;
        int n2 = RPG.getInstance().party.getMembers().size();
        int n3 = StaticRest.calcCost(this.rest._data, n, n2);
        this.rightText = String.format("Cost: %d (%d/member)", n3, this.rest._data.cost);
    }

    @Override
    public void updateScene() {
        if (this.rest._data.scene != null) {
            super.setScene(this.rest._data.scene);
        }
    }

    @Override
    public void updateLeftText() {
        if (this.state != 1) {
            this.leftText = null;
        }
    }
}

