/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.handler.HandlerBase;
import de.slashbinbash.hexen.quest.Quest;
import de.slashbinbash.hexen.quest.QuestFactory;
import de.slashbinbash.hexen.quest.QuestState;
import java.util.Map;

public class QuestHandler
extends HandlerBase {
    private Filter filter = Filter.Open;

    private void addButton(Quest quest) {
        String string = quest._data.name;
        super.addButton(string, quest);
    }

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
        switch (commandEvent) {
            case CANCEL: {
                super.popState();
                break;
            }
            case TAB_RIGHT: {
                switch (this.filter.ordinal()) {
                    case 0: {
                        this.filter = Filter.Closed;
                        break;
                    }
                    case 1: {
                        this.filter = Filter.Open;
                    }
                }
                break;
            }
        }
    }

    @Override
    public void init() {
        super.init();
    }

    private QuestState getState(Filter filter) {
        switch (filter.ordinal()) {
            case 0: {
                return QuestState.OPEN;
            }
            case 1: {
                return QuestState.CLOSED;
            }
        }
        return null;
    }

    @Override
    public void updateButtons() {
        RPG rPG = RPG.getInstance();
        QuestState questState = this.getState(this.filter);
        for (Map.Entry<String, Quest.State> entry : rPG.questSystem.entrySet()) {
            String string = entry.getKey();
            Quest.State state = entry.getValue();
            if (state.state != questState) continue;
            Quest quest = QuestFactory.createQuest(string);
            quest.state = state;
            this.addButton(quest);
        }
    }

    @Override
    public void updateLeftText() {
        if (this.buttons.isEmpty()) {
            switch (this.filter.ordinal()) {
                case 0: {
                    this.leftText = "No open quests.";
                    break;
                }
                case 1: {
                    this.leftText = "No closed quests.";
                    break;
                }
                default: {
                    this.leftText = "No quests.";
                    break;
                }
            }
        } else {
            this.leftText = null;
        }
    }

    @Override
    public void updateRightText() {
        if (this.buttons.isEmpty()) {
            this.rightText = null;
        } else {
            Quest quest = (Quest)super.getSelectedButton().data;
            long l = RPG.getInstance().timeSeconds / 60L / 60L / 24L;
            long l2 = quest.state.started / 60L / 60L / 24L;
            this.rightText = String.format("Started %d days ago\n\n%s", l - l2, quest._data.description);
        }
    }

    @Override
    public void updateScene() {
        this.scene.portrait = "quest";
        this.scene.portraitTitle = "Quest";
        super.setScene(this.scene);
    }

    private static enum Filter {
        Open,
        Closed;

    }
}

