/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.Documentation;
import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.StaticRPG;
import de.slashbinbash.hexen.enums.Ability;
import de.slashbinbash.hexen.enums.Attribute;
import de.slashbinbash.hexen.handler.HandlerBase;
import de.slashbinbash.hexen.model.ClassCreature;
import de.slashbinbash.hexen.model.CombatAction;
import de.slashbinbash.hexen.model.CombatActions;
import de.slashbinbash.hexen.model.Inventory;
import de.slashbinbash.hexen.model.Item;
import de.slashbinbash.hexen.model.ItemType;
import de.slashbinbash.hexen.model.Party;
import de.slashbinbash.hexen.ui.Button;
import de.slashbinbash.hexen.view.StaticView;
import java.util.Collections;
import java.util.List;

public class PartyHandler
extends HandlerBase {
    private static final int PICK_CREATURE = 0;
    private static final int PICK_ACTION = 1;
    private static final int PICK_ITEM = 2;
    private static final int PICK_COMBAT_ACTION = 3;
    private static final int PICK_NAME = 4;
    private static final int PICK_TARGET = 5;
    private static final int SHOW_MESSAGE = 6;
    private static final int SHOW_CREATURE_STATS = 7;
    private static final int SHOW_PARTY_STATS = 8;
    private Action selectedAction = null;
    private CombatAction selectedCombatAction = null;
    private ClassCreature selectedCreature = null;
    private Item selectedItem = null;
    private ClassCreature selectedTarget = null;

    private void addButton(Action action) {
        String string = null;
        switch (action.ordinal()) {
            case 1: {
                string = "Equip item";
                break;
            }
            case 5: {
                string = "Move to back";
                break;
            }
            case 4: {
                string = "Move to front";
                break;
            }
            case 7: {
                string = "Rename";
                break;
            }
            case 2: {
                string = "Unequp item";
                break;
            }
            case 3: {
                string = "Remove action";
                break;
            }
            case 6: {
                string = "Leave party";
                break;
            }
            case 0: {
                string = "Use item";
                break;
            }
            case 8: {
                string = "Use action";
                break;
            }
            case 9: {
                string = "Move action";
                break;
            }
            case 10: {
                string = "Show stats";
                break;
            }
            default: {
                string = action.name();
            }
        }
        super.addButton(string, (Object)action);
    }

    private void addButton(ClassCreature classCreature) {
        super.addButton(classCreature.name, classCreature);
    }

    private void addButton(CombatAction combatAction) {
        super.addButton(combatAction.getName(), combatAction);
    }

    private void addButton(Item item) {
        String string = String.format("%-22s %3d", item.getName(), item.count);
        super.addButton(string, item);
    }

    private void confirmEquipItem() {
        StaticRPG.Result result = StaticRPG.equipItem(this.selectedCreature, this.selectedItem);
        this.popState();
        switch (result) {
            case OK: {
                break;
            }
            default: {
                this.showMessage(result);
            }
        }
    }

    private void selectNextMember() {
        Party party = RPG.getInstance().party;
        int n = 0;
        for (ClassCreature classCreature : party.getMembers()) {
            if (classCreature == this.selectedCreature) break;
            ++n;
        }
        this.selectedCreature = party.getMember((n + 1) % party.getMembers().size());
        this.scene.portrait = this.selectedCreature.portrait;
        this.scene.portraitTitle = this.selectedCreature.name;
        super.setScene(this.scene);
        super.update();
    }

    private void confirmMoveBack() {
        Party party = RPG.getInstance().party;
        List<ClassCreature> list = party.getMembers();
        list.remove(this.selectedCreature);
        list.add(list.size(), this.selectedCreature);
    }

    private void confirmMoveFront() {
        Party party = RPG.getInstance().party;
        List<ClassCreature> list = party.getMembers();
        list.remove(this.selectedCreature);
        list.add(0, this.selectedCreature);
    }

    private void confirmUnequipItem() {
        StaticRPG.Result result = StaticRPG.unequip(this.selectedCreature);
        switch (result) {
            case OK: {
                break;
            }
            default: {
                this.showMessage(result);
            }
        }
    }

    private void confirmUnlearnCombatAction() {
        StaticRPG.Result result = StaticRPG.unlearnCombatAction(this.selectedCreature, this.selectedCombatAction);
        switch (result) {
            case OK: {
                break;
            }
            default: {
                this.showMessage(result);
            }
        }
    }

    private void confirmUnparty() {
        Party party = RPG.getInstance().party;
        party.removeMember(this.selectedCreature);
        this.showMessage("%s left the party.", this.selectedCreature.name);
    }

    private void confirmUseItem() {
        StaticRPG.Result result = StaticRPG.useItem(this.selectedCreature, this.selectedItem, this.selectedCreature);
        switch (result) {
            case OK: {
                this.showMessage("%s used %s.", this.selectedCreature.name, this.selectedItem.getName());
                break;
            }
            default: {
                this.showMessage(result);
            }
        }
    }

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
        block0 : switch (this.state) {
            case 0: {
                this.handlePickCreature(commandEvent, object);
                break;
            }
            case 5: {
                this.handlePickTarget(commandEvent, object);
                break;
            }
            case 1: {
                this.handlePickAction(commandEvent, object);
                break;
            }
            case 3: {
                this.handlePickCombatAction(commandEvent, object);
                break;
            }
            case 2: {
                switch (this.selectedAction.ordinal()) {
                    case 0: 
                    case 1: 
                    case 2: {
                        this.handlePickItem(commandEvent, object);
                        break block0;
                    }
                    case 3: {
                        this.handlePickCombatAction(commandEvent, object);
                        break block0;
                    }
                }
                break;
            }
            case 4: {
                this.handlePickName(commandEvent, object);
                break;
            }
            case 6: {
                if (commandEvent != CommandEvent.CONFIRM && commandEvent != CommandEvent.CANCEL) break;
                this.popState();
                break;
            }
            case 7: {
                this.handleShowCreatureStats(commandEvent, object);
                break;
            }
            case 8: {
                this.handleShowPartyStats(commandEvent, object);
            }
        }
    }

    private void handlePickAction(CommandEvent commandEvent, Object object) {
        block0 : switch (commandEvent) {
            case TAB_RIGHT: {
                this.selectNextMember();
                break;
            }
            case CONFIRM: {
                if (this.buttons.isEmpty()) {
                    return;
                }
                this.selectedAction = (Action)((Object)super.getSelectedButton().data);
                switch (this.selectedAction.ordinal()) {
                    case 0: {
                        this.pushState(2);
                        break block0;
                    }
                    case 1: {
                        this.pushState(2);
                        break block0;
                    }
                    case 9: {
                        this.pushState(3);
                        break block0;
                    }
                    case 5: {
                        this.confirmMoveBack();
                        break block0;
                    }
                    case 4: {
                        this.confirmMoveFront();
                        break block0;
                    }
                    case 2: {
                        Item item = this.selectedCreature.equipment;
                        StaticRPG.Result result = StaticRPG.unequip(this.selectedCreature);
                        switch (result) {
                            case OK: {
                                if (item == null) break block0;
                                break block0;
                            }
                            case ITEM_NOT_UNEQUIPABLE: {
                                this.showMessage("%s cannot be unequipped.", item.getName());
                                break block0;
                            }
                        }
                        this.showMessage(result);
                        break block0;
                    }
                    case 3: {
                        this.pushState(3);
                        break block0;
                    }
                    case 6: {
                        this.confirmUnparty();
                        break block0;
                    }
                    case 7: {
                        this.pushState(4);
                        super.setMode(HandlerBase.Mode.Input);
                        super.setInput(this.selectedCreature.name);
                        break block0;
                    }
                    case 8: {
                        this.pushState(3);
                        break block0;
                    }
                    case 10: {
                        this.pushState(7);
                        break block0;
                    }
                }
                break;
            }
            case CANCEL: {
                this.popState();
                break;
            }
        }
    }

    private void handlePickCombatAction(CommandEvent commandEvent, Object object) {
        block0 : switch (commandEvent) {
            case NEXT: {
                if (this.selectedAction != Action.MoveAction || this.selectedCombatAction == null) break;
                CombatActions combatActions = this.selectedCreature.combatActions;
                int n = combatActions.indexOf(this.selectedCombatAction);
                int n2 = this.buttonIndex;
                Collections.swap(combatActions.list(), n, n2);
                this.update();
                break;
            }
            case PREVIOUS: {
                if (this.selectedAction != Action.MoveAction || this.selectedCombatAction == null) break;
                CombatActions combatActions = this.selectedCreature.combatActions;
                int n = combatActions.indexOf(this.selectedCombatAction);
                int n3 = this.buttonIndex;
                Collections.swap(combatActions.list(), n, n3);
                this.update();
                break;
            }
            case CONFIRM: {
                if (this.buttons.isEmpty()) {
                    return;
                }
                if (this.selectedAction == Action.MoveAction) {
                    CombatAction combatAction = (CombatAction)this.getSelectedButton().data;
                    this.selectedCombatAction = this.selectedCombatAction == null ? combatAction : null;
                    return;
                }
                this.selectedCombatAction = (CombatAction)super.getSelectedButton().data;
                switch (this.selectedAction.ordinal()) {
                    case 3: {
                        this.confirmUnlearnCombatAction();
                        break block0;
                    }
                    case 8: {
                        switch (this.selectedCombatAction.getTarget()) {
                            case PARTY_ALL: 
                            case ENEMY_ALL: 
                            case ENEMY_GROUP_ALL: {
                                StaticRPG.doCombatAction(this.selectedCombatAction, this.selectedCreature, RPG.getInstance().party.getMembers());
                                break block0;
                            }
                            case PARTY_ONE: 
                            case ENEMY_ONE: 
                            case ENEMY_GROUP_ONE: {
                                this.pushState(5);
                                break block0;
                            }
                            case SELF: {
                                StaticRPG.doCombatAction(this.selectedCombatAction, this.selectedCreature, this.selectedCreature);
                                break block0;
                            }
                        }
                        break block0;
                    }
                }
                break;
            }
            case CANCEL: {
                if ((this.selectedAction == Action.UseAction || this.selectedAction == Action.MoveAction) && this.selectedCombatAction != null) {
                    this.selectedCombatAction = null;
                    return;
                }
                this.popState();
                break;
            }
            case SHOW_DOCUMENTATION: {
                CombatAction combatAction = (CombatAction)super.getSelectedButton().data;
                Documentation.showCombatAction(combatAction.getId());
                break;
            }
        }
    }

    private void handlePickCreature(CommandEvent commandEvent, Object object) {
        switch (commandEvent) {
            case CONFIRM: {
                ClassCreature classCreature;
                Object object2;
                if (this.buttons.isEmpty() || !((object2 = super.getSelectedButton().data) instanceof ClassCreature)) break;
                this.selectedCreature = classCreature = (ClassCreature)object2;
                this.pushState(1);
                break;
            }
            case TAB_RIGHT: {
                this.pushState(8);
                break;
            }
            case CANCEL: {
                this.popState();
                break;
            }
        }
    }

    private void handlePickItem(CommandEvent commandEvent, Object object) {
        block0 : switch (commandEvent) {
            case TAB_RIGHT: {
                switch (this.selectedAction.ordinal()) {
                    case 0: {
                        this.selectNextMember();
                    }
                }
                break;
            }
            case CONFIRM: {
                if (this.buttons.isEmpty()) break;
                this.selectedItem = (Item)super.getSelectedButton().data;
                switch (this.selectedAction.ordinal()) {
                    case 0: {
                        this.confirmUseItem();
                        break block0;
                    }
                    case 1: {
                        this.confirmEquipItem();
                        break block0;
                    }
                    case 2: {
                        this.confirmUnequipItem();
                        break block0;
                    }
                }
                break;
            }
            case CANCEL: {
                this.popState();
                break;
            }
            case SHOW_DOCUMENTATION: {
                Item item = (Item)super.getSelectedButton().data;
                Documentation.showItem(item);
                break;
            }
        }
    }

    private void handlePickName(CommandEvent commandEvent, Object object) {
        switch (commandEvent) {
            case CONFIRM: {
                String string = super.getInput().trim();
                if (string.isEmpty()) break;
                this.selectedCreature.name = string;
                super.setMode(HandlerBase.Mode.Default);
                this.popState();
                break;
            }
            case CANCEL: {
                this.popState();
                super.setMode(HandlerBase.Mode.Default);
                break;
            }
        }
    }

    private void handlePickTarget(CommandEvent commandEvent, Object object) {
        switch (commandEvent) {
            case CONFIRM: {
                if (this.selectedAction != Action.UseAction || this.buttons.isEmpty()) break;
                this.selectedTarget = (ClassCreature)((Button)this.buttons.get((int)this.buttonIndex)).data;
                StaticRPG.doCombatAction(this.selectedCombatAction, this.selectedCreature, this.selectedTarget);
                this.showMessage("Done", new Object[0]);
                break;
            }
            case CANCEL: {
                this.popState();
                break;
            }
        }
    }

    private void handleShowCreatureStats(CommandEvent commandEvent, Object object) {
        if (commandEvent == CommandEvent.CANCEL) {
            this.popState();
        } else if (commandEvent == CommandEvent.TAB_RIGHT) {
            this.selectNextMember();
        }
    }

    private void handleShowPartyStats(CommandEvent commandEvent, Object object) {
        if (commandEvent == CommandEvent.CANCEL) {
            this.popState();
        }
    }

    @Override
    public void init() {
        this.scene.portraitTitle = "Party";
        super.init();
    }

    private boolean isValidChar(char c) {
        return 'A' <= c && c <= 'Z' || '0' <= c && c <= '9';
    }

    private String printPartyStats() {
        int n;
        Party party = RPG.getInstance().party;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PARTY STATS\n");
        stringBuffer.append("\nCan move? ").append(party.canMove());
        stringBuffer.append("\nGuild     ");
        if (party.guild != null) {
            stringBuffer.append(party.guild);
        } else {
            stringBuffer.append("-");
        }
        stringBuffer.append("\n\nABILITIES              max");
        for (Ability object : Ability.sortedView()) {
            n = party.getAbilityScoreMax(object);
            if (n == 0) continue;
            stringBuffer.append(String.format("\n%-22s %3d", object.name, n));
        }
        stringBuffer.append("\n\nATTRIBUTES             sum");
        for (Attribute attribute : Attribute.values()) {
            n = party.getAttributeScoreSum(attribute);
            if (n == 0) continue;
            stringBuffer.append(String.format("\n%-22s %3d", attribute.name, n));
        }
        return stringBuffer.toString();
    }

    private void reset() {
        this.selectedAction = null;
        this.resetState();
    }

    private void showMessage(StaticRPG.Result result) {
        switch (result) {
            case ITEM_NOT_USABLE: {
                this.leftText = String.format("%s cannot be used.", this.selectedItem.getName());
                break;
            }
            case ITEM_NOT_EQUIPABLE: {
                this.leftText = String.format("%s cannot be equipped.", this.selectedItem.getName());
                break;
            }
            case ITEM_NOT_UNEQUIPABLE: {
                this.leftText = String.format("%s cannot be unequipped.", this.selectedItem.getName());
                break;
            }
            case ITEM_NOT_DROPABLE: {
                this.leftText = String.format("%s cannot be dropped.", this.selectedItem.getName());
                break;
            }
            case SKILL_CHECK_FAIL: {
                this.leftText = String.format("%s does not have the required skill.", this.selectedCreature.name);
                break;
            }
            default: {
                this.leftText = result.name();
            }
        }
        this.pushState(6);
    }

    private void showMessage(String string, Object ... objectArray) {
        this.leftText = String.format(string, objectArray);
        this.pushState(6);
    }

    @Override
    public void updateButtons() {
        block0 : switch (this.state) {
            case 1: {
                this.updateButtonsActions(this.selectedCreature);
                break;
            }
            case 0: {
                for (ClassCreature classCreature : RPG.getInstance().party.getMembers()) {
                    this.addButton(classCreature);
                }
                break;
            }
            case 3: {
                switch (this.selectedAction.ordinal()) {
                    case 9: {
                        for (int i = 0; i < this.selectedCreature.combatActions.size(); ++i) {
                            CombatAction combatAction = this.selectedCreature.combatActions.get(i);
                            Object object = combatAction.getName();
                            if (i >= 6) {
                                object = this.selectedCombatAction == combatAction ? ">" + (String)object : " " + (String)object;
                            } else if (this.selectedCombatAction == combatAction) {
                                object = ">" + (String)object;
                            }
                            super.addButton((String)object, combatAction);
                        }
                        break block0;
                    }
                    case 3: {
                        for (int i = 0; i < this.selectedCreature.combatActions.size(); ++i) {
                            CombatAction combatAction = this.selectedCreature.combatActions.get(i);
                            Object object = combatAction.getName();
                            if (i >= 6) {
                                object = " " + (String)object;
                            }
                            super.addButton((String)object, combatAction);
                        }
                        break block0;
                    }
                    case 8: {
                        for (CombatAction combatAction : this.selectedCreature.combatActions) {
                            if (this.selectedCreature.actionPoints < combatAction.getActionPointCost()) continue;
                            this.addButton(combatAction);
                        }
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                Inventory inventory = RPG.getInstance().party.inventory;
                switch (this.selectedAction.ordinal()) {
                    case 0: {
                        for (Item item2 : inventory.filter(item -> item.isUseable())) {
                            this.addButton(item2);
                        }
                        break block0;
                    }
                    case 1: {
                        for (Item item3 : inventory.listEquipable()) {
                            this.addButton(item3);
                        }
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                if (this.selectedAction != Action.UseAction) break;
                for (ClassCreature classCreature : RPG.getInstance().party.getMembers()) {
                    this.addButton(classCreature);
                }
                break;
            }
        }
    }

    private void updateButtonsActions(ClassCreature classCreature) {
        RPG rPG = RPG.getInstance();
        Inventory inventory = rPG.party.inventory;
        this.buttons.clear();
        this.addButton(Action.ShowStats);
        if (classCreature.playable) {
            if (inventory.size(ItemType.Consume) > 0) {
                this.addButton(Action.Use);
            }
            if (classCreature.equipment == null) {
                int n = inventory.countEquipable();
                if (n > 0) {
                    this.addButton(Action.Equip);
                }
            } else if (!classCreature.equipment.isUnequipable()) {
                this.addButton(Action.Unequip);
            }
            if (!classCreature.combatActions.isEmpty()) {
                if (classCreature.isAlive()) {
                    this.addButton(Action.UseAction);
                }
                this.addButton(Action.MoveAction);
                this.addButton(Action.Unlearn);
            }
        }
        if (rPG.party.getMembers().size() > 1) {
            this.addButton(Action.MoveFront);
            this.addButton(Action.MoveBack);
        }
    }

    @Override
    public void updateLeftText() {
        if (this.state != 6) {
            this.leftText = null;
        }
        block0 : switch (this.state) {
            case 0: {
                if (!this.buttons.isEmpty()) break;
                this.leftText = "Party empty.";
                break;
            }
            case 3: {
                if (!this.buttons.isEmpty()) break;
                this.leftText = "No actions.";
                break;
            }
            case 8: {
                this.leftText = this.printPartyStats();
                break;
            }
            case 2: {
                if (this.buttons.isEmpty()) {
                    switch (this.selectedAction.ordinal()) {
                        case 0: {
                            this.leftText = "No items to use.";
                            break block0;
                        }
                        case 1: {
                            this.leftText = "No items to equip.";
                            break block0;
                        }
                    }
                    this.leftText = "No items.";
                    break;
                }
                this.leftText = null;
                break;
            }
        }
        if (this.state == 7) {
            StringBuilder stringBuilder = new StringBuilder();
            StaticView.printStats(stringBuilder, this.selectedCreature);
            stringBuilder.append("\n\nJOB\n").append(this.selectedCreature.job);
            stringBuilder.append("\n\n");
            StaticView.printTraits(stringBuilder, this.selectedCreature);
            stringBuilder.append("\n\n");
            StaticView.printSlotMods(stringBuilder, this.selectedCreature);
            stringBuilder.append("\n\nEQUIPMENT\n");
            if (this.selectedCreature.equipment == null) {
                stringBuilder.append("-");
            } else {
                stringBuilder.append(this.selectedCreature.equipment.getName());
            }
            this.leftText = stringBuilder.toString();
        }
    }

    @Override
    public void updateRightText() {
        Object object;
        this.rightText = null;
        if (this.state == 7) {
            object = new StringBuilder();
            StaticView.printAbilities((StringBuilder)object, this.selectedCreature, true);
            ((StringBuilder)object).append("\n\n");
            StaticView.printAttributes((StringBuilder)object, this.selectedCreature, true);
            ((StringBuilder)object).append("\n\n");
            StaticView.printCombatActions((StringBuilder)object, this.selectedCreature);
            this.rightText = ((StringBuilder)object).toString();
        }
        if (this.buttons.isEmpty()) {
            return;
        }
        switch (this.state) {
            case 1: {
                object = (Action)((Object)super.getSelectedButton().data);
                if (object != Action.Unequip) break;
                Item item = this.selectedCreature.equipment;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(item.getName()).append("\n");
                if (item.getDescription() != null) {
                    stringBuilder.append("\n");
                    stringBuilder.append(item.getDescription());
                    stringBuilder.append("\n");
                }
                if (item.getType() == ItemType.Equip) {
                    ClassCreature classCreature = this.selectedCreature;
                    Item item2 = null;
                    Item item3 = item;
                    stringBuilder.append("\n");
                    StaticView.printDiff(stringBuilder, classCreature, item3, item2);
                }
                this.rightText = stringBuilder.toString();
                break;
            }
            case 0: {
                this.rightText = null;
                break;
            }
            case 3: {
                break;
            }
            case 2: {
                object = (Item)super.getSelectedButton().data;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(((Item)object).getName()).append("\n");
                if (((Item)object).getDescription() != null) {
                    stringBuilder.append("\n");
                    stringBuilder.append(((Item)object).getDescription());
                    stringBuilder.append("\n");
                }
                if (((Item)object).getType() == ItemType.Equip) {
                    ClassCreature classCreature = this.selectedCreature;
                    Object object2 = object;
                    Item item = classCreature.equipment;
                    stringBuilder.append("\n");
                    StaticView.printDiff(stringBuilder, classCreature, item, (Item)object2);
                }
                this.rightText = stringBuilder.toString();
                break;
            }
            case 5: {
                if (this.selectedAction != Action.UseAction || this.selectedCombatAction == null) break;
                object = (ClassCreature)super.getSelectedButton().data;
                this.rightText = "Use " + this.selectedCombatAction.getName() + " on " + ((ClassCreature)object).name;
                break;
            }
        }
    }

    @Override
    public void updateScene() {
        if (this.state == 0) {
            if (this.buttons.isEmpty()) {
                return;
            }
            Object object = super.getSelectedButton().data;
            if (object instanceof ClassCreature) {
                ClassCreature classCreature = (ClassCreature)object;
                this.scene.portrait = classCreature.portrait;
                this.scene.portraitTitle = classCreature.name;
                super.setScene(this.scene);
            }
        }
    }

    private static enum Action {
        Use,
        Equip,
        Unequip,
        Unlearn,
        MoveFront,
        MoveBack,
        Unparty,
        Rename,
        UseAction,
        MoveAction,
        ShowStats;

    }
}

