/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.StaticRPG;
import de.slashbinbash.hexen.handler.HandlerBase;
import de.slashbinbash.hexen.modder.Modder;
import de.slashbinbash.hexen.modder.StaticModder;
import de.slashbinbash.hexen.model.ClassCreature;
import de.slashbinbash.hexen.model.Inventory;
import de.slashbinbash.hexen.model.Party;
import de.slashbinbash.hexen.model.Slot;
import de.slashbinbash.hexen.model.SlotItem;
import de.slashbinbash.hexen.view.StaticView;

public class ModderHandler
extends HandlerBase {
    private static final int PICK_OPT = 0;
    private static final int PICK_MOD = 1;
    private static final int PICK_CREATURE = 2;
    private static final int PICK_SLOT = 3;
    private static final int SHOW_MESSAGE = 4;
    private Modder modder = null;
    private Action selectedAction = null;
    private int selectedSlot = -1;
    private ClassCreature selectedCreature = null;

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
        switch (this.state) {
            case 0: {
                this.handlePickOpt(commandEvent, object);
                break;
            }
            case 1: {
                this.handlePickMod(commandEvent, object);
                break;
            }
            case 2: {
                this.handlePickCreature(commandEvent, object);
                break;
            }
            case 3: {
                this.handlePickSlot(commandEvent, object);
                break;
            }
            case 4: {
                if (commandEvent != CommandEvent.CONFIRM && commandEvent != CommandEvent.CANCEL) break;
                this.popState();
                break;
            }
        }
    }

    private void handlePickCreature(CommandEvent commandEvent, Object object) {
        switch (commandEvent) {
            case CONFIRM: {
                this.selectedCreature = (ClassCreature)super.getSelectedButton().data;
                this.pushState(3);
                break;
            }
            case CANCEL: {
                this.popState();
                break;
            }
        }
    }

    private void handlePickMod(CommandEvent commandEvent, Object object) {
        block0 : switch (commandEvent) {
            case CONFIRM: {
                if (this.buttons.isEmpty() || this.selectedAction != Action.Add) break;
                SlotItem.Data data = (SlotItem.Data)super.getSelectedButton().data;
                Inventory inventory = RPG.getInstance().party.inventory;
                if (StaticModder.canBuyMod(data, inventory)) {
                    StaticRPG.Result result = StaticModder.applyMod(data, this.selectedCreature, this.selectedSlot);
                    switch (result) {
                        case OK: {
                            super.popState();
                            break block0;
                        }
                        case REQUIREMENT_CHECK_FAILED: {
                            this.showMessage("Requirements not met.");
                            break block0;
                        }
                        case FAILURE: {
                            this.showMessage("Failed to apply mod.");
                            break block0;
                        }
                    }
                    break;
                }
                this.showMessage("Not enought resources.");
                break;
            }
            case CANCEL: {
                this.popState();
                break;
            }
        }
    }

    private void handlePickOpt(CommandEvent commandEvent, Object object) {
        switch (commandEvent) {
            case CONFIRM: {
                this.selectedAction = (Action)((Object)super.getSelectedButton().data);
                switch (this.selectedAction.ordinal()) {
                    case 2: {
                        this.pushState(1);
                        break;
                    }
                    case 0: {
                        this.pushState(2);
                        break;
                    }
                    case 1: {
                        this.pushState(2);
                    }
                }
                break;
            }
            case CANCEL: {
                this.popState();
                break;
            }
        }
    }

    private void handlePickSlot(CommandEvent commandEvent, Object object) {
        block0 : switch (commandEvent) {
            case TAB_RIGHT: {
                this.selectNextMember();
                break;
            }
            case CONFIRM: {
                if (this.buttons.isEmpty()) break;
                Integer n = (Integer)super.getSelectedButton().data;
                switch (this.selectedAction.ordinal()) {
                    case 0: {
                        this.selectedSlot = n;
                        this.pushState(1);
                        break block0;
                    }
                    case 1: {
                        StaticRPG.Result result = StaticModder.removeMod(this.selectedCreature, n);
                        switch (result) {
                            case FAILURE: {
                                this.showMessage("Failed to remove mod.");
                                break block0;
                            }
                        }
                        break block0;
                    }
                }
                break;
            }
            case CANCEL: {
                this.popState();
                break;
            }
        }
    }

    public void init(Modder modder) {
        this.modder = modder;
        this.reset();
    }

    private void printMod(StringBuilder stringBuilder, SlotItem.Data data) {
        stringBuilder.append(data.name + " (" + data.slotId + ")");
        if (data.requirements != null) {
            stringBuilder.append("\n\n");
            StaticView.printRequirements(stringBuilder, data.requirements);
        }
        if (data.modifiers != null) {
            stringBuilder.append("\n\n");
            StaticView.printModifiers(stringBuilder, data.modifiers);
        }
    }

    private void reset() {
        super.init();
    }

    private void showMessage(String string) {
        this.leftText = string;
        this.pushState(4);
    }

    private void selectNextMember() {
        Party party = RPG.getInstance().party;
        int n = 0;
        for (ClassCreature classCreature : party.getMembers()) {
            if (classCreature == this.selectedCreature) break;
            ++n;
        }
        this.selectedCreature = party.getMember((n + 1) % party.getMembers().size());
        super.update();
    }

    @Override
    public void updateButtons() {
        Party party = RPG.getInstance().party;
        switch (this.state) {
            case 4: {
                break;
            }
            case 0: {
                super.addButton("Browse", (Object)Action.Browse);
                super.addButton("Add", (Object)Action.Add);
                super.addButton("Remove", (Object)Action.Remove);
                break;
            }
            case 2: {
                for (ClassCreature classCreature : party.getMembers()) {
                    super.addButton(classCreature.name, classCreature);
                }
                break;
            }
            case 1: {
                if (this.selectedAction == Action.Add) {
                    Slot slot = this.selectedCreature.getSlots()[this.selectedSlot];
                    for (SlotItem.Data data : this.modder._data.mods) {
                        if (!data.slotId.equals(slot.id) || slot.mod != null && slot.mod.getId().equals(data.__id__)) continue;
                        int n = StaticModder.getCost(data);
                        String string = String.format("%-23s %4d", data.name, n);
                        super.addButton(string, data);
                    }
                } else {
                    if (this.selectedAction != Action.Browse) break;
                    for (SlotItem.Data data : this.modder._data.mods) {
                        int n = StaticModder.getCost(data);
                        String string = String.format("%-23s %4d", data.name + " (" + data.slotId + ")", n);
                        super.addButton(string, data);
                    }
                }
                break;
            }
            case 3: {
                Slot[] slotArray = this.selectedCreature.getSlots();
                if (slotArray == null) break;
                for (int i = 0; i < slotArray.length; ++i) {
                    Slot slot = slotArray[i];
                    String string = String.format("%-4s %s\n", slot.getName(), slot.mod != null ? slot.mod.getName() : "-");
                    super.addButton(string, i);
                }
                break;
            }
        }
    }

    @Override
    public void updateLeftText() {
        switch (this.state) {
            case 3: {
                if (this.buttons.isEmpty()) {
                    this.leftText = "No slots available.";
                    break;
                }
                this.leftText = null;
                break;
            }
            case 1: {
                if (this.buttons.isEmpty()) {
                    this.leftText = "No mods available.";
                    break;
                }
                this.leftText = null;
                break;
            }
            case 4: {
                break;
            }
            default: {
                this.leftText = null;
            }
        }
    }

    @Override
    public void updateRightText() {
        this.rightText = null;
        if (this.buttons.isEmpty()) {
            return;
        }
        switch (this.state) {
            case 0: {
                if (this.modder._data.description == null) break;
                this.rightText = this.modder._data.description;
                break;
            }
            case 1: {
                SlotItem.Data data = (SlotItem.Data)super.getSelectedButton().data;
                StringBuilder stringBuilder = new StringBuilder();
                this.printMod(stringBuilder, data);
                this.rightText = stringBuilder.toString();
                break;
            }
            case 3: {
                int n = (Integer)super.getSelectedButton().data;
                Slot slot = this.selectedCreature.getSlots()[n];
                SlotItem slotItem = slot.mod;
                StringBuilder stringBuilder = new StringBuilder();
                if (slotItem != null) {
                    this.printMod(stringBuilder, slotItem._data);
                }
                this.rightText = stringBuilder.toString();
                break;
            }
        }
    }

    @Override
    public void updateScene() {
        switch (this.state) {
            case 0: {
                if (this.modder._data.scene != null) {
                    super.setScene(this.modder._data.scene);
                    break;
                }
                this.scene.portrait = "modder";
                this.scene.portraitTitle = "Modder";
                super.setScene(this.scene);
                break;
            }
            case 2: {
                ClassCreature classCreature = (ClassCreature)super.getSelectedButton().data;
                this.scene.portrait = classCreature.portrait;
                this.scene.portraitTitle = classCreature.name;
                super.setScene(this.scene);
                break;
            }
            default: {
                if (this.selectedCreature == null) break;
                this.scene.portrait = this.selectedCreature.portrait;
                this.scene.portraitTitle = this.selectedCreature.name;
                super.setScene(this.scene);
            }
        }
    }

    static enum Action {
        Add,
        Remove,
        Browse;

    }
}

