/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.handler.HandlerBase;
import de.slashbinbash.hexen.model.ClassCreature;
import de.slashbinbash.hexen.temple.Heal;
import de.slashbinbash.hexen.temple.StaticHeal;
import de.slashbinbash.hexen.ui.Button;
import de.slashbinbash.hexen.view.StaticView;
import java.util.List;

public class HealHandler
extends HandlerBase {
    private static final int PICK_OPT = 0;
    private static final int SHOW_MESSAGE = 1;
    private Heal heal = null;

    public HealHandler(HandlerBase handlerBase) {
        super.setScene(handlerBase.scene);
    }

    private Option getSelectedOption() {
        if (this.buttons.isEmpty()) {
            return null;
        }
        return (Option)((Button)this.buttons.get((int)this.buttonIndex)).data;
    }

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
        switch (this.state) {
            case 0: {
                this.handlePickOpt(commandEvent, object);
                break;
            }
            case 1: {
                if (commandEvent != CommandEvent.CONFIRM) break;
                super.popState();
                break;
            }
        }
    }

    private void handlePickOpt(CommandEvent commandEvent, Object object) {
        if (this.buttons.isEmpty()) {
            if (commandEvent == CommandEvent.CONFIRM || commandEvent == CommandEvent.CANCEL) {
                super.popState();
            }
            return;
        }
        RPG rPG = RPG.getInstance();
        switch (commandEvent) {
            case CONFIRM: {
                Option option = this.getSelectedOption();
                if (option == null) break;
                if (rPG.party.inventory.getCurrency() < option.cost) {
                    this.showMessage("Not enough money.");
                    break;
                }
                rPG.party.inventory.removeCurrency(option.cost);
                switch (option.action.ordinal()) {
                    case 0: {
                        StaticHeal.heal(option.cc);
                        break;
                    }
                    case 2: {
                        StaticHeal.removeConditions(option.cc);
                        break;
                    }
                    case 1: {
                        StaticHeal.revive(option.cc);
                    }
                }
                break;
            }
            case CANCEL: {
                this.popState();
                break;
            }
        }
    }

    public void init(Heal heal) {
        this.heal = heal;
        super.init();
    }

    private void showMessage(String string) {
        this.leftText = string;
        this.pushState(1);
    }

    @Override
    public void updateButtons() {
        if (this.state == 0) {
            for (ClassCreature classCreature : RPG.getInstance().party.getMembers()) {
                String string;
                Object object;
                if (classCreature.canRevive()) {
                    if (!this.heal._data.canRevive) continue;
                    Option option = new Option(Action.Revive, classCreature, this.heal._data.reviveCost);
                    object = String.format("%-21s %4d", "Revive " + classCreature.name, option.cost);
                    StaticView.addButton((List<Button>)this.buttons, (String)object, option);
                    continue;
                }
                if (classCreature.hasConditions()) {
                    if (!this.heal._data.canRemoveConditions) continue;
                    int n = this.heal._data.removeConditionsCost * classCreature.getConditions().size();
                    object = new Option(Action.RemoveConditions, classCreature, n);
                    string = String.format("%-21s %4d", "Cure " + classCreature.name, n);
                    StaticView.addButton((List<Button>)this.buttons, string, object);
                    continue;
                }
                if (classCreature.hitPoints >= classCreature.calcMaxHitPoints() || !this.heal._data.canHeal) continue;
                int n = this.heal._data.healCost * (classCreature.calcMaxHitPoints() - classCreature.hitPoints);
                object = new Option(Action.Heal, classCreature, n);
                string = String.format("%-21s %4d", "Heal " + classCreature.name, n);
                StaticView.addButton((List<Button>)this.buttons, string, object);
            }
        }
    }

    @Override
    public void updateLeftText() {
        if (this.state != 1) {
            this.leftText = null;
        }
    }

    @Override
    public void updateRightText() {
        this.rightText = null;
        block0 : switch (this.state) {
            case 0: {
                Option option = this.getSelectedOption();
                if (option != null) {
                    switch (option.action.ordinal()) {
                        case 0: {
                            this.rightText = "Restores hit points";
                            break block0;
                        }
                        case 2: {
                            this.rightText = "Removes all conditions";
                            break block0;
                        }
                        case 1: {
                            this.rightText = "Revives the character";
                            break block0;
                        }
                    }
                    break;
                }
                this.leftText = "Nothing to do.";
                break;
            }
            case 1: {
                break;
            }
        }
    }

    @Override
    public void updateScene() {
        if (this.heal._data.scene != null) {
            super.setScene(this.heal._data.scene);
        }
    }

    private static class Option {
        public Action action;
        public ClassCreature cc;
        public int cost = 0;

        public Option(Action action, ClassCreature classCreature, int n) {
            this.action = action;
            this.cc = classCreature;
            this.cost = n;
        }
    }

    private static enum Action {
        Heal,
        Revive,
        RemoveConditions;

    }
}

