/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.Hexen;
import de.slashbinbash.hexen.InputMapper;
import de.slashbinbash.hexen.handler.IHandler;
import de.slashbinbash.hexen.message.Message;
import de.slashbinbash.hexen.message.MessageBus;
import de.slashbinbash.hexen.model.Scene;
import de.slashbinbash.hexen.ui.Button;
import de.slashbinbash.hexen.view.StaticView;
import de.slashbinbash.hexen.view.ViewBase;
import de.slashbinbash.opengl.JoystickEvent;
import de.slashbinbash.opengl.KeyboardEvent;
import de.slashbinbash.opengl.MouseEvent;
import de.slashbinbash.opengl.renderer.Draw2D;
import de.slashbinbash.util.Strings;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class HandlerBase
implements IHandler {
    public LinkedList<State> states = new LinkedList();
    public int state = 0;
    public Mode mode = Mode.Default;
    public InputType inputType = InputType.String;
    public int maxInputLength = 14;
    public Scene scene = new Scene();
    public List<Button> buttons = new ArrayList<Button>();
    public int buttonIndex = 0;
    public String leftText = null;
    public String rightText = null;
    private StringBuilder inputBuffer = new StringBuilder();
    private boolean requestedPop = false;
    private boolean requestedClose = false;

    public Button addButton(String string) {
        return StaticView.addButton(this.buttons, string);
    }

    public Button addButton(String string, Object object) {
        return StaticView.addButton(this.buttons, string, object);
    }

    public void close() {
        this.requestedClose = true;
    }

    @Override
    public void draw(Draw2D draw2D) {
        ViewBase.draw(draw2D, this);
    }

    public String getInput() {
        return this.inputBuffer.toString();
    }

    public int getInputLength() {
        return this.inputBuffer.length();
    }

    public Button getSelectedButton() {
        if (0 <= this.buttonIndex && this.buttonIndex < this.buttons.size()) {
            return this.buttons.get(this.buttonIndex);
        }
        return null;
    }

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
    }

    @Override
    public void handleJoystick(JoystickEvent joystickEvent) {
        if (this.mode == Mode.Default) {
            if (!joystickEvent.down) {
                return;
            }
            boolean bl = false;
            CommandEvent commandEvent = InputMapper.translate(joystickEvent, (IHandler)this);
            if (commandEvent == null) {
                return;
            }
            switch (commandEvent) {
                case PREVIOUS: {
                    if (this.buttons.size() <= 0) break;
                    --this.buttonIndex;
                    if (this.buttonIndex >= 0) break;
                    this.buttonIndex = this.buttons.size() - 1;
                    break;
                }
                case NEXT: {
                    if (this.buttons.size() <= 0) break;
                    this.buttonIndex = (this.buttonIndex + 1) % this.buttons.size();
                    break;
                }
                case CONFIRM: 
                case CANCEL: 
                case TAB_RIGHT: 
                case TAB_LEFT: {
                    bl = true;
                    break;
                }
            }
            this.handleCommand(commandEvent, joystickEvent);
            this.updateUI(bl);
        } else if (this.mode == Mode.Input) {
            // empty if block
        }
    }

    @Override
    public void handleKeyboard(KeyboardEvent keyboardEvent) {
        if (this.mode == Mode.Default) {
            if (!keyboardEvent.down) {
                return;
            }
            CommandEvent commandEvent = InputMapper.translate(keyboardEvent, (IHandler)this);
            if (commandEvent == null) {
                return;
            }
            int n = InputMapper.getOptionIndex(commandEvent);
            if (0 <= n && n < this.buttons.size()) {
                this.buttonIndex = n;
                commandEvent = CommandEvent.CONFIRM;
            }
            boolean bl = false;
            switch (commandEvent) {
                case PREVIOUS: {
                    if (this.buttons.size() <= 0) break;
                    --this.buttonIndex;
                    if (this.buttonIndex >= 0) break;
                    this.buttonIndex = this.buttons.size() - 1;
                    break;
                }
                case NEXT: {
                    if (this.buttons.size() <= 0) break;
                    this.buttonIndex = (this.buttonIndex + 1) % this.buttons.size();
                    break;
                }
                case CONFIRM: 
                case CANCEL: 
                case TAB_RIGHT: 
                case TAB_LEFT: {
                    bl = true;
                    break;
                }
            }
            this.handleCommand(commandEvent, keyboardEvent);
            this.updateUI(bl);
        } else if (this.mode == Mode.Input) {
            if (!keyboardEvent.down) {
                return;
            }
            char c = (char)keyboardEvent.key;
            switch (keyboardEvent.key) {
                case 256: {
                    this.handleCommand(CommandEvent.CANCEL, null);
                    this.updateUI(true);
                    break;
                }
                case 257: {
                    this.handleCommand(CommandEvent.CONFIRM, null);
                    this.updateUI(true);
                    break;
                }
                case 259: {
                    if (this.inputBuffer.length() <= 0) break;
                    this.inputBuffer.setLength(this.inputBuffer.length() - 1);
                    break;
                }
                default: {
                    if (this.inputBuffer.length() >= this.maxInputLength || (this.inputType != InputType.String || !this.isValidChar(c)) && (this.inputType != InputType.Integer || !this.isValidNumber(c))) break;
                    this.inputBuffer.append(c);
                }
            }
        }
    }

    @Override
    public void handleMouse(MouseEvent mouseEvent) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            Button button = this.buttons.get(i);
            if (!button.rect.contains(mouseEvent.x, mouseEvent.y)) continue;
            CommandEvent commandEvent = null;
            if (this.buttonIndex != i) {
                this.buttonIndex = i;
                commandEvent = CommandEvent.UPDATE_SELECTION;
            }
            if (mouseEvent.down && mouseEvent.button == 0) {
                commandEvent = CommandEvent.CONFIRM;
            }
            if (commandEvent != null) {
                this.handleCommand(commandEvent, null);
                boolean bl = commandEvent == CommandEvent.CONFIRM;
                this.updateUI(bl);
            }
            return;
        }
        if (!mouseEvent.down && mouseEvent.button == 1) {
            this.handleCommand(CommandEvent.CANCEL, null);
            this.updateUI(true);
        }
    }

    public void init() {
        this.updateUI(true);
    }

    private boolean isValidChar(char c) {
        return 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == ' ';
    }

    private boolean isValidNumber(char c) {
        return '0' <= c && c <= '9';
    }

    public void open(IHandler iHandler) {
        Hexen.getInstance().handler.pushHandler(iHandler);
    }

    public void popState() {
        if (this.states.isEmpty()) {
            this.requestedPop = true;
        } else {
            State state = this.states.pop();
            this.state = state.state;
            this.buttonIndex = state.buttonIndex;
        }
    }

    public void pushState(int n) {
        this.states.push(new State(this.state, this.buttonIndex));
        this.state = n;
        this.buttonIndex = 0;
    }

    @Override
    public boolean requestedClose() {
        return this.requestedClose;
    }

    @Override
    public boolean requestedPop() {
        return this.requestedPop;
    }

    public void resetInput() {
        this.inputBuffer.setLength(0);
    }

    public void resetState() {
        while (!this.states.isEmpty()) {
            this.popState();
        }
    }

    public void setInput(String string) {
        this.inputBuffer.setLength(0);
        this.inputBuffer.append(string);
    }

    public void setMode(Mode mode) {
        this.setMode(mode, InputType.String);
    }

    public void setMode(Mode mode, InputType inputType) {
        this.mode = mode;
        this.inputType = inputType;
        switch (inputType.ordinal()) {
            case 1: {
                this.maxInputLength = 9;
                break;
            }
            default: {
                this.maxInputLength = 14;
            }
        }
        this.inputBuffer.setLength(0);
    }

    public void setScene(Scene scene) {
        this.scene.set(scene);
        MessageBus.push(Message.SCENE_CHANGED, scene);
    }

    public void sortButtons() {
        this.buttons.sort((button, button2) -> Integer.compare(button.sorting, button2.sorting));
        StaticView.layout(this.buttons);
    }

    @Override
    public void update() {
        this.updateUI(true);
    }

    public void updateButtons() {
    }

    public void updateLeftText() {
    }

    public void updateRightText() {
    }

    public void updateScene() {
    }

    private void updateUI(boolean bl) {
        if (bl) {
            this.buttons.clear();
            this.updateButtons();
            if (this.buttonIndex >= this.buttons.size()) {
                this.buttonIndex = this.buttons.size() > 0 ? this.buttons.size() - 1 : 0;
            }
        }
        this.updateScene();
        this.updateLeftText();
        this.updateRightText();
        if (this.leftText != null) {
            this.leftText = this.rightText != null ? Strings.wwrap(this.leftText, 28) : Strings.wwrap(this.leftText, 54);
            if (bl) {
                int n = Strings.getNumLines(this.leftText);
                for (Button button : this.buttons) {
                    button.rect.y += (float)(n * 8);
                }
            }
        }
        if (this.rightText != null) {
            this.rightText = Strings.wwrap(this.rightText, 24);
        }
    }

    public static enum Mode {
        Default,
        Input;

    }

    public static enum InputType {
        String,
        Integer;

    }

    public static class State {
        public int state = 0;
        public int buttonIndex = 0;

        public State(int n, int n2) {
            this.state = n;
            this.buttonIndex = n2;
        }
    }
}

