/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.bank.Bank;
import de.slashbinbash.hexen.event.EventData;
import de.slashbinbash.hexen.general.Ask;
import de.slashbinbash.hexen.general.General;
import de.slashbinbash.hexen.guild.Guild;
import de.slashbinbash.hexen.guild.Hire;
import de.slashbinbash.hexen.guild.Retire;
import de.slashbinbash.hexen.guild.Train;
import de.slashbinbash.hexen.handler.AskHandler;
import de.slashbinbash.hexen.handler.BankHandler;
import de.slashbinbash.hexen.handler.BuyHandler;
import de.slashbinbash.hexen.handler.DonateHandler;
import de.slashbinbash.hexen.handler.EventHandler;
import de.slashbinbash.hexen.handler.GuildHandler;
import de.slashbinbash.hexen.handler.HandlerBase;
import de.slashbinbash.hexen.handler.HealHandler;
import de.slashbinbash.hexen.handler.HireHandler;
import de.slashbinbash.hexen.handler.IHandler;
import de.slashbinbash.hexen.handler.IdentifyHandler;
import de.slashbinbash.hexen.handler.PrayHandler;
import de.slashbinbash.hexen.handler.RestHandler;
import de.slashbinbash.hexen.handler.RetireHandler;
import de.slashbinbash.hexen.handler.SellHandler;
import de.slashbinbash.hexen.handler.TradeHandler;
import de.slashbinbash.hexen.handler.TrainHandler;
import de.slashbinbash.hexen.handler.TravelHandler;
import de.slashbinbash.hexen.inn.Rest;
import de.slashbinbash.hexen.shop.Buy;
import de.slashbinbash.hexen.shop.Identify;
import de.slashbinbash.hexen.shop.Sell;
import de.slashbinbash.hexen.shop.Trade;
import de.slashbinbash.hexen.temple.Donate;
import de.slashbinbash.hexen.temple.Heal;
import de.slashbinbash.hexen.temple.Pray;
import de.slashbinbash.hexen.travel.Travel;

public class GeneralHandler
extends HandlerBase {
    private General general = null;

    private IHandler createHandler(General.Entry entry) {
        Object object = entry.data;
        if (object instanceof Ask.Data) {
            Ask.Data data = (Ask.Data)object;
            object = new AskHandler(this);
            ((AskHandler)object).init(new Ask(data));
            return object;
        }
        if (entry.data instanceof Bank) {
            object = new BankHandler();
            ((HandlerBase)object).init();
            return object;
        }
        object = entry.data;
        if (object instanceof Buy.Data) {
            Buy.Data data = (Buy.Data)object;
            object = new BuyHandler(this);
            ((BuyHandler)object).init(new Buy(data));
            return object;
        }
        object = entry.data;
        if (object instanceof Donate.Data) {
            Donate.Data data = (Donate.Data)object;
            object = new DonateHandler(this);
            ((DonateHandler)object).init(new Donate(data));
            return object;
        }
        object = entry.data;
        if (object instanceof Guild.Data) {
            Guild.Data data = (Guild.Data)object;
            object = RPG.getInstance().guildSystem.createState(data.__id__);
            GuildHandler guildHandler = new GuildHandler(this);
            guildHandler.init(new Guild(data, (Guild.State)object));
            return guildHandler;
        }
        object = entry.data;
        if (object instanceof Heal.Data) {
            Heal.Data data = (Heal.Data)object;
            object = new HealHandler(this);
            ((HealHandler)object).init(new Heal(data));
            return object;
        }
        object = entry.data;
        if (object instanceof Hire.Data) {
            Hire.Data data = (Hire.Data)object;
            object = new HireHandler(this);
            ((HireHandler)object).init(new Hire(data));
            return object;
        }
        object = entry.data;
        if (object instanceof Identify.Data) {
            Identify.Data data = (Identify.Data)object;
            object = new IdentifyHandler(this);
            ((IdentifyHandler)object).init(new Identify(data));
            return object;
        }
        object = entry.data;
        if (object instanceof Pray.Data) {
            Pray.Data data = (Pray.Data)object;
            object = new PrayHandler(this);
            ((PrayHandler)object).init(new Pray(data));
            return object;
        }
        object = entry.data;
        if (object instanceof Rest.Data) {
            Rest.Data data = (Rest.Data)object;
            object = new RestHandler(this);
            ((RestHandler)object).init(new Rest(data));
            return object;
        }
        if (entry.data instanceof Retire.Data) {
            object = new RetireHandler(this);
            ((HandlerBase)object).init();
            return object;
        }
        object = entry.data;
        if (object instanceof Sell.Data) {
            Sell.Data data = (Sell.Data)object;
            object = new SellHandler(this);
            ((SellHandler)object).init(new Sell(data));
            return object;
        }
        object = entry.data;
        if (object instanceof EventData) {
            EventData eventData = (EventData)object;
            object = new EventHandler();
            ((EventHandler)object).init(eventData);
            return object;
        }
        object = entry.data;
        if (object instanceof Trade.Data) {
            Trade.Data data = (Trade.Data)object;
            object = new TradeHandler(this);
            ((TradeHandler)object).init(new Trade(data));
            return object;
        }
        object = entry.data;
        if (object instanceof Train.Data) {
            Train.Data data = (Train.Data)object;
            object = new TrainHandler(this);
            ((TrainHandler)object).init(new Train(data));
            return object;
        }
        object = entry.data;
        if (object instanceof Travel.Data) {
            Travel.Data data = (Travel.Data)object;
            object = new TravelHandler(this);
            ((TravelHandler)object).init(new Travel(data));
            return object;
        }
        return null;
    }

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
        switch (commandEvent) {
            case CONFIRM: {
                General.Entry entry = (General.Entry)super.getSelectedButton().data;
                IHandler iHandler = this.createHandler(entry);
                if (iHandler == null) break;
                super.open(iHandler);
                break;
            }
            case CANCEL: {
                super.popState();
                break;
            }
        }
    }

    public void init(General general) {
        this.general = general;
        super.init();
    }

    @Override
    public void updateButtons() {
        for (General.Entry entry : this.general._data.entries) {
            super.addButton(entry.label, entry);
        }
    }

    @Override
    public void updateLeftText() {
        this.leftText = null;
    }

    @Override
    public void updateRightText() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.general._data.description != null) {
            stringBuilder.append(this.general._data.description).append("\n\n");
        }
        this.rightText = stringBuilder.toString();
    }

    @Override
    public void updateScene() {
        if (this.general._data.scene != null) {
            super.setScene(this.general._data.scene);
        } else {
            this.scene.portrait = "handler";
            this.scene.portraitTitle = "Handler";
            super.setScene(this.scene);
        }
    }
}

