/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.StaticRPG;
import de.slashbinbash.hexen.guild.Guild;
import de.slashbinbash.hexen.guild.GuildFactory;
import de.slashbinbash.hexen.handler.HandlerBase;
import de.slashbinbash.hexen.model.Party;

public class GameOverHandler
extends HandlerBase {
    private static final int STATE_PICK = 0;
    private static final int SHOW_MESSAGE = 1;

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
        if (this.state == 1) {
            super.popState();
            return;
        }
        if (commandEvent == CommandEvent.CONFIRM) {
            switch (this.state) {
                case 0: {
                    Action action = (Action)((Object)super.getSelectedButton().data);
                    switch (action.ordinal()) {
                        case 1: {
                            RPG rPG = RPG.getInstance();
                            String string = rPG.party.guild;
                            if (string == null) break;
                            Guild.Data data = GuildFactory.createGuildData(string);
                            Guild.Location location = data.location;
                            rPG.party = new Party();
                            StaticRPG.move(rPG.party, location.map, location.level, location.x, location.y);
                            super.close();
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 0: {
                            break;
                        }
                    }
                    break;
                }
            }
        }
    }

    private void showMessage(String string, Object ... objectArray) {
        this.leftText = String.format(string, objectArray);
        this.pushState(1);
    }

    @Override
    public void updateButtons() {
        switch (this.state) {
            case 0: {
                super.addButton("Load Save", (Object)Action.LoadSave);
                super.addButton("Abandon party", (Object)Action.AbandonParty);
                super.addButton("Leave party", (Object)Action.LeaveParty);
                break;
            }
            case 1: {
                break;
            }
        }
    }

    @Override
    public void updateLeftText() {
        this.leftText = null;
    }

    @Override
    public void updateRightText() {
        this.rightText = null;
    }

    @Override
    public void updateScene() {
        this.scene.portrait = "gameover";
        this.scene.portraitTitle = "Game Over";
        super.setScene(this.scene);
    }

    public static enum Action {
        LoadSave,
        AbandonParty,
        LeaveParty;

    }
}

