/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.event.Event;
import de.slashbinbash.hexen.event.EventData;
import de.slashbinbash.hexen.event.EventOption;
import de.slashbinbash.hexen.event.EventState;
import de.slashbinbash.hexen.handler.HandlerBase;
import de.slashbinbash.hexen.struct.Vars;

public class EventHandler
extends HandlerBase {
    public EventState eventState = null;

    public EventState getEvent() {
        return this.eventState;
    }

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
        block12: {
            block11: {
                if (this.mode != HandlerBase.Mode.Default) break block11;
                if (!this.eventState.hasOptions()) {
                    assert (this.buttons.isEmpty());
                    if (commandEvent == CommandEvent.CONFIRM) {
                        this.eventState.handleEOF(null);
                        return;
                    }
                }
                switch (commandEvent) {
                    case CONFIRM: {
                        EventOption eventOption = (EventOption)super.getSelectedButton().data;
                        if (eventOption != null) {
                            this.eventState.pick(eventOption);
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block12;
            }
            if (this.mode == HandlerBase.Mode.Input) {
                switch (commandEvent) {
                    case CONFIRM: {
                        String string = super.getInput().toLowerCase();
                        this.eventState.input(string);
                        break;
                    }
                }
            }
        }
    }

    public void init(EventData eventData) {
        Event.State state = RPG.getInstance().eventSystem.getState(eventData.id);
        EventState eventState = new EventState(eventData, state);
        eventState.run();
        this.init(eventState);
    }

    public void init(EventState eventState) {
        this.eventState = eventState;
        this.scene = eventState.scene;
        if (eventState.input != null) {
            this.setMode(HandlerBase.Mode.Input);
        }
        super.init();
    }

    public String resolveArgs(String string, Vars vars) {
        if (string.indexOf(37) == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == '%') {
                if (bl) {
                    String string2 = string.substring(n + 1, n2);
                    if (vars.has(string2)) {
                        stringBuilder.append(vars.get(string2).toString());
                    } else {
                        stringBuilder.append("%");
                        stringBuilder.append(string2);
                        stringBuilder.append("%");
                    }
                    bl = false;
                    ++n2;
                    continue;
                }
                n = n2;
                bl = true;
            }
            if (!bl) {
                stringBuilder.append(c);
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    @Override
    public void updateButtons() {
        if (this.mode == HandlerBase.Mode.Default) {
            int n = 1;
            for (EventOption eventOption : this.eventState.options) {
                if (!eventOption.visible) continue;
                String string = this.resolveArgs(eventOption.text, this.eventState.vars);
                String string2 = null;
                string2 = eventOption.enabled ? String.format("%d. %s", n, string) : String.format("-. %s", string);
                super.addButton(string2, eventOption);
                ++n;
            }
        }
    }

    @Override
    public void updateLeftText() {
        this.leftText = this.resolveArgs(this.eventState.text, this.eventState.vars) + "\n";
    }
}

