/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.StaticRPG;
import de.slashbinbash.hexen.door.Door;
import de.slashbinbash.hexen.door.StaticDoor;
import de.slashbinbash.hexen.handler.HandlerBase;
import de.slashbinbash.hexen.message.Message;
import de.slashbinbash.hexen.message.MessageBus;
import de.slashbinbash.hexen.ui.Button;

public class DoorHandler
extends HandlerBase {
    private static final int SHOW_OPTIONS = 0;
    private static final int SHOW_MESSAGE = 1;
    private static final int QUIT_MESSAGE = 2;
    private static final int INPUT_PASSWORD = 3;
    private Door door = null;
    private boolean triedInspect = false;

    private void addButton(Action action) {
        String string = null;
        switch (action.ordinal()) {
            case 0: {
                string = "Open";
                break;
            }
            case 3: {
                string = "Lockpick";
                break;
            }
            case 2: {
                string = "Unlock with key";
                break;
            }
            case 1: {
                string = "Inspect";
                break;
            }
            case 5: {
                string = "Back";
                break;
            }
            case 4: {
                string = "Use password";
                break;
            }
            default: {
                string = action.name();
            }
        }
        super.addButton(string, (Object)action);
    }

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
        switch (this.state) {
            case 0: {
                this.handleShowOptions(commandEvent, object);
                break;
            }
            case 1: {
                if (commandEvent != CommandEvent.CONFIRM && commandEvent != CommandEvent.CANCEL) break;
                this.resetState();
                break;
            }
            case 3: {
                this.handleInputPassword(commandEvent, object);
                break;
            }
            case 2: {
                MessageBus.push(Message.STATE_POP, null);
            }
        }
    }

    private void handleInputPassword(CommandEvent commandEvent, Object object) {
        switch (commandEvent) {
            case CONFIRM: {
                String string = this.getInput().toLowerCase();
                if (string.equals(this.door._data.lock.password)) {
                    this.door.state.lock_unlocked = true;
                    super.setMode(HandlerBase.Mode.Default);
                    this.quitMessage("Unlocked door.");
                    break;
                }
                this.resetState();
                break;
            }
            case CANCEL: {
                this.popState();
                super.setMode(HandlerBase.Mode.Default);
                break;
            }
        }
    }

    private void handleShowOptions(CommandEvent commandEvent, Object object) {
        block0 : switch (commandEvent) {
            case CONFIRM: {
                Action action = (Action)((Object)((Button)this.buttons.get((int)this.buttonIndex)).data);
                switch (action.ordinal()) {
                    case 5: {
                        this.popState();
                        break block0;
                    }
                    case 1: {
                        this.triedInspect = true;
                        if (!this.door.hasLock()) break block0;
                        if (this.door._data.lock.perceptionCheck != null) {
                            if (this.door._data.lock.perceptionCheck.check(null)) {
                                this.door.state.lock_detected = true;
                                break block0;
                            }
                            this.door.state.lock_detected = false;
                            break block0;
                        }
                        this.door.state.lock_detected = true;
                        break block0;
                    }
                    case 3: {
                        StaticRPG.Result result = StaticDoor.lockpickLock(this.door);
                        switch (result) {
                            case SUCCESS: {
                                this.door.state.lock_unlocked = true;
                                this.quitMessage("Unlocked door.");
                                break block0;
                            }
                            case ITEM_NOT_EXIST: {
                                this.showMessage("You need a lockpick.");
                                break block0;
                            }
                            case SKILL_CHECK_FAIL: {
                                String string = this.door._data.lock.lockpickingCheck.ability.name;
                                int n = this.door._data.lock.lockpickingCheck.dc;
                                this.showMessage(String.format("You fail to lockpick the lock. [%s=%d]", string, n));
                                break block0;
                            }
                            case SKILL_CHECK_FAIL_ITEM_BREAK: {
                                String string = this.door._data.lock.lockpickingCheck.ability.name;
                                int n = this.door._data.lock.lockpickingCheck.dc;
                                this.showMessage(String.format("Your lockpick breaks. [%s=%d]", string, n));
                                break block0;
                            }
                            case FAILURE: {
                                this.showMessage("Your lockpick breaks.");
                                break block0;
                            }
                        }
                        this.showMessage("UNKNOWN RESULT " + String.valueOf((Object)result));
                        break block0;
                    }
                    case 0: {
                        if (!this.door.isLocked()) break block0;
                        this.showMessage("Door is locked.");
                        break block0;
                    }
                    case 4: {
                        this.pushState(3);
                        this.setMode(HandlerBase.Mode.Input);
                        break block0;
                    }
                    case 2: {
                        StaticRPG.Result result = StaticDoor.unlockLock(this.door);
                        switch (result) {
                            case SUCCESS: {
                                this.door.state.lock_unlocked = true;
                                this.quitMessage("Unlocked door.");
                                break block0;
                            }
                            case FAILURE: {
                                this.showMessage("Failed to unlock door.");
                                break block0;
                            }
                            case ITEM_NOT_EXIST: {
                                this.showMessage("You need a key.");
                                break block0;
                            }
                        }
                        this.showMessage("UNKNOWN RESULT " + String.valueOf((Object)result));
                        break block0;
                    }
                }
                break;
            }
            case CANCEL: {
                super.popState();
                break;
            }
        }
    }

    public void init(Door door) {
        this.door = door;
        this.state = 0;
        super.init();
    }

    private void quitMessage(String string) {
        this.leftText = string;
        this.pushState(2);
    }

    private void showMessage(String string) {
        this.leftText = string;
        this.pushState(1);
    }

    @Override
    public void updateButtons() {
        switch (this.state) {
            case 0: {
                this.addButton(Action.Open);
                if (this.triedInspect) {
                    if (!this.door.hasLock() || !this.door.isLocked() || !this.door.state.lock_detected) break;
                    this.addButton(Action.Lockpick);
                    this.addButton(Action.Unlock);
                    if (!this.door.hasPassword()) break;
                    this.addButton(Action.Password);
                    break;
                }
                this.addButton(Action.Inspect);
                break;
            }
        }
    }

    @Override
    public void updateLeftText() {
        switch (this.state) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                this.leftText = null;
            }
        }
    }

    @Override
    public void updateScene() {
        if (this.door._data.scene != null) {
            super.setScene(this.door._data.scene);
        } else {
            this.scene.portrait = "door";
            this.scene.portraitTitle = "Door";
            super.setScene(this.scene);
        }
    }

    private static enum Action {
        Open,
        Inspect,
        Unlock,
        Lockpick,
        Password,
        Cancel;

    }
}

