/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.handler.HandlerBase;
import de.slashbinbash.hexen.model.Inventory;
import de.slashbinbash.hexen.temple.Donate;
import de.slashbinbash.hexen.temple.StaticDonate;

public class DonateHandler
extends HandlerBase {
    private static final int INPUT = 0;
    private static final int SHOW_MESSAGE = 1;
    private Donate donate = null;

    public DonateHandler(HandlerBase handlerBase) {
        super.setScene(handlerBase.scene);
    }

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
        if (this.state == 0) {
            switch (commandEvent) {
                case CONFIRM: {
                    Inventory inventory = RPG.getInstance().party.inventory;
                    String string = super.getInput();
                    if (string.isEmpty()) {
                        super.popState();
                        break;
                    }
                    int n = Integer.valueOf(super.getInput());
                    if (n <= inventory.getCurrency()) {
                        inventory.removeCurrency(n);
                        StaticDonate.donate(this.donate._data.donationId, n);
                        String string2 = String.format("You donated %d currency to %s.\n\n%s", n, this.donate._data.label, this.donate._data.text);
                        this.showMessage(string2);
                        break;
                    }
                    this.showMessage("Not enough currency.");
                    break;
                }
                case CANCEL: {
                    super.popState();
                    break;
                }
            }
        } else if (this.state == 1) {
            switch (commandEvent) {
                case CONFIRM: 
                case CANCEL: {
                    super.popState();
                    super.setMode(HandlerBase.Mode.Input, HandlerBase.InputType.Integer);
                    break;
                }
            }
        }
    }

    public void init(Donate donate) {
        this.donate = donate;
        super.init();
        super.setMode(HandlerBase.Mode.Input, HandlerBase.InputType.Integer);
    }

    private void showMessage(String string) {
        this.leftText = string;
        super.pushState(1);
        super.setMode(HandlerBase.Mode.Default);
    }

    @Override
    public void updateButtons() {
    }

    @Override
    public void updateLeftText() {
        switch (this.state) {
            case 0: {
                this.leftText = "DONATION";
                break;
            }
            case 1: {
                break;
            }
            default: {
                this.leftText = null;
            }
        }
    }

    @Override
    public void updateRightText() {
        this.rightText = null;
    }

    @Override
    public void updateScene() {
        if (this.donate._data.scene != null) {
            super.setScene(this.donate._data.scene);
        }
    }
}

