/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.handler;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.bank.BankSystem;
import de.slashbinbash.hexen.handler.HandlerBase;

public class BankHandler
extends HandlerBase {
    private static final int STATE_PICK = 0;
    private static final int STATE_INPUT = 1;
    private static final int SHOW_MESSAGE = 2;
    private Action selectedAction = null;
    private final BankSystem bank;

    public BankHandler() {
        this.bank = RPG.getInstance().bankSystem;
    }

    @Override
    public void handleCommand(CommandEvent commandEvent, Object object) {
        switch (this.state) {
            case 0: {
                this.handlePick(commandEvent, object);
                break;
            }
            case 1: {
                this.handleInput(commandEvent, object);
                break;
            }
        }
    }

    private void handlePick(CommandEvent commandEvent, Object object) {
        switch (commandEvent) {
            case CONFIRM: {
                this.selectedAction = (Action)((Object)super.getSelectedButton().data);
                super.pushState(1);
                super.setMode(HandlerBase.Mode.Input, HandlerBase.InputType.Integer);
                break;
            }
            case CANCEL: {
                super.popState();
                break;
            }
        }
    }

    private void handleInput(CommandEvent commandEvent, Object object) {
        switch (commandEvent) {
            case CONFIRM: {
                String string = super.getInput();
                if (string.isEmpty()) break;
                int n = Integer.valueOf(string);
                switch (this.selectedAction.ordinal()) {
                    case 0: {
                        int n2 = RPG.getInstance().party.inventory.countCurrency();
                        int n3 = Math.min(n, n2);
                        RPG.getInstance().party.inventory.removeCurrency(n3);
                        this.bank.currency += n3;
                        break;
                    }
                    case 1: {
                        int n4 = Math.min(n, this.bank.currency);
                        this.bank.currency -= n4;
                        RPG.getInstance().party.inventory.addCurrency(n4);
                        break;
                    }
                }
                super.popState();
                super.setMode(HandlerBase.Mode.Default);
                break;
            }
            case CANCEL: {
                super.popState();
                super.setMode(HandlerBase.Mode.Default);
                break;
            }
        }
    }

    @Override
    public void updateButtons() {
        switch (this.state) {
            case 0: {
                super.addButton("Deposit", (Object)Action.Deposit);
                super.addButton("Withdraw", (Object)Action.Withdraw);
                break;
            }
        }
    }

    @Override
    public void updateLeftText() {
        block0 : switch (this.state) {
            case 1: {
                switch (this.selectedAction.ordinal()) {
                    case 0: {
                        this.leftText = "DEPOSIT";
                        break block0;
                    }
                    case 1: {
                        this.leftText = "WITHDRAW";
                        break block0;
                    }
                }
                this.leftText = null;
                break;
            }
            default: {
                this.leftText = null;
            }
        }
    }

    @Override
    public void updateRightText() {
        this.rightText = "BALANCE\n$" + this.bank.currency;
    }

    @Override
    public void updateScene() {
        this.scene.portrait = "bank";
        this.scene.portraitTitle = "Bank";
    }

    private static enum Action {
        Deposit,
        Withdraw;

    }
}

