/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.guild;

import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.factory.CreatureFactory;
import de.slashbinbash.hexen.guild.Hire;
import de.slashbinbash.hexen.model.ClassCreature;

public class StaticHire {
    public static Result canHire(Hire.Data.Entry entry) {
        if (StaticHire.isInParty(entry.creature)) {
            return Result.ALREADY_IN_PARTY;
        }
        if (StaticHire.isInGuild(entry.creature)) {
            return Result.ALREADY_IN_GUILD;
        }
        if (StaticHire.isInDeadpool(entry.creature)) {
            return Result.ALREADY_IN_DEADPOOL;
        }
        return Result.OK;
    }

    public static Result canHireAndPay(Hire.Data.Entry entry) {
        RPG rPG = RPG.getInstance();
        if (StaticHire.isInParty(entry.creature)) {
            return Result.ALREADY_IN_PARTY;
        }
        if (StaticHire.isInGuild(entry.creature)) {
            return Result.ALREADY_IN_GUILD;
        }
        if (StaticHire.isInDeadpool(entry.creature)) {
            return Result.ALREADY_IN_DEADPOOL;
        }
        if (rPG.party.inventory.getCurrency() < entry.cost) {
            return Result.NOT_ENOUGH_MONEY;
        }
        if (rPG.party.isFull()) {
            return Result.PARTY_FULL;
        }
        return Result.OK;
    }

    public static Result hire(Hire.Data.Entry entry, float f) {
        RPG rPG = RPG.getInstance();
        Result result = StaticHire.canHireAndPay(entry);
        if (result != Result.OK) {
            return result;
        }
        int n = entry.cost;
        rPG.party.inventory.removeCurrency(n);
        ClassCreature classCreature = CreatureFactory.createCreature(entry.creature.__id__);
        classCreature.timeStarted = RPG.getInstance().timeSeconds;
        classCreature.vim = (int)((float)classCreature.vim * f);
        rPG.party.addMember(classCreature);
        return Result.OK;
    }

    public static boolean isInDeadpool(ClassCreature classCreature) {
        return RPG.getInstance().deadpoolSystem.contains(classCreature);
    }

    public static boolean isInGuild(ClassCreature classCreature) {
        return RPG.getInstance().guildSystem.contains(classCreature);
    }

    public static boolean isInParty(ClassCreature classCreature) {
        RPG rPG = RPG.getInstance();
        for (ClassCreature classCreature2 : rPG.party.getMembers()) {
            if (!classCreature.__id__.equals(classCreature2.__id__)) continue;
            return true;
        }
        return false;
    }

    public static enum Result {
        OK,
        ALREADY_IN_PARTY,
        ALREADY_IN_GUILD,
        ALREADY_IN_DEADPOOL,
        NOT_ENOUGH_MONEY,
        PARTY_FULL;

    }
}

