/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.guild;

import de.slashbinbash.hexen.enums.Ability;
import de.slashbinbash.hexen.factory.CombatActionFactory;
import de.slashbinbash.hexen.factory.CreatureFactory;
import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.factory.SceneFactory;
import de.slashbinbash.hexen.general.General;
import de.slashbinbash.hexen.general.GeneralFactory;
import de.slashbinbash.hexen.guild.Guild;
import de.slashbinbash.hexen.guild.Hire;
import de.slashbinbash.hexen.guild.Retire;
import de.slashbinbash.hexen.guild.Train;
import de.slashbinbash.hexen.model.ClassCreature;
import de.slashbinbash.hexen.model.CombatAction;
import de.slashbinbash.hexen.model.Trait;
import de.slashbinbash.util.StaticXML;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GuildFactory {
    private static List<Train.Data.AbilityEntry> createAbilities(Element element) {
        ArrayList<Train.Data.AbilityEntry> arrayList = new ArrayList<Train.Data.AbilityEntry>();
        for (Element element2 : StaticXML.getChildElements(element)) {
            Train.Data.AbilityEntry abilityEntry = new Train.Data.AbilityEntry();
            abilityEntry.ability = Ability.valueOf(StaticXML.getAttribute(element2, "ref"));
            abilityEntry.max = StaticXML.getInt(element2, "max", 20);
            arrayList.add(abilityEntry);
        }
        return arrayList;
    }

    private static List<CombatAction> createCombatActions(Element element) {
        ArrayList<CombatAction> arrayList = new ArrayList<CombatAction>();
        for (Element element2 : StaticXML.getChildElements(element)) {
            String string = StaticXML.getAttribute(element2, "ref");
            arrayList.add(CombatActionFactory.createCombatAction(string));
        }
        return arrayList;
    }

    private static List<Trait> createTraits(Element element) {
        ArrayList<Trait> arrayList = new ArrayList<Trait>();
        for (Element element2 : StaticXML.getChildElements(element)) {
            String string = StaticXML.getAttribute(element2, "ref");
            arrayList.add(Trait.valueOf(string));
        }
        return arrayList;
    }

    public static General.Data createGuilderData(String string) {
        return GeneralFactory.createGenericData(Factory.GUILD_PATH, string);
    }

    public static Hire.Data createHireData(Element element) {
        Hire.Data data = new Hire.Data();
        data.vimRatio = StaticXML.getFloat(element, "vimRatio", 1.0f);
        block6: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "creature": {
                    ClassCreature classCreature = CreatureFactory.createCreature(StaticXML.getAttribute(element2, "ref"));
                    int n = StaticXML.getInt(element2, "cost");
                    data.entries.add(new Hire.Data.Entry(classCreature, n));
                    continue block6;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return data;
    }

    public static Retire.Data createRetireData(Element element) {
        Retire.Data data = new Retire.Data();
        block6: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "scene": {
                    data.scene = SceneFactory.createScene(element2);
                    continue block6;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return data;
    }

    public static Train.Data createTrainData(Element element) {
        Train.Data data = new Train.Data();
        for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "class": {
                    data.job = StaticXML.getText(element2);
                    break;
                }
                case "abilities": {
                    data.abilities = GuildFactory.createAbilities(element2);
                    break;
                }
                case "combatActions": {
                    data.combatActions = GuildFactory.createCombatActions(element2);
                    break;
                }
                case "traits": {
                    data.traits = GuildFactory.createTraits(element2);
                }
            }
        }
        return data;
    }

    public static Guild.Data createGuildData(String string) {
        try {
            File file = new File(Factory.GUILD_PATH + string + ".xml");
            Document document = StaticXML.loadXML(file);
            Element element = document.getDocumentElement();
            Element element2 = StaticXML.getElement(element, "guild");
            return GuildFactory.createGuildData(element2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Guild.Data createGuildData(Element element) {
        Guild.Data data = new Guild.Data();
        data.__id__ = StaticXML.getAttribute(element, "id");
        if (StaticXML.hasAttribute(element, "label")) {
            data.label = StaticXML.getAttribute(element, "label");
        }
        block14: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "name": {
                    data.name = StaticXML.getText(element2);
                    continue block14;
                }
                case "canJoin": {
                    data.canJoin = Boolean.valueOf(StaticXML.getText(element2));
                    continue block14;
                }
                case "takesLiving": {
                    data.takesLiving = Boolean.valueOf(StaticXML.getText(element2));
                    continue block14;
                }
                case "takesDead": {
                    data.takesDead = Boolean.valueOf(StaticXML.getText(element2));
                    continue block14;
                }
                case "location": {
                    Guild.Location location = new Guild.Location();
                    location.map = StaticXML.getAttribute(element2, "map");
                    location.level = StaticXML.getInt(element2, "level");
                    location.x = StaticXML.getInt(element2, "x");
                    location.y = StaticXML.getInt(element2, "y");
                    data.location = location;
                    continue block14;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return data;
    }
}

