/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.factory;

import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.factory.ModifierFactory;
import de.slashbinbash.hexen.model.Trait;
import de.slashbinbash.hexen.model.Traits;
import de.slashbinbash.hexen.struct.CacheMap;
import de.slashbinbash.util.StaticXML;
import java.io.File;
import java.util.Collection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TraitFactory {
    private static CacheMap<Trait> cache = new CacheMap();

    public static void clear() {
        cache.clear();
    }

    public static void load() {
        assert (cache.isEmpty());
        File file = new File(Factory.TRAIT_PATH);
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            String string = fileArray[i].getName();
            String string2 = string.substring(0, string.indexOf(".xml"));
            File file2 = fileArray[i];
            try {
                Document document = StaticXML.loadXML(file2);
                Trait trait = new Trait();
                trait.id = string2;
                TraitFactory.initTrait(document.getDocumentElement(), trait);
                cache.put(string2, trait);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static Trait createTrait(Element element) {
        return TraitFactory.getTrait(StaticXML.getAttribute(element, "ref"));
    }

    public static Traits createTraits(Element element) {
        Traits traits = new Traits();
        for (Element element2 : StaticXML.getElements(element, "trait")) {
            Trait trait = TraitFactory.createTrait(element2);
            traits.add(trait);
        }
        return traits;
    }

    public static Trait getTrait(String string) {
        if (cache.containsKey(string)) {
            return cache.get(string);
        }
        throw new RuntimeException("No trait with id: " + string);
    }

    private static Trait initTrait(Element element, Trait trait) {
        block10: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "name": {
                    trait.name = StaticXML.getText(element2);
                    continue block10;
                }
                case "description": {
                    trait.description = StaticXML.getText(element2);
                    continue block10;
                }
                case "modifiers": {
                    trait.modifiers = ModifierFactory.createModifiers(element2);
                    continue block10;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return trait;
    }

    public static Collection<Trait> listTraits() {
        return cache.values();
    }
}

