/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.factory;

import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.model.Scene;
import de.slashbinbash.util.StaticXML;
import java.io.File;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SceneFactory {
    private static Scene.Sound createSound(String string, boolean bl, String string2) {
        Scene.Sound sound = new Scene.Sound();
        sound.id = string;
        sound.loop = bl;
        sound.layer = string2;
        return sound;
    }

    public static Scene createScene(String string) {
        Scene scene = new Scene();
        scene.__id__ = string;
        try {
            File file = new File(Factory.SCENE_PATH + string + ".xml");
            Document document = StaticXML.loadXML(file);
            SceneFactory.initScene(document.getDocumentElement(), scene);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            scene.portraitTitle = "ERR " + string;
        }
        return scene;
    }

    public static Scene createScene(Element element) {
        if (StaticXML.hasAttribute(element, "ref")) {
            return SceneFactory.createScene(StaticXML.getAttribute(element, "ref"));
        }
        return SceneFactory.initScene(element, new Scene());
    }

    private static Scene initScene(Element element, Scene scene) {
        ArrayList<Scene.Sound> arrayList = new ArrayList<Scene.Sound>();
        block10: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "portrait": {
                    scene.portrait = StaticXML.getAttribute(element2, "img");
                    scene.portraitTitle = StaticXML.getAttribute(element2, "title");
                    continue block10;
                }
                case "effect": {
                    arrayList.add(SceneFactory.createSound(StaticXML.getAttribute(element2, "id"), StaticXML.getBool(element2, "loop"), "Effect"));
                    continue block10;
                }
                case "music": {
                    arrayList.add(SceneFactory.createSound(StaticXML.getAttribute(element2, "id"), StaticXML.getBool(element2, "loop"), "Music"));
                    continue block10;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        scene.sounds = arrayList.toArray(new Scene.Sound[0]);
        return scene;
    }
}

