/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.factory;

import de.slashbinbash.hexen.check.CheckFactory;
import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.factory.ModifierFactory;
import de.slashbinbash.hexen.model.SlotItem;
import de.slashbinbash.util.StaticXML;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ModFactory {
    public static SlotItem createMod(String string) {
        return new SlotItem(ModFactory.createModDesc(string));
    }

    public static SlotItem.Data createModDesc(String string) {
        File file = new File(Factory.MOD_PATH + string + ".xml");
        try {
            Document document = StaticXML.loadXML(file);
            SlotItem.Data data = ModFactory.createModDesc(document.getDocumentElement());
            data.__id__ = string;
            return data;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    public static SlotItem.Data createModDesc(Element element) {
        if (StaticXML.hasAttribute(element, "ref")) {
            return ModFactory.createModDesc(StaticXML.getAttribute(element, "ref"));
        }
        SlotItem.Data data = new SlotItem.Data();
        block16: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "name": {
                    data.name = StaticXML.getText(element2);
                    continue block16;
                }
                case "description": {
                    data.description = StaticXML.hasText(element2) ? Factory.unformatMD(StaticXML.getText(element2)) : "";
                    continue block16;
                }
                case "value": {
                    data.value = Integer.valueOf(StaticXML.getText(element2));
                    continue block16;
                }
                case "slot": {
                    data.slotId = StaticXML.getText(element2);
                    continue block16;
                }
                case "requirements": {
                    data.requirements = CheckFactory.createChecks(element2);
                    continue block16;
                }
                case "modifiers": {
                    data.modifiers = ModifierFactory.createModifiers(element2);
                    continue block16;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return data;
    }
}

